package com.bcxin.ars.web.util;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.service.util.ConfigSignUtils;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SysDictUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ThirdPartyURL;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;

import javax.servlet.ServletContext;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

@Slf4j
@Service("webStartup")
public class WebStartup implements InitializingBean, DisposableBean, ServletContextAware, ApplicationContextAware {

    /***
     * 日志
     */
//	private Logger logger = Logger.getLogger(WebStartup.class);

	public static ApplicationContext appContext;

	public static ServletContext context;

	@Autowired
	private ConfigUtils configUtils;
	@Autowired
	private ConfigSignUtils configSignUtils;
	//wiki id 百保盾协作与知识分享平台
    @Value("${wikiId}")
    public String wikiId = "";

	@Autowired
	private SysDictUtils sysDictUtils;

	@Override
	public void setApplicationContext(ApplicationContext appContext) throws BeansException {
		WebStartup.appContext = appContext;
	}

	@Override
	public void setServletContext(ServletContext context) {
		WebStartup.context = context;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		//项目启动 初始化全部配置到缓存
		List<Config> configList = configUtils.initConfig();
		//加载处理签配置
		configSignUtils.getAllConfigSign();
		for (Config config : configList){
			context.setAttribute(config.getKey(), config.getValue());
		}
		context.setAttribute(Constants.BJ_ZRR_SINGLELOGIN_URL, configUtils.bj_zrr_singleLogin_url);
		context.setAttribute(Constants.BJ_ZRR_CLIENT_ID, configUtils.bj_zrr_client_id);

		// 增加开关，系统是否联网部署online
		Config onlineConfig = configUtils.getConfigByKey(Constants.ONLINE);
		int onlineFlag = 1;
		if (onlineConfig != null && onlineConfig.getValue() != null) {
			onlineFlag = Integer.valueOf(onlineConfig.getValue());
		}
		context.setAttribute("ONLINE_FLAG", onlineFlag);
		// 是否显示指纹录入
		Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
		String isShowFingerprint = "1";
		if (isShowFingerprintConfig != null && isShowFingerprintConfig.getValue() != null) {
			isShowFingerprint = isShowFingerprintConfig.getValue();
		}
		context.setAttribute("isShowFingerprint", isShowFingerprint);
		// 百联保地址
		Config coninsConfig = configUtils.getConfigByKey(Constants.CONINS);
		String coninsURL = "";
		if (coninsConfig != null && coninsConfig.getValue() != null) {
			coninsURL = coninsConfig.getValue();
		}
		context.setAttribute("coninsURL", coninsURL);

		// 百课堂地址
		Config bktUrlConfig = configUtils.getConfigByKey(Constants.BKT_URL);
		String bktUrl = "";
		if (bktUrlConfig != null && bktUrlConfig.getValue() != null) {
			bktUrl = bktUrlConfig.getValue();
		}
		context.setAttribute("bktURL", bktUrl);
		// 如果是离线地图的话，获取离线地图的地址
		if (onlineFlag == 0) {
			Config mapConfig = configUtils.getConfigByKey(Constants.MAP_URL);
			String ampURL = "";
			if (mapConfig != null && mapConfig.getValue() != null) {
				ampURL = mapConfig.getValue();
			}
			context.setAttribute("ampURL", ampURL);
		}

		/**
		 * web访问地址（主要用做培训订单支付）
		 */
		Config webHostConfig = configUtils.getConfigByKey(Constants.WEBHOST);

		if (webHostConfig != null) {
			String web_host = "";
			if (webHostConfig != null && webHostConfig.getValue() != null) {
				web_host = webHostConfig.getValue();
			}
			context.setAttribute("webHost", web_host);
		}


		/**
		 * 当前省份信息
		 */
		Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);

		if (provinceConfig != null) {
			String current_Province = "";
			if (provinceConfig != null && provinceConfig.getValue() != null) {
				current_Province = provinceConfig.getValue();
				//2018年8月14日14:41:57 wjb  同步增加地区标识
				Constants.APPROVAL_KEY=current_Province+"00";
			}
			context.setAttribute("currentProvince", current_Province);
		}

		/**
		 * 是否指派民警
		 */
		Config isPoliceConfig = configUtils.getConfigByKey(Constants.ISPOLICE);

		if (isPoliceConfig != null) {
			String is_Police = "";
			if (isPoliceConfig != null && isPoliceConfig.getValue() != null) {
				is_Police = isPoliceConfig.getValue();
			}
			context.setAttribute("isPolice", is_Police);
		}

		/**
		 * 是否显示指纹状态
		 */
		Config isShowFingercardStateConfig = configUtils.getConfigByKey(Constants.ISSHOWFINGERCARDSTATE);

		if (isShowFingercardStateConfig != null) {
			String is_ShowFingercardState = "";
			if (isShowFingercardStateConfig != null && isShowFingercardStateConfig.getValue() != null) {
				is_ShowFingercardState = isShowFingercardStateConfig.getValue();
			}
			context.setAttribute("isShowFingercardState", is_ShowFingercardState);
		}
		
		/**
		 * 当前省份信息
		 */
		Config currentNativeNameConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE_NAME);

		if (currentNativeNameConfig != null) {
			String current_native_name = "";
			if (currentNativeNameConfig != null && currentNativeNameConfig.getValue() != null) {
				current_native_name = currentNativeNameConfig.getValue();
			}
			context.setAttribute("currentNativeName", current_native_name);
		}

		/**
		 * 当前省份简称
		 */
		Config currentNativeShourtConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE_SHORT);

		if (currentNativeShourtConfig != null) {
			String current_native_short = "";
			if (currentNativeShourtConfig != null && currentNativeShourtConfig.getValue() != null) {
				current_native_short = currentNativeShourtConfig.getValue();
			}
			context.setAttribute("currentNativeShort", current_native_short);
		}

		/**
		 * 公司证书背景图片路径 正本数据-单行
		 */
		Config companyPicConfig_1_1 = configUtils.getConfigByKey(Constants.COMPANY_PIC_1_1);

		if (companyPicConfig_1_1 != null) {
			String company_pic_1_1 = "";
			if (companyPicConfig_1_1 != null && companyPicConfig_1_1.getValue() != null) {
				company_pic_1_1 = companyPicConfig_1_1.getValue();
			}
			context.setAttribute("companyPic_1_1", company_pic_1_1);
		}

		/**
		 * 公司证书背景图片路径 正本数据-多行
		 */
		Config companyPicConfig_1_2 = configUtils.getConfigByKey(Constants.COMPANY_PIC_1_2);

		if (companyPicConfig_1_2 != null) {
			String company_pic_1_2 = "";
			if (companyPicConfig_1_2 != null && companyPicConfig_1_2.getValue() != null) {
				company_pic_1_2 = companyPicConfig_1_2.getValue();
			}
			context.setAttribute("companyPic_1_2", company_pic_1_2);
		}

		/**
		 * 公司证书背景图片路径 副本数据-单行
		 */
		Config companyPicConfig_2_1 = configUtils.getConfigByKey(Constants.COMPANY_PIC_2_1);

		if (companyPicConfig_2_1 != null) {
			String company_pic_2_1 = "";
			if (companyPicConfig_2_1 != null && companyPicConfig_2_1.getValue() != null) {
				company_pic_2_1 = companyPicConfig_2_1.getValue();
			}
			context.setAttribute("companyPic_2_1", company_pic_2_1);
		}

		/**
		 * 公司证书背景图片路径 副本数据-多行
		 */
		Config companyPicConfig_2_2 = configUtils.getConfigByKey(Constants.COMPANY_PIC_2_2);

		if (companyPicConfig_2_2 != null) {
			String company_pic_2_2 = "";
			if (companyPicConfig_2_2 != null && companyPicConfig_2_2.getValue() != null) {
				company_pic_2_2 = companyPicConfig_2_2.getValue();
			}
			context.setAttribute("companyPic_2_2", company_pic_2_2);
		}

		/**
		 * 保安员证书背景图片路径
		 */
		Config securityPicConfig = configUtils.getConfigByKey(Constants.SECURITY_PIC);

		if (securityPicConfig != null) {
			String security_pic = "";
			if (securityPicConfig != null && securityPicConfig.getValue() != null) {
				security_pic = securityPicConfig.getValue();
			}
			context.setAttribute("securityPic", security_pic);
		}

		/**
		 * 培训证书背景图片路径 正本数据-单行
		 */
		Config trainPicConfig_1_1 = configUtils.getConfigByKey(Constants.TRAIN_PIC_1_1);

		if (trainPicConfig_1_1 != null) {
			String train_pic_1_1 = "";
			if (trainPicConfig_1_1 != null && trainPicConfig_1_1.getValue() != null) {
				train_pic_1_1 = trainPicConfig_1_1.getValue();
			}
			context.setAttribute("trainPic_1_1", train_pic_1_1);
		}

		/**
		 * 培训证书背景图片路径 正本数据-多行
		 */
		Config trainPicConfig_1_2 = configUtils.getConfigByKey(Constants.TRAIN_PIC_1_2);

		if (trainPicConfig_1_2 != null) {
			String train_pic_1_2 = "";
			if (trainPicConfig_1_2 != null && trainPicConfig_1_2.getValue() != null) {
				train_pic_1_2 = trainPicConfig_1_2.getValue();
			}
			context.setAttribute("trainPic_1_2", train_pic_1_2);
		}

		/**
		 * 培训证书背景图片路径 副本数据-单行
		 */
		Config trainPicConfig_2_1 = configUtils.getConfigByKey(Constants.TRAIN_PIC_2_1);

		if (trainPicConfig_2_1 != null) {
			String train_pic_2_1 = "";
			if (trainPicConfig_2_1 != null && trainPicConfig_2_1.getValue() != null) {
				train_pic_2_1 = trainPicConfig_2_1.getValue();
			}
			context.setAttribute("trainPic_2_1", train_pic_2_1);
		}

		/**
		 * 培训证书背景图片路径 副本数据-多行
		 */
		Config trainPicConfig_2_2 = configUtils.getConfigByKey(Constants.TRAIN_PIC_2_2);

		if (trainPicConfig_2_2 != null) {
			String train_pic_2_2 = "";
			if (trainPicConfig_2_2 != null && trainPicConfig_2_2.getValue() != null) {
				train_pic_2_2 = trainPicConfig_2_2.getValue();
			}
			context.setAttribute("trainPic_2_2", train_pic_2_2);
		}

		/**
		 * 考试 地址
		 */
		Config examConfig = configUtils.getConfigByKey(Constants.EXAM_URL);
		if (examConfig != null) {
			String exam_utl = "";
			if (examConfig != null && examConfig.getValue() != null) {
				exam_utl = examConfig.getValue();
			}
			context.setAttribute("examURL", exam_utl);
		}
		/**
		 * 是否显示初中以上学历证明原件
		 */
		Config eduPhotoConfig = configUtils.getConfigByKey(Constants.EDU_PHOTO);
		if (eduPhotoConfig != null) {
			String edu_photo = "";
			if (eduPhotoConfig != null && eduPhotoConfig.getValue() != null) {
				edu_photo = eduPhotoConfig.getValue();
			}
			context.setAttribute("eduPhoto", edu_photo);
		}
		/**
		 * 是否显示县级以上医院出具的体检证明
		 */
		Config healthExaminationConfig = configUtils.getConfigByKey(Constants.HEALTH_EXAMINATION);
		if (healthExaminationConfig != null) {
			String health_examination = "";
			if (healthExaminationConfig != null && healthExaminationConfig.getValue() != null) {
				health_examination = healthExaminationConfig.getValue();
			}
			context.setAttribute("healthExamination", health_examination);
		}

		//打印保安员证角色id，目前用在公安消息提示个数
		Config printConfig =configUtils.getConfigByKey(Constants.PRINT_PERSON_CARD_ROLE);
		if (printConfig != null) {
			String printPersonCardRoleId = "";
			if (printConfig != null && printConfig.getValue() != null) {
				printPersonCardRoleId = printConfig.getValue();
			}
			context.setAttribute("printPersonCardRole", Long.parseLong(printPersonCardRoleId));
		}

		//分销地址
		Config fenxiaoConfig = configUtils.getConfigByKey(Constants.FENXIAO);
		String fenxiaoURL = "";
		if (fenxiaoConfig != null && fenxiaoConfig.getValue() != null) {
			fenxiaoURL = fenxiaoConfig.getValue();
			ThirdPartyURL.FENXIAO = fenxiaoURL;
		}


		//身份认定地址
		Config authConfig = configUtils.getConfigByKey(Constants.AUTH_URL);
		String authURL = "";
		if (authConfig != null && authConfig.getValue() != null) {
			authURL = authConfig.getValue();
			ThirdPartyURL.AUTH_URL = authURL;
		}
		
		//登录界面Logo路径
		Config loginLogoPathConfig =configUtils.getConfigByKey(Constants.LOGIN_LOGO_PATH);
		if (loginLogoPathConfig != null) {
			String loginLogoPath = "";
			if (loginLogoPathConfig != null && loginLogoPathConfig.getValue() != null) {
				loginLogoPath = loginLogoPathConfig.getValue();
			}
			context.setAttribute("loginLogoPath", loginLogoPath);
		}
		
		//首页界面Logo路径
		Config indexLogoPathConfig =configUtils.getConfigByKey(Constants.INDEX_LOGO_PATH);
		if (indexLogoPathConfig != null) {
			String indexLogoPath = "";
			if (indexLogoPathConfig != null && indexLogoPathConfig.getValue() != null) {
				indexLogoPath = indexLogoPathConfig.getValue();
			}
			context.setAttribute("indexLogoPath", indexLogoPath);
		}

		//许可备案申请模板路径
		Config modelPathConfig = configUtils.getConfigByKey(Constants.MODEL_PATH);
		if(modelPathConfig != null) {
			String modelPath = "";
			if(modelPathConfig != null && modelPathConfig.getValue() != null) {
				modelPath = modelPathConfig.getValue();
			}
			context.setAttribute("modelPath",modelPath);
		}
		
		//年报截止时间提交提醒
		Config yearReportDeadlineConfig =configUtils.getConfigByKey(Constants.YEAR_REPORT_DEADLINE);
		if (yearReportDeadlineConfig != null) {
			String year_report_deadline = "";
			if (yearReportDeadlineConfig != null && yearReportDeadlineConfig.getValue() != null) {
				year_report_deadline = yearReportDeadlineConfig.getValue();
			}
			context.setAttribute("year_report_deadline", year_report_deadline);
		}
		//保险提醒
		Config policyRemindConfig =configUtils.getConfigByKey(Constants.POLICY_REMIND);
		if (policyRemindConfig != null) {
			String policyRemind = "";
			if (policyRemindConfig != null && policyRemindConfig.getValue() != null) {
				policyRemind = policyRemindConfig.getValue();
			}
			context.setAttribute("policyRemind", policyRemind);
		}

		//是否缴费
		Config payConfig =configUtils.getConfigByKey(Constants.IS_PAYMENT);
		if (payConfig != null) {
			String is_pay = "";
			if (payConfig != null && payConfig.getValue() != null) {
				is_pay = payConfig.getValue();
			}
			context.setAttribute("is_pay", is_pay);
		}


		//是否在线缴费
		Config onlinePayConfig =configUtils.getConfigByKey(Constants.IS_ONLINEPAY);
		if (onlinePayConfig != null) {
			String onlinePay = "";
			if (onlinePayConfig != null && onlinePayConfig.getValue() != null) {
				onlinePay = onlinePayConfig.getValue();
			}
			context.setAttribute("onlinePay", onlinePay);
		}

		//是否保安员证新审批
		Config personNewApproveConfig =configUtils.getConfigByKey(Constants.IS_NEW_PERSON_APPROVE);
		if (personNewApproveConfig != null) {
			String personNewApprove = "";
			if (personNewApproveConfig != null && personNewApproveConfig.getValue() != null) {
				personNewApprove = personNewApproveConfig.getValue();
			}
			context.setAttribute("personNewApprove", personNewApprove);
		}


		//是否考试安排 wjb 2018年8月31日09:58:59
		Config iSExaminationArrangeConfig =configUtils.getConfigByKey(Constants.IS_EXAMINATION_ARRANGE);
		if (iSExaminationArrangeConfig != null) {
			String iSExaminationArrange = "";
			if (iSExaminationArrangeConfig != null && iSExaminationArrangeConfig.getValue() != null) {
				iSExaminationArrange = iSExaminationArrangeConfig.getValue();
			}
			context.setAttribute("iSExaminationArrange", iSExaminationArrange);
		}

	//消息是否需要上传附件
		Config attConfig =configUtils.getConfigByKey(Constants.MSG_ATTACHMENT);
		String need_attachment = "0";
		if (attConfig != null && attConfig.getValue() != null) {
			need_attachment = attConfig.getValue();
		}
		context.setAttribute("need_attachment", need_attachment);
		//家庭是否必填
		Config isRequiredFamilly =configUtils.getConfigByKey(Constants.IS_REQURIED_FAMILLY);
		if (isRequiredFamilly != null) {
			String is_required_familly = "";
			if (isRequiredFamilly != null && isRequiredFamilly.getValue() != null) {
				is_required_familly = isRequiredFamilly.getValue();
			}
			context.setAttribute("is_required_familly", is_required_familly);
		}

		//工作经历是否必填
		Config isRequiredWork = configUtils.getConfigByKey(Constants.IS_REQURIED_WORK);
		if (isRequiredWork != null) {
			String is_required_work = "";
			if (isRequiredWork != null && isRequiredWork.getValue() != null) {
				is_required_work = isRequiredWork.getValue();
			}
			context.setAttribute("is_required_work", is_required_work);
		}

		//新旧审批
		Config approvalVersionConfig = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
		String approval_version_switch = "0";
		if(approvalVersionConfig != null && Constants.APPROVAL_VERSION_NEW.equals(approvalVersionConfig.getValue())){
			approval_version_switch = "1";
		}
		context.setAttribute("approval_version_switch", approval_version_switch);

		//js脚本版本 取项目启动时间来，防止缓存
		context.setAttribute("js_version", DateUtil.getCurrentDate(DateUtil.FORMAT1));
		//是否显示分公司审报入口
		Config isSubsidiaryApprove =configUtils.getConfigByKey(Constants.IS_SUBSIDIARY_APPROVE);
		if (isSubsidiaryApprove != null) {
			String is_subsidiary_approve = "";
			if (isSubsidiaryApprove != null && isSubsidiaryApprove.getValue() != null) {
				is_subsidiary_approve = isSubsidiaryApprove.getValue();
			}
			context.setAttribute("is_subsidiary_approve", is_subsidiary_approve);
		}
		//支持未入驻系统企业的录入
		Config isOrNOtInSystem =configUtils.getConfigByKey(Constants.ISORNOT_IN_SYSTEM);
		if (isOrNOtInSystem != null) {
			String  isOrNOt_in_system= "";
			if (isOrNOtInSystem != null && isOrNOtInSystem.getValue() != null) {
				isOrNOt_in_system = isOrNOtInSystem.getValue();
			}
			context.setAttribute("isOrNOt_in_system", isOrNOt_in_system);
		}

		//saas登录地址
		Config saasLoginUrlConfig = configUtils.getConfigByKey(Constants.SAAS_LOGIN_URL);
		String saas_login_url = "";
		if(saasLoginUrlConfig != null&&saasLoginUrlConfig.getValue()!=null){
			saas_login_url = saasLoginUrlConfig.getValue();
		}
		context.setAttribute("saas_login_url", saas_login_url);
        //项目启动 初始化全部字典表到缓存 zjh edit 20181210
        sysDictUtils.initDictList();
        List<Sysdict> sysdictList=	sysDictUtils.getDictType("edu");
        if (sysdictList!=null){
            context.setAttribute("sys_dict_edu", sysdictList);
        }

		//是否启动流程
		Config isNeedActivityConfig = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
		String is_need_activitt = "";
		if(isNeedActivityConfig != null && isNeedActivityConfig.getValue()!=null){
			is_need_activitt = isNeedActivityConfig.getValue();
			context.setAttribute("is_need_activitt", is_need_activitt);
		}



		//是否需要批复意见 默认需要
		Config isReplyConfig =configUtils.getConfigByKey(Constants.IS_REPLY);
		String is_reply= "1";
		if (isReplyConfig != null) {
			if (isReplyConfig != null && isReplyConfig.getValue() != null) {
				is_reply = isReplyConfig.getValue();
			}
		}
		context.setAttribute("is_reply", is_reply);

		//常见问题地址
		Config faqPathConfig =configUtils.getConfigByKey(Constants.FAQ_PATH);
		String faq_path= "http://wiki.baibaodun.cn/";
		if (faqPathConfig != null) {
			if (faqPathConfig != null && faqPathConfig.getValue() != null) {
				faq_path = faqPathConfig.getValue();
			}
		}
		context.setAttribute("faq_path", faq_path);


		//是否确认成绩
		Config achievementConfig =configUtils.getConfigByKey(Constants.IsAchievement);
		String achievement = "";
		if (achievementConfig != null) {
			if (achievementConfig != null && achievementConfig.getValue() != null) {
				achievement = achievementConfig.getValue();
			}
		}
		context.setAttribute("IsAchievement", achievement);


		//保安员报名年龄限制
		Config ageCheckNumConfig =configUtils.getConfigByKey(Constants.ageCheckNum);
		String ageCheckNum = "";
		if (ageCheckNumConfig != null) {
			if (ageCheckNumConfig != null && ageCheckNumConfig.getValue() != null) {
				ageCheckNum = ageCheckNumConfig.getValue();
			}

            context.setAttribute("ageCheckNum", ageCheckNum);
		}


		//跨区域经营保安服务备案标题
		Config crosscompanyTitleConfig =configUtils.getConfigByKey(Constants.CROSSCOMPANYTITLE);
		String crosscompanyTitle = "保安服务公司跨区域经营保安服务备案";
		if (crosscompanyTitleConfig != null) {
			if (crosscompanyTitleConfig != null && crosscompanyTitleConfig.getValue() != null) {
				crosscompanyTitle = crosscompanyTitleConfig.getValue();
			}
		}
		context.setAttribute("crosscompanyTitle", crosscompanyTitle);
		//分公司备案标题
		Config subsidiaryTitleConfig =configUtils.getConfigByKey(Constants.SUBSIDIARYTITLE);
		String subsidiaryTitle = "保安服务公司设立分公司备案";
		if (subsidiaryTitleConfig != null) {
			if (subsidiaryTitleConfig != null && subsidiaryTitleConfig.getValue() != null) {
				subsidiaryTitle = subsidiaryTitleConfig.getValue();
			}
		}
		context.setAttribute("subsidiaryTitle", subsidiaryTitle);




        //项目变更标题
        Config legalchangeTileConfig =configUtils.getConfigByKey(Constants.LEGALCHANGETITLE);
        String legalchangeTile = "保安服务（培训）许可证项目变更审核";
        if (legalchangeTileConfig != null) {
            if (legalchangeTileConfig != null && legalchangeTileConfig.getValue() != null) {
                legalchangeTile = legalchangeTileConfig.getValue();
            }
        }
        context.setAttribute("legalchangeTile", legalchangeTile);
		//许可的路径
		Config permitPathConfig =configUtils.getConfigByKey(Constants.PERMITPATH);
		String permitPath = "/assets/images/";
		if (permitPathConfig != null) {
			if (permitPathConfig != null && permitPathConfig.getValue() != null) {
				permitPath = permitPathConfig.getValue();
			}
		}
		context.setAttribute("permitPath", permitPath);

		//是否证件照片
		Config idPhotoConfig =configUtils.getConfigByKey(Constants.IDPHOTO);
		String idPhoto = "0";
		if (idPhotoConfig != null) {
			if (idPhotoConfig != null && idPhotoConfig.getValue() != null) {
				idPhoto = idPhotoConfig.getValue();
			}
		}
		context.setAttribute("idPhoto", idPhoto);


		//wiki id 百保盾协作与知识分享平台
		context.setAttribute("wikiId",wikiId);
		//陕西统一认证平台地址
        context.setAttribute("authurl",configUtils.authurl);
        context.setAttribute("client_id", configUtils.client_id);
        context.setAttribute("authswitch", configUtils.authswitch);

		try {
			ResourceBundle rb = ResourceBundle.getBundle("yzt_deploy", Locale.getDefault());
			String yzt_sso_auth_url = rb.getString("yzt_sso_auth_url");
			String yzt_sso_auth_redirect_url = rb.getString("yzt_sso_auth_redirect_url");
			String client_id = rb.getString("client_id");
			String service = rb.getString("service");
			String scope = rb.getString("scope");

			StringBuilder redirect_url = new StringBuilder(yzt_sso_auth_url);
			redirect_url.append("/oauth2/authorize?service="+service);
			redirect_url.append("&response_type=code&client_id="+client_id);
			redirect_url.append("&scope="+scope);
			redirect_url.append("&redirect_uri="+ URLEncoder.encode(yzt_sso_auth_redirect_url,"utf-8"));
			context.setAttribute("bj_redirect_uri", redirect_url.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}



	@Override
	public void destroy() throws Exception {
	}

}
