package com.bcxin.ars.rest.util;

import com.bcxin.ars.model.Native;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.IdNumUtil;
import com.bcxin.ars.util.StringUtil;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 籍贯工具类
 * @author linqinglin
 * @date 2019/05/27 0027 10:11
 */
public class NativeUtil {

    /**
     * 根据身份证获取籍贯信息
     * @param idNum
     * @param request
     * @return
     */
    public static String getNativeByIdNum(String idNum, HttpServletRequest request){
        try {
            if(StringUtil.isEmpty(idNum)){
                return "";
            }

            Map<Long, Native> nativeData = (Map<Long, Native>) request.getSession().getServletContext().getAttribute(Constants.NATIVE_DATA);
            if(idNum.length() > 10) {
                Long id = Long.valueOf(IdNumUtil.getNativeCodeByIdNum(idNum,4));
                Native area = nativeData.get(id);
                if(area != null) {
                    Native city = area.getParent();
                    if(city != null) {
                        city.getParent();
                    }
                    return getNativeName(area);
                } else {
                }
            }
        } catch(Exception e) {
            throw e;
        }
        return "";
    }


    private static String getNativeName(Native natives) {
        String nativeName = "";
        nativeName = natives.getNativeName();
        if (natives.getParent() != null) {
            nativeName = getNativeName(natives.getParent()) + nativeName;
        }
        return nativeName;
    }
}
