package com.bcxin.ars.rest.util;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.web.servlet.mvc.method.annotation.ExtendedServletRequestDataBinder;
import javax.servlet.ServletRequest;

/**
 * DataBinder
 * @author llc
 * @date 2018年6月12日 下午3:00:00
 */
public class EmptyStringToNullRequestDataBinder extends ExtendedServletRequestDataBinder {
    public EmptyStringToNullRequestDataBinder(Object target, String objectName) {
        super(target, objectName);
    }
   @Override
    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        super.addBindValues(mpvs, request);
        for (PropertyValue propertyValue : mpvs.getPropertyValueList()) {
            if(propertyValue.getValue() != null) {
                // 如果字符串的值为""，则赋值为 null
                if (propertyValue.getValue().equals("") || propertyValue.getValue().toString().replaceAll(" ", "").equals("")) {
                    propertyValue.setConvertedValue(null);
                } else {
                    // 如果包含了空格符，则为字符串，需去除头尾空格符
                    if (propertyValue.getValue().toString().contains(" ")) {
                        propertyValue.setConvertedValue(propertyValue.getValue().toString().trim());
                    }
                }
            }
        }
    }
}