package com.bcxin.ars.rest.util;

import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.rest.shiro.CustomCredentialsMatcher;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sys.ModuleMenuService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.GXNNSingleLoginUtil;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.service.util.GXSingleLoginUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArsRealm extends AuthorizingRealm {

	private final static Logger logger = LoggerFactory.getLogger(ArsRealm.class);

	@Autowired
	private UserService userService;

	@Autowired
	private ModuleMenuService moduleMenuService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private GXSingleLoginUtil gxSingleLoginUtil;

	@Autowired
	private GXSSOUtil gxssoUtil;

    @Autowired
    private GXNNSingleLoginUtil gxNNSingleLoginUtil;


	@Override
	public void setName(String name) {
		super.setName("ARS Realm");
	}

	@SuppressWarnings("unchecked")
	@Override
	protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
		String username = (String) token.getPrincipal();
		String host = ((UsernamePasswordToken) token).getHost();
		//平台角色
		String platform  = host;
        User user =  null  ;
		//第三方对接，自然人
		if(Constants.SXNWCode.equals(host)){
            platform = String.valueOf(Constants.PLATFORM_NATURAL_PERSON);
        }else if(Constants.SaaSCode.equals(host)){
		    //saas对接公司，根据ComId获取信息
            platform = String.valueOf(Constants.PLATFORM_COMPANY);
            SecurityCompany securityCompany = securityCompanyService.findByComId(Long.parseLong(username));
            user = securityCompany.getUser();
        }else if(Constants.GX_NW_Code.equals(host)){//广西内网单点
			platform = String.valueOf(Constants.PLATFORM_POLICE);

			if(Constants.YES.equals(configUtils.getValueByKey(Constants.GX_NEW_AUTH))){
				try {
					user = gxSingleLoginUtil.getUserInfo(username);
				} catch (Exception e) {
					logger.error("获取用户信息失败：{}",e.getMessage());
					e.printStackTrace();
				}
			}

		}else if(Constants.GX_WW_Code.equals(host)){//广西外网单点
			try {
				user = userService.findGSAndZRRByUsername(username);
			} catch (Exception e) {
				logger.error("获取用户信息失败：{}",e.getMessage());
				e.printStackTrace();
			}
		}else if(Constants.GX_NN_NW_Code.equals(host)){//广西南宁内网单点
			platform = String.valueOf(Constants.PLATFORM_POLICE);
			try {
				user = gxNNSingleLoginUtil.getUserInfo(username);
			} catch (Exception e) {
				logger.error("获取用户信息失败：{}",e.getMessage());
				e.printStackTrace();
			}
		}else if(Constants.BJ_FR_SSO.equals(host)){
			user =  userService.findByUsername(username,String.valueOf(Constants.PLATFORM_COMPANY));
		}else if(Constants.BJ_CA_SSO.equals(host)){
			user =  userService.findByIdNum(username,String.valueOf(Constants.PLATFORM_POLICE));
		}
		if(user  == null ) {
            user = userService.findByUsername(username, platform);
        }
		if(user == null) {
			return null;
		}

		if(user.getPermissionList() == null) {
			//权限列表
			List<ModuleMenu> list = moduleMenuService.findForPermission(user);
			user.setPermissionList(list);
		}
		SimpleAuthenticationInfo simpleAuthenticationInfo = new SimpleAuthenticationInfo(user, user.getPassword(), this.getName());
        return simpleAuthenticationInfo;
	}

	@Override
	protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principal) {
		//存放模块用户拥有的模块列表，key和value都是模块的code
		Map moduleMap= new HashMap<String,String>();
		SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
		User user =  (User) principal.getPrimaryPrincipal();
		//权限列表
		List<ModuleMenu> list = user.getPermissionList();
		if(list!=null && list.size()>0) {
            for (ModuleMenu p : list) {
            	if(StringUtil.isNotEmpty(p.getPermission())) {
					simpleAuthorizationInfo.addStringPermission(p.getPermission());
				}
            }
        }
		return simpleAuthorizationInfo;
	}

	//清除缓存  
    public void clearCached() {
        PrincipalCollection principals = SecurityUtils.getSubject().getPrincipals();
        super.clearCache(principals);
    }

    /**
     * 设定Password校验.
     */
    @PostConstruct
    public void initCredentialsMatcher() {
    	//该句作用是重写shiro的密码验证，让shiro用我自己的验证
        setCredentialsMatcher(new CustomCredentialsMatcher());

    }
}
