package com.bcxin.ars.rest.util;

import com.bcxin.ars.util.DateUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
/**
 * 日期和Long类型转换
 * @author subh
 */
public class ArsObjMapper extends ObjectMapper {
	
	private static final long serialVersionUID = 1L;
    public static SimpleDateFormat systemTime =
            new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	public ArsObjMapper() {
        /***
         * 日期类型转换
         */
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        super.setDateFormat(DateUtil.systemTime);
        /***
         * 增加Long类型转换，防止前端接收丢失精度 add subh
         */
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, ToStringSerializer.instance);
        registerModule(simpleModule);
    }


}
