package com.bcxin.ars.rest.task;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.task.PerTaskCardRecordPageSearchDto;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.service.task.PerTaskCardRecordService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 任务打卡记录控制器
 *
 * @author linqinglin
 * @Date 2020-03-26 09:39:54
 */
@Controller
@RequestMapping("perTaskCardRecord")
public class PerTaskCardRecordController {

    Logger logger = LoggerFactory.getLogger(PerTaskCardRecordController.class);

    @Autowired
    PerTaskCardRecordService perTaskCardRecordService;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(){
        ModelAndView view = new ModelAndView("task/perTaskCardRecord/list");
        return view;
    }

    /**
     * 查看页面
     * @param perTaskCardRecord
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(PerTaskCardRecord perTaskCardRecord){
        ModelAndView view = new ModelAndView("task/perTaskCardRecord/detail");

        if(perTaskCardRecord.getId() != null){
            view.addObject("record",perTaskCardRecordService.findById(perTaskCardRecord.getId()));
        }else {
            view.addObject("record", perTaskCardRecord);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param perTaskCardRecord
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(PerTaskCardRecord perTaskCardRecord){
        ModelAndView view = new ModelAndView("task/perTaskCardRecord/edit");

        if(perTaskCardRecord.getId() != null){
            view.addObject("record",perTaskCardRecordService.findById(perTaskCardRecord.getId()));
        }else {
            view.addObject("record", perTaskCardRecord);
        }

        return view;
    }

    /**
     * 保存
     * @param perTaskCardRecord
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(PerTaskCardRecord perTaskCardRecord){
        AjaxResult result = new AjaxResult();
        try {
            perTaskCardRecordService.save(perTaskCardRecord);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(PerTaskCardRecordPageSearchDto dto, AjaxPageResponse<PerTaskCardRecord> page){
        perTaskCardRecordService.searchForPage(dto,page);
        return page;
    }
}

