package com.bcxin.ars.rest.task;

import com.bcxin.ars.dto.AjaxResult;

import com.bcxin.ars.dto.page.ComTempTaskPageSearchDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.task.ComTempTaskDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.bcxin.ars.service.task.ComContractService;
import com.bcxin.ars.service.task.ComTempTaskService;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.Logical;


/**
 * 临保任务Controller
 * 
 * @author lin
 * @date 2021-02-01
 */
@Controller
@RequestMapping("/tempTask")
public class ComTempTaskController{

    Logger logger = LoggerFactory.getLogger(ComTempTaskController.class);

    @Autowired
    private ComTempTaskService comTempTaskService;

    @Autowired
    private ComContractService comContractService;


    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    @RequiresPermissions("tempTask:view")
    public ModelAndView listIndex(ComTempTaskPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("tempTask/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("tempTask:view")
    public AjaxPageResponse searchForPage(ComTempTaskPageSearchDto dto, AjaxPageResponse<ComTempTaskDto> page){
        comTempTaskService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param comTempTask
     * @return
     */
    @RequestMapping("detail/index")
    @RequiresPermissions("tempTask:view")
    public ModelAndView detailIndex(ComTempTask comTempTask){
        ModelAndView view = new ModelAndView("tempTask/detail");

        if(comTempTask.getComTempTaskId() != null){
            view.addObject("record",comTempTaskService.findById(comTempTask.getComTempTaskId()));
        }else {
            view.addObject("record", comTempTask);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param comTempTask
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(ComTempTask comTempTask){
        ModelAndView view = new ModelAndView("tempTask/edit");

        if(comTempTask.getComTempTaskId() != null){
            comTempTask = comTempTaskService.findById(comTempTask.getComTempTaskId());
            view.addObject("record",comTempTask);
            view.addObject("comContract",comContractService.findById(comTempTask.getComContractId()));
        }else {
            view.addObject("record", comTempTask);
        }

        return view;
    }

    /**
     * 保存
     * @param comTempTask
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(ComTempTask comTempTask){
        AjaxResult result = new AjaxResult();
        try {
            comTempTaskService.save(comTempTask);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 结束
     * @param comTempTask
     * @return
     */
    @RequestMapping("end")
    @ResponseBody
    public AjaxResult end(ComTempTask comTempTask){
        AjaxResult result = new AjaxResult();
        try {
            comTempTask.setTaskStatus(Constants.COM_TASK_TASKSTATUS_NEW_2);
            comTempTaskService.updateSelective(comTempTask);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 移除任务人员
     * @param comTempTaskPer
     * @return
     */
    @RequestMapping("removePer")
    @ResponseBody
    public AjaxResult removePer(ComTempTaskPer comTempTaskPer){
        AjaxResult result = new AjaxResult();
        try {
            comTempTaskService.removePer(comTempTaskPer);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }


    /**
     * 临保任务查看 关联人员 页面进入
     * @param searchDto
     * @return
     */
    @RequestMapping("personList/index")
    public ModelAndView personListIndex(PersonPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("tempTask/personList");
//        ComTempTask comTempTask = comTempTaskService.findById(searchDto.getComTempTaskId());
//        searchDto.setCompanyId(comTempTask.getId().toString());
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 保存任务人员
     * @param comTempTask
     * @return
     */
    @RequestMapping("saveTaskPer")
    @ResponseBody
    public AjaxResult saveTaskPer(ComTempTaskDto comTempTask){
        AjaxResult result = new AjaxResult();
        try {
            comTempTaskService.saveTaskPer(comTempTask);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;

    }


}
