package com.bcxin.ars.rest.task;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.page.task.ComTaskSearchDto;
import com.bcxin.ars.dto.task.ComTaskDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.task.ComTaskService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

/**
 * 驻勤点
 * @author linqinglin
 * @date 2019/10/11 0011 11:02
 */
@Controller
@RequestMapping("comTask")
public class ComTaskController {

    private Logger logger = LoggerFactory.getLogger(ComTaskController.class);

    @Autowired
    private ComTaskService comTaskService;

    @Autowired
    private SecurityCompanyService securityCompanyService ;
    /**
     * 驻勤点信息管理 页面进入
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(ComTaskSearchDto searchDto) {
        ModelAndView view = new ModelAndView("task/list");
        view.addObject("record",searchDto);
        return view;
    }


    /**
     * 驻勤点信息管理 列表查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    @RequiresPermissions("taskManagement:query")
    public @ResponseBody
    AjaxPageResponse search(ComTaskSearchDto dto, AjaxPageResponse page){
        try {
            comTaskService.search(dto, page);
            List<ComTaskDto> comTaskDtoList = page.getData();
            comTaskDtoList.forEach(comTaskDto -> {
                comTaskDto.setNotOnDutyPersons(comTaskDto.getSchedulePersons()-comTaskDto.getOnDutyPersons());
                comTaskDto.setNoSchedulePersons(comTaskDto.getPerNum().intValue()-comTaskDto.getSchedulePersons());
            });
            page.setData(comTaskDtoList);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 驻勤点详情 页面进入
     * @param id
     * @return
     */
    @RequestMapping("detail")
    @RequiresPermissions("taskManagement:query")
    public ModelAndView detail(Long id){
        ModelAndView view = new ModelAndView("task/detail");
        try {
            view.addObject("comTask",comTaskService.findDetailById(id));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }

    /**
     * 驻勤点查看 关联人员 页面进入
     * @param searchDto
     * @return
     */
    @RequestMapping("personList/index")
    public ModelAndView personListIndex(PersonPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("task/personList");
        //根据任务ID获取公司信息
        SecurityCompany company =  securityCompanyService.findByComTaskId(searchDto.getComTaskId());
        if(company!=null && company.getId()!=null) {
            searchDto.setCompanyId(company.getId().toString());
        }
        view.addObject("searchDto",searchDto);
        return view;
    }

    @RequestMapping("findByContractId/{contractId}")
    public @ResponseBody
    AjaxResult findByContractId(@PathVariable String contractId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(comTaskService.findByContractId(contractId));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /****
     * 根据人员获取驻勤点信息
     * @param perId
     * @return
     * @throws Exception
     */
    @RequestMapping("findByPerId/{perId}")
    public @ResponseBody
    AjaxResult findByPerId(@PathVariable Long perId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(comTaskService.findByPerId(perId));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }
}
