package com.bcxin.ars.rest.task;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.page.task.ComContractStationSearchDto;
import com.bcxin.ars.model.task.ComContractStation;
import com.bcxin.ars.service.task.ComContractService;
import com.bcxin.ars.service.task.ComContractStationService;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 企业合同驻勤点
 */
@Controller
@RequestMapping("comContractStation")
public class ComContractStationController {

    private Logger logger = LoggerFactory.getLogger(ComContractStationController.class);

    @Autowired
    private ComContractStationService comContractStationService;
    /**
     * 合同列表分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    public @ResponseBody
    AjaxPageResponse search(ComContractStationSearchDto dto, AjaxPageResponse<ComContractStationSearchDto> page){
        try {
            comContractStationService.search(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

}
