package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.ThirdPartyPageSearchDto;
import com.bcxin.ars.model.sys.ThirdParty;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.sys.ThirdPartyService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 第三方对接信息控制器
 *
 * @author linqinglin
 * @Date 2020-05-15 10:14:15
 */
@Controller
@RequestMapping("thirdParty")
public class ThirdPartyController {

    Logger logger = LoggerFactory.getLogger(ThirdPartyController.class);

    @Autowired
    ThirdPartyService thirdPartyService;

    @Autowired
    SecurityCompanyService securityCompanyService;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(){
        ModelAndView view = new ModelAndView("sys/thirdParty/list");
        return view;
    }

    /**
     * 查看页面
     * @param thirdParty
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(ThirdParty thirdParty){
        ModelAndView view = new ModelAndView("sys/thirdParty/detail");

        if(thirdParty.getId() != null){
            thirdParty = thirdPartyService.findById(thirdParty.getId());
        }
        view.addObject("record", thirdParty);
        if(thirdParty.getComId() != null){
            view.addObject("company", securityCompanyService.findByComId(thirdParty.getComId()));
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param thirdParty
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(ThirdParty thirdParty){
        ModelAndView view = new ModelAndView("sys/thirdParty/edit");

        if(thirdParty.getId() != null){
            view.addObject("record",thirdPartyService.findById(thirdParty.getId()));
        }else {
            view.addObject("record", thirdParty);
        }

        view.addObject("comList", securityCompanyService.findByAll(null));


        return view;
    }

    /**
     * 保存
     * @param thirdParty
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(ThirdParty thirdParty) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            thirdPartyService.save(thirdParty);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(ThirdPartyPageSearchDto dto, AjaxPageResponse<ThirdParty> page){
        thirdPartyService.searchForPage(dto,page);
        return page;
    }
}

