package com.bcxin.ars.rest.sys;

import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.util.redis.RedisUtil;

@Controller
@RequestMapping("registerperson")
public class RegisterpersonController {
	
	Logger logger = LoggerFactory.getLogger(RegisterpersonController.class);
	
	@Autowired
	private RegisterpersonService registerpersonService;

	@Autowired
	private RedisUtil redisUtil;
	
	@RequestMapping("register")
	public @ResponseBody AjaxResult register(User user) throws Exception{
		
		AjaxResult result = new AjaxResult();
		try {
			String un = redisUtil.get(user.getMessageCode());
			//注册时新增用户名、手机
			if(un != null && un.equals(user.getPhone())) {
				return registerpersonService.register(user);
			} else {
				result.setSuccessful(false);
				result.setMsg("短信验证码错误.");
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
		
		
	}
}
