package com.bcxin.ars.rest.sys;

import com.bcxin.ars.model.OfflineNotice;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.sys.OfflineNoticeService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
/**
 * Created by 苏 on 2017/6/15.
 */
@Controller
@RequestMapping("app/offline")
public class OfflineNoticeController {
    Logger logger = LoggerFactory.getLogger(OfflineNoticeController.class);

    @Autowired
    private OfflineNoticeService offlineNoticeService;

    @Autowired
    private ArsRestUtil arsUtil;
    /**
     * 获取下线通知
     * @return
     */
    @RequestMapping("getOffline")
    public @ResponseBody
    AppAjaxResult getOffline(AppAjaxResult appResult) throws Exception {
            AppAjaxResult result = new AppAjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            OfflineNotice offlineNotice = appResult.getDecodeData(OfflineNotice.class);
            if(user !=null){
                //获取当前设备是否有下线通知
                offlineNotice.setUserId(user.getId());
                offlineNotice.setRegistrationID(offlineNotice.getRegistrationID()+user.getId());
                OfflineNotice data =  offlineNoticeService.get(offlineNotice);
                if(data!=null) {
                    //下线通知返回给手机端
                    result.setSuccessful(true);
                    result.setEncodeData(data);
                    //更新状态
                    data.setActive(false);
                    offlineNoticeService.update(data);
                }else{
                    result.setSuccessful(false);
                }
            }else{
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 更新下线通知
     * @return
     */
    @RequestMapping("updateOffline")
    public @ResponseBody
    AppAjaxResult updateOffline(AppAjaxResult appResult) throws Exception {
        AppAjaxResult result = new AppAjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user !=null){

                OfflineNotice offlineNotice = appResult.getDecodeData(OfflineNotice.class);
                offlineNotice.setUserId(user.getId());
                offlineNotice.setRegistrationID(offlineNotice.getRegistrationID()+user.getId());
                OfflineNotice data =  offlineNoticeService.get(offlineNotice);
                data.setActive(false);
                offlineNoticeService.update(data);
                result.setSuccessful(true);
                result.setEncodeData(data);
            }else{
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
