package com.bcxin.ars.rest.sys;


import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.InterfaceLogPageSearchDto;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.sys.InterfaceLogService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 系统接口日志控制器
 *
 * @author linqinglin
 * @Date 2020-01-21 16:36:08
 */
@Controller
@RequestMapping("interfaceLog")
public class InterfaceLogController {

    Logger logger = LoggerFactory.getLogger(InterfaceLogController.class);

    @Autowired
    InterfaceLogService interfaceLogService;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(){
        ModelAndView view = new ModelAndView("interfaceLog/list");
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(InterfaceLogPageSearchDto dto, AjaxPageResponse<InterfaceLog> page){
        interfaceLogService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param interfaceLog
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(InterfaceLog interfaceLog) {
        ModelAndView view = new ModelAndView("interfaceLog/detail");

        if (interfaceLog.getId() != null) {
            view.addObject("record", interfaceLogService.findById(interfaceLog.getId()));
        } else {
            view.addObject("record", interfaceLog);
        }

        return view;
    }

    /**
     * 重新调用页面
     * @param interfaceLog
     * @return
     */
    @RequestMapping("reCall/index")
    public ModelAndView reCallIndex(InterfaceLog interfaceLog) {
        ModelAndView view = new ModelAndView("interfaceLog/reCall");

        if (interfaceLog.getId() != null) {
            view.addObject("record", interfaceLogService.findById(interfaceLog.getId()));
        } else {
            view.addObject("record", interfaceLog);
        }

        return view;
    }

    @RequestMapping("reCall")
    @ResponseBody
    public AjaxResult reCall(InterfaceLog interfaceLog) {
        return interfaceLogService.reCall(interfaceLog);
    }
}

