package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dao.sys.FileTempDao;
import com.bcxin.ars.dao.sys.SubsidyComparisonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.FileTemp;
import com.bcxin.ars.model.sys.ImportConfig;
import com.bcxin.ars.service.sys.ImportService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.poi.ExcelUtil;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.*;

/**
 * @author  yyx
 * @date 2020-05-18
 * 导入
 */
@Controller
@RequestMapping(value = "import")
public class ImportController {
    private Logger logger = LoggerFactory.getLogger(ImportController.class);
    @Autowired
    private ImportService importService;
    @Value("${temp-folder}")
    private String tempfolder;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private FileTempDao fileTempDao;

    /**
     * 花名册的通用导入
     * @param businessType
     * @return
     */
    @RequestMapping("importRoster")
    @ResponseBody
    public AjaxResult importRoster(MultipartFile file, HttpServletRequest request,String businessType,String subsidyCerType) throws Exception{
        /**
         * 1、获取通用导入配置
         * 2、读取主键列、结果列、原因列
         * 3、根据结果列和业务类型查询subsidyComparison表找到流向
         * 4、根据流向更新表里的对应列
         */
        AjaxResult result = new AjaxResult();
        //根据业务类型获取对应的通用导入配置，如果是资格证比对设置为03
        if(businessType.equals(Constants.SUBSIDY_COMPARED) && subsidyCerType.equals(Constants.SUBSIDYCERTYPE_ZGZ)){
            businessType = Constants.CER_COMPARED;
        }
        ImportConfig importConfig = importService.importRoster(businessType);
        //区分资格证和等级证的比对
        importConfig.setSubsidyCerType(subsidyCerType);
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!fileType.toUpperCase().equalsIgnoreCase("XLS") && !fileType.toUpperCase().equalsIgnoreCase("XLSX")) {
            result.setMsg("导入的模板文件有误");
            result.setSuccessful(false);
            return result;
        }
        long startTime = System.currentTimeMillis();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "." + fileType;
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = tempfolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行人员文件上传..." + targetFile);
            file.transferTo(targetFile);
            Map<String, Object> resultMap = new HashMap<String, Object>();
            User loginUser = arsUtil.getCurrentUser();
            List<Map<String, String>> list = new ArrayList<Map<String, String>>(); // 花名册的所有数据
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>(); // 定义失败的list
            if (loginUser != null) {
                FileInputStream inStream = new FileInputStream(targetFile);
                Workbook workBook = WorkbookFactory.create(inStream);
                Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
                boolean flag = true;
                // 设置初始行,
                int i = importConfig.getReadRow()-1;
                while (flag) {
                    Row row = sheet.getRow(i);
                    //读取关键字行不为空，默认原因列为最后一列
                    if (row != null&&StringUtil.isNotEmpty(ExcelUtil.getCellValue(row.getCell(importConfig.getKeyColumn()-1)))) {
                        Map<String, String> data = new HashMap<String, String>();
                        //读取Excel中的对应列,若不存在抛出异常
                        try {
                            //把每一列放入一个map中，并且把每个map放入list中
                            for(int col=1;col<= importConfig.getReasonColumn();col++){
                                if(col==importConfig.getKeyColumn()){
                                    data.put("keyValue",ExcelUtil.getCellValue(row.getCell(col-1)));
                                }
                                else if(col==importConfig.getResultColumn()){
                                    data.put("resultValue",ExcelUtil.getCellValue(row.getCell(col-1)));
                                }
                                else if(col==importConfig.getReasonColumn()){
                                    data.put("reasonValue",ExcelUtil.getCellValue(row.getCell(col-1)));
                                }
                                else {
                                    data.put("" + col, ExcelUtil.getCellValue(row.getCell(col - 1)));
                                }
                            }
                            list.add(data);
                        } catch (Exception e) {
                            if (e instanceof ArsException) {
                                data.put("errorMsg", e.getMessage());
                            } else {
                                data.put("errorMsg", "格式有错");
                            }
                            faildList.add(data);
                        }
                    } else {
                        flag = false;
                    }
                    i++;
                }
                // 花名册内没内容
                if (list.size() == 0 && faildList.size() == 0) {
                    result.setMsg("导入的Excle中没有记录，请录入");
                    result.setSuccessful(false);
                    return result;
                }
                List<Map<String, String>> checkFaildList = new ArrayList<>();
                if(list.size()>0 && list != null){
                    //身份证校验，返回比对表中不存在的身份证
                    /**
                     * 检查业务由各自的业务service实现，解决耦合 TODO
                     */
                    checkFaildList = importService.selectCheckImportList(list,importConfig);
                    if (checkFaildList != null && checkFaildList.size() > 0) {
                        faildList.addAll(checkFaildList);
                    }
                }
                long endTime = System.currentTimeMillis();
                logger.info("耗费时间： " + (endTime - startTime) + " ms");
                /**** 如果存在校验错误信息，导出excel表格 ****/
                if (faildList.size() > 0) {
                    String excelTmepName = "importRosterFailTemp.xls"; // excel模板
                    FileTemp fileTemp = fileTempDao.getFileTempByName(excelTmepName); // 查询文件模板信息
                    // resultMap.put("faildFilePath",
                    // buildFaildList(fileTemp.getPath(), faildList,request));
                    // // 生成导入错误的文件,// 绝对路径文件实现
                    resultMap.put("faildFilePath",
                            buildFaildList(Constants.FILETEMPPATH + fileTemp.getFileTempName(), faildList,importConfig, request)); // 生成导入错误的文件
                }
            } else {
                throw new RuntimeException("当前登录信息错误, user:" + loginUser);
            }
            result.setData(resultMap);
            if (faildList.size() == 0) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg(faildList.size() + "人导入失败，请下载导入失败的比对人员信息");
            }
            targetFile.delete(); // 导入成功完删除文件
            result.setSuccessful(true);
        } catch (Exception e) {
            result.setSuccessful(false);
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 生成导入错误信息文件
     *
     * @param excelTempPath
     * @param data
     * @return downloadFilePath by llc 2018-08-09
     * @throws Exception
     */
    private String buildFaildList(String excelTempPath, List<Map<String, String>> data, ImportConfig importConfig,HttpServletRequest request)
            throws Exception {

        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(tempfolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_importFailList.xls";
        String filePath = tempfolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        logger.info("路径： " + filePath);
        /**** 生成file ****/
        // FileUtil.reNameFile(excelTempPath,filePath); // 绝对路径文件实现

        reNameFile(excelTempPath, filePath, request);
        File file = new File(filePath);

        if (file != null) {
            FileInputStream inStream = new FileInputStream(file);
            Workbook workBook = WorkbookFactory.create(inStream);
            //设置有边框、居中自动换行的样式
            CellStyle cellStyle = ExcelUtil.getImportStyle(workBook,(short)12,"");
            Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
            //字体颜色为红的样式
            CellStyle redStyle = ExcelUtil.getImportStyle(workBook,(short)12,"");
            Font redFont = workBook.createFont();
            redFont.setColor(Font.COLOR_RED);
            redStyle.setFont(redFont);
            int index = importConfig.getReadRow()-1;
            for (int column = 0;column<data.size();column++){
                Row row = sheet.createRow(index);
                row.createCell(0).setCellValue(column+1);
                for(int j= 1;j<=importConfig.getReasonColumn();j++){
                    if(j+1==importConfig.getKeyColumn()){
                        row.createCell(j).setCellValue(data.get(column).get("keyValue"));
                    }
                    else if(j+1==importConfig.getResultColumn()){
                        row.createCell(j).setCellValue(data.get(column).get("resultValue"));
                    }
                    else if(j+1==importConfig.getReasonColumn()){
                        row.createCell(j).setCellValue(data.get(column).get("reasonValue"));
                    }
                    else {
                        String value = data.get(column).get(""+(j+1));
                        row.createCell(j).setCellValue(value);
                    }
                    //换行、居中、有边框
                    row.getCell(j).setCellStyle(cellStyle);
                }
                row.createCell(importConfig.getReasonColumn()).setCellValue(data.get(column).get("errorMsg"));
                row.getCell(importConfig.getReasonColumn()).setCellStyle(cellStyle);
                row.getCell(importConfig.getReasonColumn()).setCellStyle(redStyle);
                index++;
            }

            FileOutputStream fileOut = new FileOutputStream(file);
            workBook.write(fileOut);
            fileOut.close();
            workBook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    /**
     * 重命名文件
     *
     * @param oldPath String 原文件路径 如：原文件路径
     * 如：c:/data/ars/temp/securityCertificateTemp.xls
     * @param newPath String 复制后路径 如：复制后路径 如：c:/data/ars/temp/2018-08-09/保安员导入失败.xls
     * @return boolean by llc 2018-08-09
     **/
    private static void reNameFile(String oldPath, String newPath, HttpServletRequest request) throws IOException {
        InputStream is = null;
        OutputStream out = null;
        try {
            is = request.getServletContext().getResourceAsStream(oldPath);
            int bytesum = 0;
            int byteread = 0;
            if (is != null) { // 文件存在时
                out = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                int length;
                while ((byteread = is.read(buffer)) != -1) {
                    bytesum += byteread; // 字节数 文件大小
                    out.write(buffer, 0, byteread);
                }
                is.close(); // 输入流关闭
                out.flush(); // 刷新输出流
                out.close(); // 输出流关闭
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (is != null || out != null) {
                try {
                    is.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


}
