package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.ImportConfigDto;
import com.bcxin.ars.model.sys.ImportConfig;
import com.bcxin.ars.service.sys.ImportConfigService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * @author  yyx
 * @date 2020-05-18
 */
@Controller
@RequestMapping(value = "sys/importConfig")
public class ImportConfigController {
    private Logger logger = LoggerFactory.getLogger(ImportConfigController.class);
    @Autowired
    private ImportConfigService importConfigService;

    /**
     * 补贴参数配置页面
     * @return
     */
    @RequestMapping("/toQueryPage")
    public ModelAndView toQueryPage(){
        ModelAndView view = new ModelAndView("sys/importConfig/list");
        return view;
    }
    /**
     * 新增编辑页面
     * @param importConfig
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView editIndex(ImportConfig importConfig){
        ModelAndView view = new ModelAndView("sys/importConfig/edit");
        if(importConfig.getId() != null){
            ImportConfig subsidyComparison1 = importConfigService.findById(importConfig.getId());
            view.addObject("record",subsidyComparison1);
        }else {
            view.addObject("record",importConfig);
        }
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(ImportConfigDto importConfigDto, AjaxPageResponse<ImportConfig> page) throws Exception {
        importConfigService.search(importConfigDto,page);
        return page;
    }
    /**
     * 保存
     * @param importConfig
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(ImportConfig importConfig){
        AjaxResult result = new AjaxResult();
        try {
            importConfigService.save(importConfig);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
}
