
package com.bcxin.ars.rest.sys;

import com.bcxin.ars.model.sys.FileTemp;
import com.bcxin.ars.service.sys.FileTempService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;

/**
 * excel、word文件模板管理控制层
 * by llc 2018-09-10
 */
@Controller
@RequestMapping(value = "fileTemp")
public class FileTempController {
	
    private Logger logger = LoggerFactory.getLogger(SysareaController.class);
    
    @Autowired
    private FileTempService fileTempService;


    /**
     * 导出文件模板
     * by llc 2018-09-10
     */
    @RequestMapping("exportFileTemp")
    public @ResponseBody void exportFileTemp(String fileTempName, HttpServletResponse response , HttpServletRequest request) throws Exception {
        try {

            FileTemp fileTemp = fileTempService.getFileTempByName(fileTempName);

            if(fileTemp == null){
//                throw new ArsException("文件模板还在维护中");
            }else{
                String downFileName = "";

                if(fileTemp.getPath() == null || fileTemp.getFileTempName() == null){
//                    throw new ArsException("文件模板还在维护中");
                }
                    /***  fileTempName ：securityCertificateTemp.xls
                     *    fileTempType : xls
                     *    tile : 历史保安员导入模板
                     */
                   if(fileTemp.getTitle().contains(fileTemp.getFileTempType())){
                       downFileName = fileTemp.getTitle();
                   }else{
                       downFileName = fileTemp.getTitle() + "." + fileTemp.getFileTempType();
                   }

                   /***  下载文件 ***/
            //     FileUtil.downloadFile(fileTemp.getPath(),downFileName,response); // 绝对路径文件实现
                downloadFile( Constants.FILETEMPPATH + fileTempName,downFileName,response,request);
            }
        } catch(Exception e) {
            throw e;
        }
    }


    /**
     * 下载文件
     * @param filePath 文件路径
     * @param downLoadName 下载后的文件名
     * by llc 2018-08-20
     **/
    private static void downloadFile(String filePath, String downLoadName, HttpServletResponse response, HttpServletRequest request) {
        OutputStream out = null;
        InputStream is = null ;
        try {
                is = request.getServletContext().getResourceAsStream(filePath);
                response.setContentType("octets/stream");
                response.addHeader("Content-Type", "text/html; charset=utf-8");
                downLoadName = new String(downLoadName.getBytes("gbk"), "iso8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);

                out = response.getOutputStream();
                int i = 0;
                while ((i = is.read()) != -1) {
                    out.write(i);
                }
                is.close(); // 输入流关闭
                out.flush(); // 刷新输出流
                out.close(); // 输出流关闭

        } catch (Exception e) {
            e.printStackTrace();
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (is != null || out != null) {
                try {
                    is.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

}
