package com.bcxin.ars.rest.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.ExportColumnDto;
import com.bcxin.ars.dto.sys.ExportConfigDto;
import com.bcxin.ars.model.sys.ExportColumn;
import com.bcxin.ars.model.sys.ExportConfig;
import com.bcxin.ars.service.sys.ExportColumnService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/***
 * 导出字段配置信息
 */
@Controller
@RequestMapping("sys/exportColumn")
public class ExportColumnController {
    /***
     * 日志
     */
    private static  final Logger logger = LoggerFactory.getLogger(ExportColumnController.class);
    @Autowired
    private ExportColumnService exportColumnService;
    /**
     *
   * @return
     */
    @RequestMapping("list")
    public ModelAndView list(ExportColumn record) {
        ModelAndView view = new ModelAndView("sys/exportColumn/list");
        view.addObject("record",record);
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(ExportColumnDto exportColumnDto, AjaxPageResponse<ExportColumn> page) throws Exception {
        exportColumnService.search(exportColumnDto,page);
        return page;
    }
    /**
     * 新增编辑页面
     * @param exportColumn
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView editIndex(ExportColumn exportColumn){
        ModelAndView view = new ModelAndView("sys/exportColumn/edit");
        view.addObject("record",exportColumn);
        return view;
    }

    /**
     * 进入修改页面
     * @return
     */
    @RequestMapping("enterEditPage")
    public ModelAndView enterEditPage(Long id) {
        ModelAndView view = new ModelAndView("sys/exportColumn/edit");
        view.addObject("record",   exportColumnService.findById(id));
        return view;
    }
    /**
     * 保存
     * @param exportColumn
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(ExportColumn exportColumn){
        AjaxResult result = new AjaxResult();
        try {
            exportColumnService.save(exportColumn);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
}
