package com.bcxin.ars.rest.sx;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sx.AuthUserInfo;
import com.bcxin.ars.service.sx.AuthorizeService;
import com.bcxin.ars.service.util.ConfigUtils;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAuthzResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;

/***
 * 陕西省统一认证平台
 * @author  subh
 */
@Controller
@RequestMapping("sysauthserver")
public class AuthorizeController {

    private static final Logger logger = LoggerFactory.getLogger(AuthorizeController.class);

	
	//在浏览器地址输入运行结果后台打印：http://61.185.238.223/sysauthserver/authorizeTest
    @Autowired
    private ConfigUtils configUtils;
	//外网ip
	//private String ip = "61.185.238.225"; 
	private String ip = "59.218.251.11";
	//内网ip
	private String ipIn = "10.100.4.2";
	
	private String ipLocalhost = "localhost:8080/ars-web";


	@Autowired
	private AuthorizeService authorizeService;

    @RequestMapping("/oauth2-login")
    public String login() {
        return "";
    }


	/*
    response_type：表示授权类型，必选项，此处的值固定为"code"
    client_id：表示客户端的ID，必选项
    redirect_uri：表示重定向URI，可选项
    scope：表示申请的权限范围，可选项
    state：表示客户端的当前状态，可以指定任意值，认证服务器会原封不动地返回这个值
	 */
    /**
     * 获得授权码
     * @return
     */
    @RequestMapping("/authorizeTest")
    public String authorize(Model model, HttpServletRequest request) {
        try {
            OAuthClientRequest oauthResponse = OAuthClientRequest
            								   //获得授权码的url
                                               .authorizationLocation("http://"+configUtils.authurl+"/sysauthserver/authorize")
                                               .setResponseType("code")
                                               .setClientId("000000001")
                                               //重定向到业务系统的服务中接受code
                                               .setRedirectURI("http://"+ipLocalhost+"/sysauthserver/oauth_callback.do")
                                               .setScope("zf1")
                                               .buildQueryMessage();
            
            System.out.println("=========开始获得授权码===========================");
            return "redirect:"+oauthResponse.getLocationUri();
        } catch (OAuthSystemException e) {
            e.printStackTrace();
        }
        return "redirect:/home";
    }
    
    /*
    grant_type：表示使用的授权模式，必选项，此处的值固定为"authorization_code"
    code：表示上一步获得的授权码，必选项。
    redirect_uri：表示重定向URI，必选项，且必须与A步骤中的该参数值保持一致
    client_id：表示客户端ID，必选项
	*/
	/**
	 * 获得令牌
	 * @return oauth_callback?code=1234
	 */
	@RequestMapping(value = "/oauth_callback" ,method = RequestMethod.GET)
	public String getToken(HttpServletRequest request,Model model, HttpServletResponse response) throws OAuthProblemException {
	    OAuthAuthzResponse oauthAuthzResponse = null;
        ServletContext servletContext = request.getServletContext();
        String rootPath = servletContext.getContextPath();
	    try {
	        oauthAuthzResponse = OAuthAuthzResponse.oauthCodeAuthzResponse(request);
	        String code = oauthAuthzResponse.getCode();
	        //从上面的/authorizeTest服务获得的code
	        logger.info("获得授权码code="+code);
	        
	        OAuthClientRequest oauthClientRequest = OAuthClientRequest
	                                                .tokenLocation(configUtils.authurl+"/sysauthserver/accessToken")
	                                                .setGrantType(GrantType.AUTHORIZATION_CODE)
	                                                .setClientId("000000000")
	                                                .setClientSecret("747fdc280c877876d521f91507f356aa")
	                                                .setRedirectURI("http://localhost:8080/ars-web/sysauthserver/oauth2-login")
	                                                .setCode(code)
	                                                .buildQueryMessage();
	        OAuthClient oAuthClient = new OAuthClient(new URLConnectionClient());
	        //获取access token-------------------------------------------------------
	        OAuthJSONAccessTokenResponse oAuthResponse = oAuthClient.accessToken(oauthClientRequest, OAuth.HttpMethod.POST);
	        String accessToken = oAuthResponse.getAccessToken();
	        Long expiresIn = oAuthResponse.getExpiresIn();
            logger.info("获得令牌 accessToken="+accessToken);
	        
	        //在此处把token存到session中
	        request.getSession().setAttribute("accessToken", accessToken);
	        String st = (String) request.getSession().getAttribute("accessToken");
            OAuthClientRequest userInfoRequest = new OAuthBearerClientRequest(configUtils.authurl+"/sysauthserver/userInfo")
                    .setAccessToken(accessToken)
                    .buildQueryMessage();
            //请求用户信息
            OAuthResourceResponse resourceResponse = oAuthClient.resource(userInfoRequest, OAuth.HttpMethod.GET, OAuthResourceResponse.class);
            String userInfo = resourceResponse.getBody();
            logger.info("获得登录用户信息 userInfo="+userInfo);

            AuthUserInfo authUserInfo = JSONObject.parseObject(userInfo, AuthUserInfo.class);
            AjaxResult ajaxResult = authorizeService.login(authUserInfo.getLoginUser(),request);
            if (ajaxResult.isSuccessful()) {
                return "redirect:/index.do";
            }else{
                response.sendRedirect(rootPath+"/login.jsp");
            }
	    } catch (Exception ex) {
            logger.error(ex.getMessage(),ex);

	    }
        return "redirect:/index.do";
	}

	@RequestMapping(value = "/logout_callback" ,method = RequestMethod.GET)
	public void logout_callback(HttpServletRequest request, HttpServletResponse response) throws OAuthProblemException {
		
		System.out.println("已经注销成功。");
		System.out.println("request="+request.getRequestURL());
		
		try {
			
			//这里开始跳转到jsp画面上，然后在画面上在做链接请求code
			response.sendRedirect("localhost:8080/sysauth-v3/");
			
			//RequestDispatcher requestDispatcher =request.getRequestDispatcher("http://localhost:8080/sysauthclient/index.jsp");
		    //调用forward()方法，转发请求      
			//requestDispatcher.forward(request,response);    
		   
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		
		}
		
		
	}
	
	/**
	 * 向指定 URL 发送POST方法的请求
	 * 
	 * @param url
	 *            发送请求的 URL
	 * @param param
	 *            请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
	 * @return 所代表远程资源的响应结果
	 */
	 public static String sendPost(String url, String param) {
	        PrintWriter out = null;
	        BufferedReader in = null;
	        String result = "";
	        try {
	            URL realUrl = new URL(url);
	            // 打开和URL之间的连接
	            URLConnection conn = realUrl.openConnection();
	            // 设置通用的请求属性
	            conn.setRequestProperty("accept", "*/*");
	            conn.setRequestProperty("connection", "Keep-Alive");
	            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
	            // 发送POST请求必须设置如下两行
	            conn.setDoOutput(true);
	            conn.setDoInput(true);
	            // 获取URLConnection对象对应的输出流
	            out = new PrintWriter(conn.getOutputStream());
	            // 发送请求参数
	            out.print(param);
	            // flush输出流的缓冲
	            out.flush();
	            // 定义BufferedReader输入流来读取URL的响应
	            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
	            String line;
	            while ((line = in.readLine()) != null) {
	                result += line;
	            }
	        } catch (Exception e) {
	            System.out.println("发送 POST 请求出现异常！"+e);
	            e.printStackTrace();
	        }
	        //使用finally块来关闭输出流、输入流
	        finally{
	            try{
	                if(out!=null){
	                    out.close();
	                }
	                if(in!=null){
	                    in.close();
	                }
	            }
	            catch(IOException ex){
	                ex.printStackTrace();
	            }
	        }
	        return result;
	    }
	 

		//导入统一身份用户
		public static void main2(String[] args) {
			// ----自然人-------------------------------------------------------------
			String user_type = "0";
			String client_id = "000000005";
	        String jsonstr = "[{'userAccount':'ty'," //登录账号
	        		+ "'username':'统一身份用户',"            //登录名称
	        		+ "'userpasswd':'1',"            //密码
	        		+ "'sex':'1',"                   //性别（0：男，1：女）
	        		+ "'credentials_number':'2010131982060124515',"//身份证
	        		+ "'adress_provinces':'陕西省',"  //证件地址省
	        		+ "'adress_city':'西安市',"       //证件地址市
	        		+ "'adress_district':'莲湖区',"   //证件地址区
	        		+ "'adress_detail':'信息中心青年路16号',"   //证件详细地址
	        		+ "'mobile_telephone':'13940380943',"  //电话
	        		+ "'email':'aaa@163.com'}]";	       //邮件        
			
			String url = "http://localhost:8080/sysauthserver/importOauthUser";
			String param = "client_id="+ client_id + "&user_type="+ user_type + "&userJson="+jsonstr;
			
			String aa= sendPost(url, param);
			System.out.println(aa);
			
			//----法人----------------------------------------------------------------------
			String user_type1 = "1";
			String client_id1 = "000000005";
	        String jsonstr1 = "[{'unitaccount':'ncm',"//法人账号
	        		+ "'unitname':'奶茶妹',"            //法人名称
	        		+ "'unitpasswd':'1',"             //密码
	        		+ "'unit_credentials_type':'1',"            //证件类型
	        		+ "'unit_credentials_number':'1234567890'," //法人证件号码
	        		+ "'unit_adress_provinces':'陕西省',"         //法人证件地址省
	        		+ "'unit_adress_city':'西安市',"              //法人证件地址市
	        		+ "'unit_adress_district':'莲湖区',"          //法人证件地址区
	        		+ "'unit_adress_detail':'信息中心青年路16号',"   //法人证件详细地址
	        		+ "'operator_name':'csc',"                  //法定代表人姓名
	        		+ "'operatore_credentials_number':'610102197803032392',"//法定代表人身份证号码
	        		+ "'mobile_telephone':'13940380943'}]";     //手机号
    		
			String url1 = "http://localhost:8080/sysauthserver/importOauthUser";
			String param1 = "client_id="+ client_id1 + "&user_type="+ user_type1 + "&userJson="+jsonstr1;
			
			String aa1= sendPost(url1, param1);
			System.out.println(aa1);
			
	 }
		//导入存量用户
		public static void main(String[] args) {
			// ----自然人-------------------------------------------------------------
			String user_type = "0";
			String client_id = "000000004";
	        String jsonstr = "[{'userAccount':'abc1','username':'abc1','userpasswd':'1','editdate':'2017-11-27 16:59:26'}]";	        
   
			String url = "http://localhost:8080/sysauthserver/importStockUser";
			String param = "client_id="+ client_id + "&user_type="+ user_type + "&userJson="+jsonstr;
			
			String aa= sendPost(url, param);
			System.out.println(aa);
			
			//----法人----------------------------------------------------------------------
			String user_type1 = "1";
			String client_id1 = "000000005";
	        String jsonstr1 = "[{'unitaccount':'qip1',"
	        		+ "'unitname':'qipeng1',"
	        		+ "'unitpasswd':'1',"
	        		+ "'unitCredentialsNumber':'1234567890',"//法人证件号码
	        		+ "'operatorName':'csc',"//法定代表人姓名
	        		+ "'operatoreCredentialsNumber':'610102197803032392',"//法定代表人身份证号码
	        		+ "'unitAdressDetail':'西安青年路',"
	        		+ "'editdate':'2017-11-27 16:59:26'}]"; //详细地址
	        
			String url1 = "http://localhost:8080/sysauthserver/importStockUser";
			String param1 = "client_id="+ client_id1 + "&user_type="+ user_type1 + "&userJson="+jsonstr1;
			
			String aa1= sendPost(url1, param1);
			System.out.println(aa1);
		}
		
		public static void main1(String[] args) {
			String jsonstr = "[{'CustName':'西安动点广告文化传播有限公司1',"  //企业名称
					+ "'CssID':'5004200342361',"      //证书客服信任号
					+ "'CustID':'610000100101311',"      //统一社会信誉代码
					+ "'CertDate':'2016-08-16 16:47:28',"    //办证日期
					+ "'state1':'a陕西省',"      //企业省份
					+ "'localtion':'a西安市',"   //企业所在城市
					+ "'CertType':'0',"    //证书类型
					+ "'CustPers':'a阮陈森',"    //企业法人
					+ "'CustAddr':'a西安市碑林区测会东路198号'}]"; //企业地址        

			String url = "http://localhost:8080/sysauthserver/importCAUser";
			String param = "&userJson="+jsonstr;
			
			String aa= sendPost(url, param);
			System.out.println(aa);
		}
}