package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.PersonPunishDto;
import com.bcxin.ars.dto.page.supervision.PersonPunishPageSearchDto;
import com.bcxin.ars.model.supervision.PersonPunish;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.PersonPunishService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 人员违法违规处罚
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("personPunish")
public class PersonPunishController {

    Logger logger = LoggerFactory.getLogger(PersonPunishController.class);

    @Autowired
    PersonPunishService personPunishService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;
    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(PersonPunishPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/personPunish/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param personPunish
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(PersonPunish personPunish){
        ModelAndView view = new ModelAndView("supervision/personPunish/edit");

        if(personPunish.getId() != null){
            view.addObject("record",personPunishService.findById(personPunish.getId()));
        }else {
            //新增时默认为pc端录入
            personPunish.setDataSource(Constants.CHECKTYPE_PC);
            view.addObject("record", personPunish);
        }
        view.addObject("token",configUtils.getToken());
        view.addObject("companyList", companyService.findByAll(personPunish.getInstitutionType()));
        return view;
    }

    /**
     * 保存
     * @param personPunish
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(PersonPunish personPunish){
        AjaxResult result = new AjaxResult();
        try {
            personPunishService.save(personPunish);
            result.setData(personPunish.getId());
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(PersonPunishPageSearchDto dto, AjaxPageResponse<PersonPunishDto> page){
        personPunishService.searchForPage(dto,page);
        return page;
    }
}
