package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.PersonComplaintDto;
import com.bcxin.ars.dto.page.supervision.PersonComplaintPageSearchDto;
import com.bcxin.ars.model.supervision.PersonComplaint;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.PersonComplaintService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 人员投诉
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("personComplaint")
public class PersonComplaintController {

    Logger logger = LoggerFactory.getLogger(PersonComplaintController.class);

    @Autowired
    PersonComplaintService personComplaintService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;
    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(PersonComplaintPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/personComplaint/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param personComplaint
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(PersonComplaint personComplaint,String institutionTypeName){
        ModelAndView view = new ModelAndView("supervision/personComplaint/edit");

        if(personComplaint.getId() != null){
            view.addObject("record",personComplaintService.findById(personComplaint.getId()));
        }else {
            personComplaint.setDataSource(Constants.CHECKTYPE_PC);
            view.addObject("record", personComplaint);
        }

        view.addObject("token",configUtils.getToken());
        view.addObject("companyList", companyService.findByAll(personComplaint.getInstitutionType()));
        return view;
    }

    /**
     * 保存
     * @param personComplaint
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(PersonComplaint personComplaint){
        AjaxResult result = new AjaxResult();
        try {
            personComplaintService.save(personComplaint);
            result.setData(personComplaint.getId());
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(PersonComplaintPageSearchDto dto, AjaxPageResponse<PersonComplaintDto> page){
        personComplaintService.searchForPage(dto,page);
        return page;
    }
}
