package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.CompanyInspectionDto;
import com.bcxin.ars.dto.page.supervision.CompanyInspectionPageSearchDto;
import com.bcxin.ars.model.supervision.CompanyInspection;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.CompanyInspectionService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 公司监督检查
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("companyInspection")
public class CompanyInspectionController {

    Logger logger = LoggerFactory.getLogger(CompanyInspectionController.class);

    @Autowired
    CompanyInspectionService companyInspectionService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;
    /**
     * 管理列表页面
     * @param searchDto
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(CompanyInspectionPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/companyInspection/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param companyInspection
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(CompanyInspection companyInspection,String institutionTypeName){
        ModelAndView view = new ModelAndView("supervision/companyInspection/edit");

        if(companyInspection.getId() != null){
            CompanyInspection record = companyInspectionService.findById(companyInspection.getId());
            //未驻入系统的时候要给未驻入系统的公司名赋值
            if(!StringUtils.isEmpty(record.getIsInSystem()) && record.getIsInSystem().equals(Constants.NOT_IN_SYS)){
                record.setCompanyNameDefine(record.getCompanyName());
            }
            view.addObject("record",record);
        }else {
            //新增是默认为pc端录入，默认是系统已入驻
            companyInspection.setDataSource(Constants.CHECKTYPE_PC);
            companyInspection.setIsInSystem(Constants.IS_IN_SYS);
            view.addObject("record", companyInspection);
        }
        view.addObject("institutionTypeName", institutionTypeName);

        view.addObject("token",configUtils.getToken());
        view.addObject("companyList", companyService.findByAll(companyInspection.getInstitutionType()));
        return view;
    }

    /**
     * 保存
     * @param companyInspection
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(CompanyInspection companyInspection){
        AjaxResult result = new AjaxResult();
        try {
            companyInspectionService.save(companyInspection);
            result.setData(companyInspection.getId());
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(CompanyInspectionPageSearchDto dto, AjaxPageResponse<CompanyInspectionDto> page){
        companyInspectionService.searchForPage(dto,page);
        return page;
    }
}
