package com.bcxin.ars.rest.supervision;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.supervision.CompanyComplaintDto;
import com.bcxin.ars.dto.page.supervision.CompanyComplaintPageSearchDto;
import com.bcxin.ars.model.supervision.CompanyComplaint;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.supervision.CompanyComplaintService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 公司投诉
 * @author linqinglin
 * @date 2019/07/16 0016 13:57
 */
@Controller
@RequestMapping("companyComplaint")
public class CompanyComplaintController {

    Logger logger = LoggerFactory.getLogger(CompanyComplaintController.class);

    @Autowired
    CompanyComplaintService companyComplaintService;

    @Autowired
    SecurityCompanyService companyService;

    @Autowired
    ConfigUtils configUtils;
    /**
     * 管理列表页面
     * @param searchDto
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(CompanyComplaintPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("supervision/companyComplaint/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 新增编辑页面
     * @param companyComplaint
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(CompanyComplaint companyComplaint,String institutionTypeName){
        ModelAndView view = new ModelAndView("supervision/companyComplaint/edit");
        if(companyComplaint.getId() != null){
            CompanyComplaint record = companyComplaintService.findById(companyComplaint.getId());
            //未驻入系统的时候要给未驻入系统的公司名赋值
            if(!StringUtils.isEmpty(record.getIsInSystem()) && record.getIsInSystem().equals(Constants.NOT_IN_SYS)){
                record.setCompanyNameDefine(record.getComplaintCompanyName());
            }
            view.addObject("record",record);
        }else {
            //新增是默认为pc端录入，默认是系统已入驻
            companyComplaint.setDataSource(Constants.CHECKTYPE_PC);
            companyComplaint.setIsInSystem(Constants.IS_IN_SYS);
            view.addObject("record", companyComplaint);
        }
        view.addObject("institutionTypeName", institutionTypeName);

        view.addObject("token",configUtils.getToken());
        view.addObject("companyList", companyService.findByAll(companyComplaint.getInstitutionType()));
        return view;
    }

    /**
     * 保存
     * @param companyComplaint
     * @return
     */
    @RequestMapping("save")
    @CheckFormToken
    @ResponseBody
    public AjaxResult save(CompanyComplaint companyComplaint){
        AjaxResult result = new AjaxResult();
        try {
            companyComplaintService.save(companyComplaint);
            result.setData(companyComplaint.getId());
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(CompanyComplaintPageSearchDto dto, AjaxPageResponse<CompanyComplaintDto> page){
        companyComplaintService.searchForPage(dto,page);
        return page;
    }
}
