package com.bcxin.ars.rest.subsidy;


import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.bcxin.ars.service.subsidy.GradeSubsidyRosterService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DES3;
import com.bcxin.ars.util.QRCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("gradeiate")
public class GraduateCertificateController {


    private Logger logger = LoggerFactory.getLogger(GradeSubsidyRosterController.class);
    @Autowired
    private GradeSubsidyRosterService gradeSubsidyRosterService;

    @Autowired
    private GradeCompleteCerService gradeCompleteCerService;

    @Autowired
    private ConfigUtils configUtils;

    @Value("${temp-folder}")
    private String tempFolder;

    @RequestMapping("detail/index")
    public ModelAndView detailIndex(String cerId)  {
        ModelAndView view = new ModelAndView("subsidy/grade/certificate");

        try {
            cerId=DES3.decode(cerId);//解密
        } catch (Exception e) {
            e.printStackTrace();
        }
        GradeCompleteCer gradeCompleteCer = gradeCompleteCerService.findById(Long.valueOf(cerId));
        //获取二维码
        try {
            String bbdBBDUrl = gradeCompleteCerService.getBbdH5Url(cerId);
            String pathName = QRCodeUtil.generateBase64QRCode(bbdBBDUrl, 100, 100, "jpg");
            gradeCompleteCer.setQrCode(pathName);
            //二维码
        } catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject("record", gradeCompleteCer);

        return  view;
    }

}
