package com.bcxin.ars.rest.statistics;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.statistics.PageResultDTO;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.service.statistics.ApprovalStatisticsService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.DateUtil;
import com.beust.jcommander.internal.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 审批情况分析
 * </p>
 *
 * @author 罗鹏
 * @date 2018/4/16
 */
@Controller
@RequestMapping("statistics/approval")
public class ApprovalStatisticsController {

	Logger logger = LoggerFactory.getLogger(ApprovalStatisticsController.class);
	
	@Autowired
	private ApprovalStatisticsService approvalService;
	
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private SysAreaUtil sysAreaUtil;

	/**
	 * 限制area选择
	 * @return
	 */
	@RequestMapping("areaLimit")
	public @ResponseBody AjaxResult areaLimit(){
		String areaCode = arsUtil.getCurrentUser().getPolice().getAreacode();
		TreeView region = sysAreaUtil.getRegionByCode(areaCode);
		AjaxResult result = new AjaxResult();
		result.setSuccessful(true);
		result.setData(region);
		return result;
	}

	/**
	 * 初始化本周
	 * @return
	 */
	@RequestMapping("initWeek")
	public @ResponseBody AjaxResult initWeek(){
		AjaxResult result = new AjaxResult();
		Date startDate = DateUtil.getBeginDayOfWeek();
		String endDate = DateUtil.getCurrentDate();
		Map<String,String> map = Maps.newHashMap();
		map.put("startDate",DateUtil.convertDateToString(startDate,DateUtil.FORMAT2));
		map.put("endDate",endDate);
		result.setSuccessful(true);
		result.setData(map);
		return result;
	}

	/**
	 * 初始化本月
	 * @return
	 */
	@RequestMapping("initMonth")
	public @ResponseBody AjaxResult initMonth(){
		AjaxResult result = new AjaxResult();
		Date startDate = DateUtil.getBeginDayOfMonth();
		String endDate = DateUtil.getCurrentDate();
		Map<String,String> map = Maps.newHashMap();
		map.put("startDate",DateUtil.convertDateToString(startDate,DateUtil.FORMAT2));
		map.put("endDate",endDate);
		result.setSuccessful(true);
		result.setData(map);
		return result;
	}

	/**
	 * 审批情况分析（汇总数据）
	 * @return
	 */
	@RequestMapping("approvalSummary")
	public @ResponseBody AjaxResult approvalSummary(){
		AjaxResult result = new AjaxResult();
		String areaCode = arsUtil.getCurrentUser().getPolice().getAreacode();
		ParamDTO paramDTO = new ParamDTO();
		paramDTO.setArea(areaCode);
		Map map = approvalService.approvalSummary(paramDTO);
		result.setSuccessful(true);
		result.setData(map);
		return result;
	}


	/**
	 * 审批情况分析
	 * @return
	 */
	@RequestMapping("approvalDetail")
	public @ResponseBody AjaxResult approvalDetail(ParamDTO paramDTO){
		AjaxResult result = new AjaxResult();
		List<Map> mapList = approvalService.approvalAgingAnalyse(paramDTO);
		result.setSuccessful(true);
		result.setData(mapList);
		return result;
	}

	/**
	 * 保安员资格证考试报名分析
	 * @return
	 */
	@RequestMapping("approvalStatusDetail")
	public @ResponseBody AjaxResult approvalStatusDetail(ParamDTO paramDTO){
		AjaxResult result = new AjaxResult();
		List<Map> mapList = approvalService.approvalStatusAnalyse(paramDTO);
		result.setSuccessful(true);
		result.setData(mapList);
		return result;
	}


	/**
	 * 保安员资格证考试报名分析
	 * @return
	 */
	@RequestMapping("securityExamSummary")
	public @ResponseBody AjaxResult securityExamSummary(){
		AjaxResult result = new AjaxResult();
		String areaCode = arsUtil.getCurrentUser().getPolice().getAreacode();
		ParamDTO paramDTO = new ParamDTO();
		paramDTO.setArea(areaCode);
		Map map = approvalService.securityExamSummary(paramDTO);
		result.setSuccessful(true);
		result.setData(map);
		return result;
	}

	/**
	 * 保安员资格证考试报名分析
	 * @return
	 */
	@RequestMapping("securityExamDetail")
	public @ResponseBody AjaxResult securityExamDetail(ParamDTO paramDTO){
		AjaxResult result = new AjaxResult();
		PageResultDTO resultDTO = approvalService.getSecurityDetail(paramDTO);
		result.setSuccessful(true);
		result.setData(resultDTO);
		return result;
	}

}
