package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.YearreportSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Yearreport;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.YearreportService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by 苏 on 2017/5/1.
 */
@Controller
@RequestMapping("yearreport")
public class YearreportController {

    private Logger logger = LoggerFactory.getLogger(YearreportController.class);
    
    @Autowired
    private YearreportService yearreportService;
    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private ArsUtil arsUtil;
    

    @RequestMapping("search")
    public @ResponseBody AjaxResult search(YearreportSearchDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                if(user.getPlatform()==2){
                    dto.setUserid(user.getId());
                }
                result.setSuccessful(true);
                result.setData(yearreportService.search(dto));
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Yearreport yearreport) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                yearreportService.saveOrUpdate(yearreport);
            } else {
                result.setSuccessful(false);
                result.setCode("0000");
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Yearreport yearreport = yearreportService.findById(id);
            result.setSuccessful(true);
            result.setData(yearreport);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Yearreport yearreport = yearreportService.findByUser(user.getId());
                if(yearreport != null){
                    result.setSuccessful(true);
                    result.setData(yearreport);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
