package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;

import com.bcxin.ars.dto.page.TrainrecordPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.TrainChange;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.model.sb.Trainrecord;
import com.bcxin.ars.service.sb.TrainrecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.Logical;


/**
 * 保安培训单位备案Controller
 * 
 * @author lin
 * @date 2022-08-14
 */
@Controller
@RequestMapping("/trainRecord")
public class TrainrecordController{
    Logger logger = LoggerFactory.getLogger(TrainrecordController.class);

    @Autowired
    private TrainrecordService trainrecordService;


    @Autowired
    private ArsUtil arsUtil;
    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    @RequiresPermissions("trainRecord:view")
    public ModelAndView listIndex(TrainrecordPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("trainRecord/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("trainRecord:view")
    public AjaxPageResponse searchForPage(TrainrecordPageSearchDto dto, AjaxPageResponse<Trainrecord> page){
        trainrecordService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param trainrecord
     * @return
     */
    @RequestMapping("detail/index")
    @RequiresPermissions("trainRecord:view")
    public ModelAndView detailIndex(Trainrecord trainrecord){
        ModelAndView view = new ModelAndView("trainRecord/detail");

        if(trainrecord.getId() != null){
            view.addObject("record",trainrecordService.findById(trainrecord.getId()));
        }else {
            view.addObject("record", trainrecord);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param trainrecord
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(Trainrecord trainrecord){
        ModelAndView view = new ModelAndView("trainRecord/edit");

        if(trainrecord.getId() != null){
            view.addObject("record",trainrecordService.findById(trainrecord.getId()));
        }else {
            view.addObject("record", trainrecord);
        }

        return view;
    }

    /**
     * 保存
     * @param trainrecord
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(Trainrecord trainrecord){
        AjaxResult result = new AjaxResult();
        try {
            trainrecordService.save(trainrecord);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Trainrecord trainrecord = trainrecordService.findByUser(user.getId());
                if(trainrecord != null){
                    result.setSuccessful(true);
                    result.setData(trainrecord);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Trainrecord trainrecord = trainrecordService.findById(id);
            result.setSuccessful(true);
            result.setData(trainrecord);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("updateApprovalResult")
    public @ResponseBody
    AjaxResult updateApprovalResult(Long businessid, String approvalstate) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                Trainrecord trainrecord = trainrecordService.findById(businessid);
                if (trainrecord != null) {
                    trainrecord.setCensorStatus(approvalstate);
                    trainrecordService.updateSelective(trainrecord);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("charge/updateApprovalResult")
    public @ResponseBody
    AjaxResult updateChargeApprovalResult(Long businessid, String approvalstate) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                Trainrecord trainrecord = trainrecordService.findById(businessid);
                if (trainrecord != null) {
                    trainrecord.setChargeCensorStatus(approvalstate);
                    trainrecordService.updateSelective(trainrecord);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
