package com.bcxin.ars.rest.sb;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.SponsorlicenseSearchDto;
import com.bcxin.ars.dto.sb.TraincompanyapplySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.SecurityConfesscompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.service.SecurityConfesscompanyService;
import com.bcxin.ars.service.SecurityGuardService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.TraincompanyapplyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
@Controller
@RequestMapping("traincompanyapply")
public class TraincompanyapplyController {

    private Logger logger = LoggerFactory.getLogger(TraincompanyapplyController.class);
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;
    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private SecurityConfesscompanyService securityConfesscompanyService;

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private GXSSOUtil gxssoUtil;

    @Autowired
    private SecurityGuardService securityGuardService;

    /**
     * 查询培训单位信息
     * @param dto
     * @return
     */
    @RequestMapping("findAll")
    public @ResponseBody
    AjaxResult findAll(TraincompanyapplySearchDto dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            TraincompanyapplySearchDto data = traincompanyapplyService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("/searchTraincompanyapplyList_table")
    @ResponseBody
    public PageResult searchTraincompanyapplyList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                        HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        if (params.get("checkType")!=null) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                if (user.getPlatform() == 2) {
                    p.put("userid",user.getId());
                }else{
                    //角色列表
                    List<PoliceRole> roles = user.getRoles();
                    if(roles!=null&&roles.size()>0) {
                        p.put("roles",roles);
                    }
                }
            }
        }
        return traincompanyapplyService.searchTraincompanyapplyList_table(p);//进行查询，并转换
    }



    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(SponsorlicenseSearchDto searchDto){
        ModelAndView view = new ModelAndView("traincompany/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(TraincompanyapplySearchDto dto, AjaxPageResponse<Traincompanyapply> page){
        traincompanyapplyService.searchForPage(dto,page);
        return page;

    }



    @RequestMapping("updatePoliceId")
    public @ResponseBody AjaxResult updatePoliceId(Traincompanyapply traincompanyapply) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                traincompanyapplyService.updatePoliceId(traincompanyapply);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("savePermitDoc")
    public @ResponseBody AjaxResult savePermitDoc(Traincompanyapply traincompanyapply) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                traincompanyapplyService.savePermitDoc(traincompanyapply);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("search")
    public @ResponseBody AjaxResult search(TraincompanyapplySearchDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                if(user.getPlatform()==2){
                    dto.setUserid(user.getId());
                }
                result.setSuccessful(true);
                result.setData(traincompanyapplyService.search(dto));
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Traincompanyapply traincompanyapply, HttpSession httpSession) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                traincompanyapplyService.saveOrUpdate(traincompanyapply);
                String projectNo= (String) httpSession.getAttribute("projectNo");
                if (StringUtil.isNotEmpty(projectNo)){
                    String token= (String) httpSession.getAttribute("gxssotoken");
                    gxssoUtil.reportData(token,projectNo);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 暂存
     * <b>Function </b> 
     * 
     * @param traincompanyapply
     * @return
     * @throws Exception
     * @author LinQingLin 
     * @date 2017年9月15日 下午2:16:38
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("temporarySave")
	public @ResponseBody AjaxResult temporarySave(Traincompanyapply traincompanyapply) throws Exception{
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                traincompanyapplyService.temporarySave(traincompanyapply);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
	}
    
    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
  //  @RequiresPermissions("traincompanyapply:view")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(id);
            result.setSuccessful(true);
            result.setData(traincompanyapply);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Traincompanyapply traincompanyapply = traincompanyapplyService.findByUser(user.getId());
                if(traincompanyapply != null){
                    result.setSuccessful(true);
                    result.setData(traincompanyapply);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	Traincompanyapply traincompanyapply = traincompanyapplyService.findById(businessid);
                if(traincompanyapply != null){
                	traincompanyapply.setCensorStatus(approvalstate);
                	traincompanyapplyService.updateCensorStatus(traincompanyapply);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("plan/updateApprovalResult")
    public @ResponseBody AjaxResult updatePlanApprovalResult(Long businessid,String approvalstate){
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	Traincompanyapply traincompanyapply = traincompanyapplyService.findById(businessid);
                if(traincompanyapply != null){
                	traincompanyapply.setPlanCensorStatus(approvalstate);
                	traincompanyapplyService.updateCensorStatus(traincompanyapply);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 账号生成
     * @return
     */
    @RequestMapping("buildAccount/{id}")
    public @ResponseBody AjaxResult buildAccount(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(id);

            //源实体类的列，目标实体类的列
            String[] srccol = {"companyname","companytype","address","district","province","city","allownumber","name","phone"
                    ,"trainlegalname","traincreditcode","trainphone"};
            String[] desccol = {"pxdwmc","pxdwlb","zcdz","district","province","city","pxxkz","lxrxm","lxdh","xzxm","xzsfzh","xzdh"};
            //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
            String[] key = {};
            String[] value = {};
            //生成实体
            Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,traincompanyapply,new SecurityConfesscompany(),key,value);
            SecurityConfesscompany securityConfesscompany =(SecurityConfesscompany)desc;
            securityConfesscompany.setUserid(traincompanyapply.getUserid());
            securityConfesscompanyService.saveOrUpdate(securityConfesscompany);

            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    

    @RequestMapping("findByAreaReport")
	public @ResponseBody AjaxResult findByAreaReport(ReportDataSearchDto searchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			JSONObject resultObj = new JSONObject();
			DecimalFormat df = new DecimalFormat("#.0");
			List<ReportData> data = traincompanyapplyService.findByAreaReport(searchDto);
			List<String> nameList = new ArrayList<String>();
			Long total = 0l;
			for (ReportData reportData : data) {
				total = total + reportData.getValue();
			}
			for (ReportData reportData : data) {
				System.out.println(reportData.getName()+ "  "+ reportData.getValue() +"家  " + df.format(reportData.getValue()*100.0/total)+"%");
//				nameList.add(reportData.getName());

				nameList.add(reportData.getName()+ "  "+ reportData.getValue() +"家  " + df.format(reportData.getValue()*100.0/total)+"%");
				reportData.setName(reportData.getName()+ "  "+ reportData.getValue() +"家  " + df.format(reportData.getValue()*100.0/total)+"%");
			}
			resultObj.put("names", nameList);
			resultObj.put("values", data);
			resultObj.put("total", total);
			result.setSuccessful(true);
			result.setData(resultObj);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


    @RequestMapping("validateSecurityGuard")
    public @ResponseBody AjaxResult validateSecurityGuard(Traincompanyapply traincompany) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                String data = securityGuardService.validateSecurityGuard(traincompany);
                result.setData(data);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
