package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.TrainChangeSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.TrainChange;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sb.TrainChangeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */

@Controller
@RequestMapping("trainChange")
public class TrainChangeController {
    Logger logger = LoggerFactory.getLogger(TrainChangeController.class);
	
	@Autowired
	private TrainChangeService trainChangeService;

	@Autowired
	private SecurityCompanyService securityCompanyService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private SecurityCompanyService companyService;
	
	@Autowired
	private UserService userService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody
    AjaxResult search(TrainChangeSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(user.getPlatform()==2){
					dto.setUserid(user.getId());
				}

				TrainChangeSearchDto list = trainChangeService.search(dto);
				if(list.getData() != null && list.getData().size() >=0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/***
	 * 项目变更证书打印页面
	 * @return
	 */
	@RequestMapping("certificateListPage")
	public ModelAndView certificateListPage(TrainChangeSearchDto dto){
		ModelAndView view = new ModelAndView();
		view.setViewName("trainChange/list");
		view.addObject("record",dto);
		return view;
	}


	/***
	 * 项目变更证书打印页面
	 * @return
	 */
	@RequestMapping("searchCompanyCertificate")
    public @ResponseBody
	AjaxResult searchCompanyCertificate(TrainChangeSearchDto dto) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
//				User currentUser = arsUtil.getCurrentUser();
//				//机构信息
//				Police police = currentUser.getPolice();
//				if(police != null) {
//					String areacode = police.getAreacode();
//					if (areacode.endsWith("0000")) {//省
//						dto.setDistrict(areacode.substring(0, 2) + "____");
//					} else if (areacode.endsWith("00")) {//市
//						dto.setDistrict(areacode.substring(0, 4) + "__");
//					} else {//区
//						dto.setDistrict(areacode);
//					}
//				}
				TrainChangeSearchDto data = trainChangeService.searchCompanyCertificate(dto);
				result.setSuccessful(true);
				result.setData(data);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}



	/***
	 * 项目变更证书打印页面
	 * @return
	 */
	@RequestMapping("addCertificatePage")
	public ModelAndView addCertificatePage(Long trainChangeId ){
		ModelAndView view = new ModelAndView();

		//项目变更信息
		TrainChange  trainChange = trainChangeService.findById(trainChangeId);

		//公司信息
		SecurityCompany securityCompany = securityCompanyService.findById(trainChange.getCompanyid());

		//保安服务公司
		if(Constants.BKT_ORGTYPE_GS.equals(securityCompany.getInstitutionType())){
			view.setViewName("trainChange/trainChangeapprovalComany");
		}else{//培训单位
			view.setViewName("trainChange/trainChangeapprovalTrain");
		}
		//设置公司信息 add 2019-01-31 subh
		if(securityCompany!=null) {
			trainChange.setSecurityCompany(securityCompany);
		}
		view.addObject("trainChange",JSONUtil.toJsonStr(trainChange));



		return view;
	}



	@RequestMapping("/searchTrainChangeList_table")
	@ResponseBody
	public PageResult searchTrainChangeList_table(@RequestParam Map<Object, Object> params, ModelMap model,
												  HttpServletRequest req, HttpServletResponse resp) {
		Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
		if (params.get("checkType")!=null) {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				if (user.getPlatform() == 2) {
					p.put("userid",user.getId());
				} else{
					//角色列表
					List<PoliceRole> roles = user.getRoles();
					if(roles!=null&&roles.size()>0) {
						p.put("roles",roles);
					}
				}
			}
		}


		return trainChangeService.searchTrainChangeList_table(p);
	}



	@RequestMapping("list/index")
	public ModelAndView listIndex(TrainChangeSearchDto searchDto){
		ModelAndView view = new ModelAndView("trainChange/list2");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(TrainChangeSearchDto dto, AjaxPageResponse<TrainChange> page){
		if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				dto.setUserid(user.getId());
			}
		}
		trainChangeService.searchForPage(dto,page);
		return page;
	}















	@RequestMapping("update")
	public @ResponseBody
    AjaxResult update(TrainChange trainChange) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				trainChangeService.saveOrUpdate(trainChange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("updateAndSaveWorkExperience")
	public @ResponseBody
    AjaxResult updateAndSaveWorkExperience(TrainChange trainChange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				trainChangeService.updateAndSaveWorkExperience(trainChange,startdate,enddate,workCompanyname,post);
				result.setData(trainChange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody
    AjaxResult delete(TrainChange trainChange) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				trainChangeService.delete(trainChange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody
    AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			TrainChange trainChange = trainChangeService.findById(id);
			
			if(trainChange != null){
				SecurityCompany company = companyService.findByUserid(trainChange.getUserid());
				trainChange.setSecurityCompany(company);
				result.setSuccessful(true);
				result.setData(trainChange);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody
    AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	TrainChange trainChange = trainChangeService.findByUser(user.getId());
				//获取单位信息
				SecurityCompany company = companyService.findByUserid(user.getId());

                if(trainChange != null){
					trainChange.setSecurityCompany(company);
					result.setSuccessful(true);
                    result.setData(trainChange);
                }else if(trainChange == null && company!=null){
					trainChange = new TrainChange();
					result.setSuccessful(true);
					trainChange.setSecurityCompany(company);
					result.setData(trainChange);
				}
				else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

	@RequestMapping("updateApprovalResult")
	public @ResponseBody
	AjaxResult updateApprovalResult(Long businessid, String approvalstate) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				TrainChange trainChange = trainChangeService.findById(businessid);
				if (trainChange != null) {
					trainChange.setTrainCensorstatus(approvalstate);
					trainChangeService.updateCensorStatus(trainChange);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("plan/updateApprovalResult")
	public @ResponseBody
	AjaxResult updatePlanApprovalResult(Long businessid, String approvalstate) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				TrainChange trainChange = trainChangeService.findById(businessid);
				if (trainChange != null) {
					trainChange.setNdtrainCensorstatus(approvalstate);
					trainChangeService.updateCensorStatus(trainChange);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 指派民警
	 * @param trainChange
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("updatePoliceId")
	public @ResponseBody AjaxResult updatePoliceId(TrainChange trainChange) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				trainChangeService.updatePoliceId(trainChange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据公司ID获取明细
	 * @return
	 */
	@RequestMapping("findApprovePassByCompanyId")
	public @ResponseBody
	AjaxResult findApprovePassByCompanyId(Long companyId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<TrainChange> trainChanges = trainChangeService.findApprovePassByCompanyId(companyId);
			result.setSuccessful(true);
			result.setData(trainChanges);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
