package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SubsidiarySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.SubsidiaryService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
@Controller
@RequestMapping("subsidiary")
public class SubsidiaryController {

    private Logger logger = LoggerFactory.getLogger(SubsidiaryController.class);
    @Autowired
    private SubsidiaryService subsidiaryService;

    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private GXSSOUtil gxssoUtil;
    
    /**
     * 查询培训单位信息
     * @param dto
     * @return
     */
    @RequestMapping("findAll")
    public @ResponseBody
    AjaxResult findAll(SubsidiarySearchDto dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SubsidiarySearchDto data = subsidiaryService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("/searchSubsidiaryList_table")
    @RequiresPermissions("subsidiary:query")
    @ResponseBody
    public PageResult searchSubsidiaryList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                 HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        if (params.get("checkType")!=null) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                if (user.getPlatform() == 2) {
                    p.put("userid",user.getId());
                }else{
                    //角色列表
                    List<PoliceRole> roles = user.getRoles();
                    if(roles!=null&&roles.size()>0) {
                        p.put("roles",roles);
                    }
                }
            }
        }
        return subsidiaryService.searchSubsidiaryList_table(p);//进行查询，并转换
    }











    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    @RequiresPermissions("subsidiary:query")
    public ModelAndView listIndex(SubsidiarySearchDto searchDto){
        ModelAndView view = new ModelAndView("subsidiary/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("subsidiary:query")
    public AjaxPageResponse searchForPage(SubsidiarySearchDto dto, AjaxPageResponse<Subsidiary> page){
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
            }
        }
        subsidiaryService.searchForPage(dto,page);
        return page;
    }







    @RequestMapping("search")
    public @ResponseBody AjaxResult search(SubsidiarySearchDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                if(user.getPlatform()==2){
                    dto.setUserid(user.getId());
                }
                result.setSuccessful(true);
                result.setData(subsidiaryService.search(dto));
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Subsidiary subsidiary, HttpSession httpSession) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                subsidiaryService.saveOrUpdate(subsidiary);
                String projectNo= (String) httpSession.getAttribute("projectNo");
                if (StringUtil.isNotEmpty(projectNo)){
                    String token= (String) httpSession.getAttribute("gxssotoken");
                    gxssoUtil.reportData(token,projectNo);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Subsidiary subsidiary = subsidiaryService.findById(id);
            result.setSuccessful(true);
            result.setData(subsidiary);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Subsidiary subsidiary = subsidiaryService.findByUser(user.getId());
                if(subsidiary != null){
                    result.setSuccessful(true);
                    result.setData(subsidiary);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Subsidiary subsidiary = subsidiaryService.findById(businessid);
                if(subsidiary != null){
                    subsidiary.setLegalcensorstatus(approvalstate);
                    subsidiaryService.updateCensorStatus(subsidiary);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("plan/updateApprovalResult")
    public @ResponseBody AjaxResult updatePlanApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Subsidiary  subsidiary = subsidiaryService.findById(businessid);
                if(subsidiary != null){
                    subsidiary.setChargecensorstatus(approvalstate);
                    subsidiaryService.updateCensorStatus(subsidiary);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
