package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbSponsorlicenseManagerSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SbSponsorlicenseManager;
import com.bcxin.ars.service.sb.SbSponsorlicenseManagerService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("sbSponsorlicenseManager")
public class SbSponsorlicenseManagerController {

	Logger logger = LoggerFactory.getLogger(SbSponsorlicenseManagerController.class);
	
	@Autowired
	private SbSponsorlicenseManagerService sbSponsorlicenseManagerService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(SbSponsorlicenseManagerSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				SbSponsorlicenseManagerSearchDto list = sbSponsorlicenseManagerService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(SbSponsorlicenseManager sbSponsorlicenseManager) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				sbSponsorlicenseManagerService.saveOrUpdate(sbSponsorlicenseManager);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbSponsorlicenseManager sbSponsorlicenseManager = sbSponsorlicenseManagerService.findById(id);
			result.setSuccessful(true);
			result.setData(sbSponsorlicenseManager);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
    	AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	SbSponsorlicenseManager sbSponsorlicenseManager = sbSponsorlicenseManagerService.findById(businessid);
                if(sbSponsorlicenseManager != null){
					sbSponsorlicenseManager.setCensorstatus(approvalstate);
                	sbSponsorlicenseManagerService.updateCensorStatus(sbSponsorlicenseManager);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
