package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sb.HandleGuide;
import com.bcxin.ars.model.sb.PrintDesign;
import com.bcxin.ars.service.sb.HandleGuideService;
import com.bcxin.ars.service.sb.PrintDesignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
/**
 * @author  wjb
 * @desc 打印设计Controller类
 * @date 2018年10月15日16:52:42
 */
@Controller
@RequestMapping("printDesign")
public class PrintDesignController {

	Logger logger = LoggerFactory.getLogger(PrintDesignController.class);
	
	@Autowired
	private PrintDesignService printDesignService;
	
	
	@RequestMapping("findByAreacode")
	public @ResponseBody AjaxResult findByBusinessType(String areacode,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<PrintDesign> printDesignList = printDesignService.findByAreacode(areacode,type);
			result.setSuccessful(true);
			result.setData(printDesignList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
