package com.bcxin.ars.rest.sb;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.abcxin.smart.validator.annotation.FormToken;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.sys.FileTempDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.certificate.DSSecurityCertificateDto;
import com.bcxin.ars.dto.report.PersonCertificateReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.*;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.fingerPrint.FingerPrint;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.OrderInfo;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sb.VPersoncertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.FileTemp;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.service.sb.OrderDetailService;
import com.bcxin.ars.service.sb.OrderInfoService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.syncDepart.SyncDepartService;
import com.bcxin.ars.service.sys.ApprovalLogService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.task.ComContractService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.crypto.BadPaddingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.*;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by 苏 on 2017/5/19.
 */

@Controller
@RequestMapping("personcertificate")
public class PersoncertificateController {
    Logger logger = LoggerFactory.getLogger(PersoncertificateController.class);
    @Value("${third_url}")
    private String thirdUrl;

    @Value("${channel}")
    private String channel;

    @Value("${callBackUrl}")
    private String callBackUrl;

    @Value("${callFrontUrl}")
    private String callFrontUrl;
    @Autowired
    private OrderInfoService orderInfoService;
    @Autowired
    private OrderDetailService orderDetailService;

    @Autowired
    private PersoncertificateService personcertificateService;

    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ApprovalService approvalService;
    @Autowired
    private ApprovalLogService approvalLogService;

    @Autowired
    private SyncDepartService syncDepartService;

    @Autowired
    private UserService userService;

    @Autowired
    private NationService nationService;

    @Autowired
    private SecurityCompanyService securityCompanyService;
    @Autowired
    private SecurityCertificateService securityCertificateService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ComContractService comContractService;

    @Autowired
    private ArsUtil arsUtil;

    @Value("${upload-folder}")
    private String uploadFolder;
    @Autowired
    private SysareaService sysareaService;

    @Value("${approval-download-folder}")
    private String downloadFolder;

    @Value("${temp-folder}")
    private String tempfolder;

    @Autowired
    private ConfigDao configDao;

    @Autowired
    private FileTempDao fileTempDao;

    @Autowired
    private TrainExamInfoService trainExamInfoService;

    @Autowired
    private GXSSOUtil gxssoUtil;

    @Autowired
    private PctinfoService pctinfoService;

    public @ResponseBody
    AjaxResult search(PersoncertificateSearchDto dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            PersoncertificateSearchDto list = personcertificateService.search(dto);
            result.setSuccessful(true);
            result.setData(list);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取明细
     *
     * @return
     */
    @RequestMapping("findByCardnumber/{cardnumber}")
    public @ResponseBody
    AjaxResult findByCardnumber(@PathVariable("cardnumber") String cardnumber) {
        AjaxResult result = new AjaxResult();
        try {
            Personcertificate personcertificate = personcertificateService.getCardStateByCardnumber(cardnumber);
            if (personcertificate != null) {
                result.setSuccessful(true);
                result.setData(personcertificate);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("updateProState")
    public @ResponseBody
    AjaxResult updateProState(Personcertificate personcertificate) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                personcertificateService.updateProState(personcertificate);
                result.setData(personcertificate);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("/searchPrintList_table")
    @RequiresPermissions("personcertificatePrint:query")
    @ResponseBody
    public PageResult searchPrintList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                        HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);// 查询初始化

        //北京不需要数据权限过滤
        if(! Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            User user = arsUtil.getCurrentUser();
            Police police = user.getPolice();
            //如果是派出所查询派出所的保安员证信息
            if ("4".equals(police.getOrgtype())) {
                p.put("orgid", police.getId());
            }

            String areacode = police.getAreacode();

            if (p.get("orgtype") != null && StringUtil.isNotEmpty(p.get("orgtype").toString())) {
                String orgtype = p.get("orgtype").toString();
                if ("4".equals(orgtype)) {// 派出所
                    p.put("orgid", p.get("nodeid"));
                }
            }


            if (p.get("areaCode") != null && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
                areacode = p.get("areaCode").toString();
                p.put("userAreaCode", "false");
            } else {
                p.put("userAreaCode", "true");
            }


            if (areacode.endsWith("0000")) {// 省
                p.put("areaCode", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                p.put("areaCode", areacode.substring(0, 4) + "__");
            }
            /**
             * 当前省份信息
             */
            Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);
            //宁夏旧数据取消省市区过滤
            if(p.get("isOldData") != null && "1".equals(p.get("isOldData").toString())){
                if (provinceConfig != null) {
                    if (StringUtil.isNotEmpty(provinceConfig.getValue()) && "640000".equals(provinceConfig.getValue())) {
                        p.put("areaCode", null);
                    }
                }
            }
            //数据权限
            if(user.getAreasList()!=null &&user.getAreasList().size()>0) {
                p.put("areasList", user.getAreasList());
            }
        }

        return personcertificateService.searchPrintList(p);// 进行查询，并转换
    }

    /**
     * 保安员考试统计方法
     *
     * @param params
     * @param model
     * @param req    auth by llc 2018-08-23
     * @return
     */
    @RequestMapping("certificateTable")
    @ResponseBody
    public Object certificateTable(@RequestParam Map<Object, Object> params, ModelMap model, HttpServletRequest req,
                             HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);// 查询初始化

        User user = arsUtil.getCurrentUser();

        String areacode = "", defaultAcreacode = "";
        Police police = null;
        //获取当前用户默认所属区域 wjb 2018年9月6日13:57:42
        if (null != user.getPolice() && null != user.getPolice().getAreacode()) {
            defaultAcreacode = user.getPolice().getAreacode();
            police = user.getPolice();
        }
        //用户所选择的区域
        if (p.get("areaCode") != null && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
            areacode = p.get("areaCode").toString();

        }
        //先根据用户所选区域查询
        if (StringUtil.isNotEmpty(areacode)) {

            if (areacode.endsWith("0000")) {// 省
                p.put("areaCode", areacode.substring(0, 2));
            } else if (areacode.endsWith("00")) {// 市
                p.put("areaCode", areacode.substring(0, 4));
            } else {
                p.put("areaCode", areacode);
            }

        }
        // 再根据用户所属区域默认查询
        if (defaultAcreacode.endsWith("0000")) {
            // 市
            p.put("defaultAcreacode", defaultAcreacode.substring(0, 2));
        } else if (defaultAcreacode.endsWith("00")) {
            p.put("defaultAcreacode", defaultAcreacode.substring(0, 4));
        } else {
            p.put("defaultAcreacode", defaultAcreacode);
        }


        p.put("userid", user.getId());
        p.put("path", user.getPolice().getPath());
        Map<String, Object> result = personcertificateService.statisCertificate(p);
        JSONObject json = new JSONObject();
        json.put("allCount", result.get("sumCount"));
        json.put("waitApprovalCount", result.get("dspCount"));
        json.put("approvalCount", result.get("sptgCount"));
        json.put("noApprovalCount", result.get("spbtgCount"));
        json.put("readyApprovalCount", result.get("spzCount"));
        json.put("queryJoinCnt", result.get("cjksCount"));
        json.put("queryTestCnt", result.get("kstgCount"));
        json.put("passRate", result.get("kstgl"));
        return json;
    }

    @RequestMapping("certificateList_table")
    @ResponseBody
    public PageResult query(@RequestParam Map<Object, Object> params, ModelMap model, HttpServletRequest req,
                        HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);// 查询初始化
        User user = arsUtil.getCurrentUser();
        String areacode = "", defaultAcreacode = "";
        Police police = null;
        //获取当前用户默认所属区域 wjb 2018年9月6日13:57:42
        if (null != user.getPolice() && null != user.getPolice().getAreacode()) {
            defaultAcreacode = user.getPolice().getAreacode();
            police = user.getPolice();
        }
        if (p.get("areaCode") != null && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
            areacode = p.get("areaCode").toString();

        }
        //先根据用户所选区域查询
        if (StringUtil.isNotEmpty(areacode)) {

            if (areacode.endsWith("0000")) {// 省
                p.put("areaCode", areacode.substring(0, 2));
            } else if (areacode.endsWith("00")) {// 市
                p.put("areaCode", areacode.substring(0, 4));
            } else {
                p.put("areaCode", areacode);
            }

        }
        // 再根据用户所属区域默认查询
        if (defaultAcreacode.endsWith("0000")) {// 省
            p.put("defaultAcreacode", defaultAcreacode.substring(0, 2));
        } else if (defaultAcreacode.endsWith("00")) {// 市
            p.put("defaultAcreacode", defaultAcreacode.substring(0, 4));
        } else {
            p.put("defaultAcreacode", defaultAcreacode);
        }


        p.put("userid", user.getId());
        p.put("path", user.getPolice().getPath());
        return personcertificateService.statisCertificateList(p);// 进行查询，并转换
    }

    @RequestMapping("update")
    @CheckFormToken
    public @ResponseBody
    AjaxResult update(Personcertificate personcertificate, HttpSession httpSession) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);

                if(Constants.YANAN.equals(personcertificate.getCity())){
                    result.setSuccessful(false);
                    result.setMsg("延安自然人报名请联系延安市保安培训机构");
                }else if(Constants.SHANGLUO.equals(personcertificate.getCity())){
                    result.setSuccessful(false);
                    result.setMsg("商洛自然人报名请联系商洛市保安培训机构");
                }else{
                    personcertificateService.saveOrUpdate(personcertificate);
                    result.setData(personcertificate);
                    String projectNo= (String) httpSession.getAttribute("projectNo");
                    if (StringUtil.isNotEmpty(projectNo)){
                        String token= (String) httpSession.getAttribute("gxssotoken");
                        gxssoUtil.reportData(token,projectNo);
                    }
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 暂存 <b>Function </b>
     *
     * @param personcertificate
     * @return
     * @author LinQingLin
     * @date 2017年9月13日 下午5:52:10
     * @注意事项 </b> <b>
     */
    @RequestMapping("temporarySave")
    public @ResponseBody
    AjaxResult temporarySave(Personcertificate personcertificate) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                personcertificateService.temporarySave(personcertificate);
                result.setData(personcertificate);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("delete")
    public @ResponseBody
    AjaxResult delete(Personcertificate personcertificate) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                personcertificateService.delete(personcertificate);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取明细
     *
     * @return
     */
    @RequestMapping("findById/{id}")
    @FormToken
    public @ResponseBody
    AjaxResult findById(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Personcertificate personcertificate = personcertificateService.findById(id);
            SecurityCompany securityCompany = securityCompanyService.findById(personcertificate.getCompanyid());
            if (securityCompany != null) {
                personcertificate.setSecurityCompany(securityCompany);
            }

            if (personcertificate != null) {
                result.setSuccessful(true);
                result.setData(personcertificate);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据当前登录用户获取明细
     *
     * @return
     */
    @RequestMapping("findByCurrentUser")
    @FormToken
    public @ResponseBody
    AjaxResult findByCurrentUser() {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                Personcertificate personcertificate = personcertificateService.findByUser(user.getId());
                if (personcertificate != null) {
                    result.setSuccessful(true);
                    result.setData(personcertificate);
                } else {
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 报名状态确认
     *
     * @param ids
     *            身份证号
     * @return
     */
    @RequestMapping("updateBMState/{ids}")
    public @ResponseBody
    AjaxResult updateBMState(@PathVariable("ids") String ids, String approvalreason) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                // 旧 根据身份证号查找 2018年7月31日14:07:16
                // Personcertificate personcertificate =
                // personcertificateService.getCardStateByCardnumber(cardnumber);
                // 新 根据Id查找
                Personcertificate personcertificate = personcertificateService.getCardStateByIds(ids);
                if (personcertificate != null) {

                    // 是否报名确认
                    if (personcertificate.getSignConfirm() == null
                            || !"001".equals(personcertificate.getSignConfirm())) {

                        Approval approval = approvalService.findBybusinessidAndType(personcertificate.getId(),
                                BusinessType.BAYZ);

                        Config configVersion = configService.findByKey(Constants.APPROVAL_VERSION_SWITCH);
                        if (approval != null) {
                            // 2018年6月5日16:54:24 新旧审批区分 新审批增加环节的判断
                            if (configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())
                                    && (approval.getGroupid() == null
                                    || !Constants.APPROVAL_NUM_BM_GROUPID.equals(approval.getGroupid()))) {
                                result.setSuccessful(false);
                                result.setMsg("不在报名确认环节！");
                                return result;
                            }
                        }
                        if (StringUtil.isNotEmpty(approvalreason)) {
                            // 旧 根据身份证号更新
                            // personcertificateService.updateBMState(cardnumber,approvalreason);
                            // 新 根据Id 更新 2018年7月31日11:07:24
                            personcertificateService.updateBMStateByid(Long.parseLong(ids), approvalreason);
                        } else {
                            // personcertificateService.updateBMState(cardnumber);
                            personcertificateService.updateBMStateByid(Long.parseLong(ids));
                        }

                        result.setMsg("报名确认成功！！！");
                        result.setSuccessful(true);
                    } else {
                        result.setSuccessful(false);
                        result.setMsg("已经报名确认，无须再确认！！！");
                    }

                } else {
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /***
     * 批量报名状态确认
     *
     * @param cardnumberArr
     *            身份证号
     * @return
     */
    @RequestMapping("updateBMStateByIdnumArr")
    public @ResponseBody
    AjaxResult updateBMStateByIdnumArr(String[] cardnumberArr, Long[] ids) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {

                PersoncertificateSearchDto dto = new PersoncertificateSearchDto();

                // 旧 根据身份证查找
                // dto.setCardnumberArrs(cardnumberArr);
                // List<Personcertificate> personcertificateList =
                // personcertificateService.findByNumberIdArr(dto);

                // 新 根据ID查找 2018年7月31日10:16:19 by wjb
                dto.setIdArrs(ids);
                List<Personcertificate> personcertificateList = personcertificateService.findByDtoIdArr(dto);

                String failMsg = "", sucMsg = "", deMsg = "";
                for (Personcertificate personcertificate : personcertificateList) {
                    if (personcertificate != null) {
                        // 是否报名确认
                        if (personcertificate.getSignConfirm() == null
                                || !"001".equals(personcertificate.getSignConfirm())) {
                            Approval approval = approvalService.findBybusinessidAndType(personcertificate.getId(),
                                    BusinessType.BAYZ);
                            Config configVersion = configService.findByKey(Constants.APPROVAL_VERSION_SWITCH);
                            if (approval != null) {
                                if (configVersion != null
                                        && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())
                                        && (approval.getGroupid() == null
                                        || !approval.getGroupid().equals(Constants.APPROVAL_NUM_BM_GROUPID))) {
                                    failMsg += personcertificate.getName() + ",";
                                } else {
                                    // 旧 根据身份证号更新报名状态 2018年7月31日14:07:42
                                    // personcertificateService.updateBMState(personcertificate.getCardnumber(),"");

                                    // 新 根据Id更新报名状态
                                    personcertificateService.updateBMStateByid(personcertificate.getId(), "");
                                    sucMsg += personcertificate.getName() + ",";
                                }
                            } else {
                                failMsg += personcertificate.getName() + ",";
                            }
                        } else {
                            deMsg += personcertificate.getName() + ",";
                        }
                    } else {
                        result.setSuccessful(false);
                    }
                }
                String msg = "";
                if (!"".equals(sucMsg)) {
                    msg += sucMsg + "报名确认成功！！！";
                }
                if (!"".equals(failMsg)) {
                    msg += failMsg + "不在报名确认环节！！！";
                }
                if (!"".equals(deMsg)) {
                    msg += deMsg + "已经报名确认，无须再确认！！！";
                }

                result.setMsg(msg);

                if ("".equals(sucMsg)) {
                    result.setSuccessful(false);
                } else {
                    result.setSuccessful(true);
                }
            } else {
                result.setSuccessful(false);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 批量结束考试流程
     *
     * @param cardnumberArr
     *            身份证号
     * @return
     */
    @RequestMapping("updateProStateIdNumArr")
    public @ResponseBody
    AjaxResult updateProStateIdNumArr(String[] cardnumberArr, String proState, String examID) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {

                PersoncertificateSearchDto dto = new PersoncertificateSearchDto();
                result.setSuccessful(true);
                dto.setCardnumberArrs(cardnumberArr);
                dto.setProState(proState);
                personcertificateService.updateProstateByNumberIdArr(dto, examID);

            } else {
                result.setSuccessful(false);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("updateApprovalResult")
    public @ResponseBody
    AjaxResult updateApprovalResult(Long businessid, String approvalstate) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                Personcertificate personcertificate = personcertificateService.findById(businessid);
                if (personcertificate != null) {
                    personcertificate.setCensorStatus(approvalstate);
                    personcertificateService.updateCensorStatus(personcertificate);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * @param personcertificate
     * @return com.bcxin.ars.dto.AjaxResult
     * @Decription:录入成绩
     * @author：zhongjianhui
     * @method updateTestSocre
     * @date：2018/12/12 13:36
     * @params： * @param businessid
     */
    @RequestMapping("updateTestSocre")
    public @ResponseBody
    AjaxResult updateTestSocre(Personcertificate personcertificate) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                Personcertificate dbpersoncertificate = personcertificateService.findById(personcertificate.getId());
                if (personcertificate != null) {
                    dbpersoncertificate.setOperateScore(personcertificate.getOperateScore());
                    dbpersoncertificate.setWrittenScore(personcertificate.getWrittenScore());
                    dbpersoncertificate.setTestState(personcertificate.getTestState());
                    dbpersoncertificate.setUpdateTime(new Date());
                    dbpersoncertificate.setUpdateBy(user.getUsername());
                    personcertificateService.updateTestSocre(dbpersoncertificate);
                    result.setSuccessful(true);
                    result.setMsg("成绩已录入!");
                } else {
                    result.setSuccessful(false);
                    result.setMsg("找不到该人员");
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**************************************************
     ************* 与培训平台对接接口 开始**********************
     **************************************************/
    /**
     * <b>Function </b> 查询支付详情(百课堂自然人缴费)
     *
     * @param params
     * @returna
     * @author zjh
     * @date 2018年8月27日 19:38:19
     * @注意事项 </b> <b>
     */
    @RequestMapping("/findPayDetail")
    public ModelAndView findPayDetail(@RequestParam Map<Object, Object> params, ModelMap model, HttpServletRequest req,
                                      HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);// 查询初始化
        ModelAndView view = new ModelAndView();
        view.setViewName("apply/payDetail");
        if (p.get("id") != null && StringUtil.isNotEmpty(p.get("id").toString())) {
            OrderInfo orderInfo = orderInfoService.findByDetailId(Long.valueOf(p.get("id").toString()));

            view.addObject("orderInfo", JSON.toJSON(orderInfo));
        }

        return view;

    }

    /**
     * @return com.bcxin.ars.dto.AjaxResult
     * @Decription:确认可制证人员
     * @author：zhongjianhui
     * @method checkConfirmOrder
     * @date：2018/12/13 13:41
     * @params： * @param personIds
     */
    @RequestMapping("/checkConfirmOrder")
    @ResponseBody
    public AjaxResult checkConfirmOrder(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        if (personIds != null) {
            List<Map> mapList = personcertificateService.checkConfirmOrder(personIds);
            result.setMsg("确认成绩-人员信息查询-返回成功");
            result.setSuccessful(true);
            if (mapList.size() > 0) {
                String canConfirmOrderIds = "";
                String personsInfo = "";
                for (Map map : mapList) {

                    if (map.get("Name") != null) {
                        personsInfo += map.get("Name").toString();
                    }
                    personsInfo += "|";
                    if (map.get("Cardnumber") != null) {
                        personsInfo += map.get("Cardnumber").toString();
                    }
                    if (map.get("id") != null) {
                        canConfirmOrderIds += map.get("id").toString() + ",";
                    }
                    personsInfo += " ,";
                }
                if (personsInfo.length() > 0) {
                    personsInfo = personsInfo.substring(0, personsInfo.length() - 1);
                    canConfirmOrderIds = canConfirmOrderIds.substring(0, canConfirmOrderIds.length() - 1);
                }
                //
                result.setData(personsInfo);
                //确认名单
                result.setObj(canConfirmOrderIds);
                //确认成绩个数
                int mapSize = mapList.size();
                //前端传过来的人数
                int personIdSize = personIds.length;
                if (personIdSize == mapSize) {
                    result.setMsg("确认成绩失败，所选人员都不可确认成绩");
                    result.setSuccessful(false);
                    result.setData("");
                    return result;
                }
            } else {
                result.setData("");
            }

        } else {
            result.setMsg("确认成绩失败，请选择确认成绩人员");
            result.setSuccessful(false);
            result.setData("");
        }

        return result;
    }

    /**
     * @return com.bcxin.ars.dto.AjaxResult
     * @Decription:批量确认制证
     * @author：zhongjianhui
     * @method checkConfirmOrder
     * @date：2018/12/13 13:41
     * @params： * @param personIds
     */
    @RequestMapping("/batchSaveConfirmOrder")
    @ResponseBody
    public AjaxResult batchSaveConfirmOrder(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        if (personIds != null) {
            personcertificateService.batchSaveConfirmOrder(personIds,user.getRealname());
            result.setMsg("确认成绩-返回成功");
            result.setSuccessful(true);
        } else {
            result.setMsg("确认成绩失败，请选择确认成绩人员");
            result.setSuccessful(false);
            result.setData("");
        }

        return result;
    }

    /**
     * <b>Function </b> 查询百课堂机构(百课堂自然人缴费)
     *
     * @param params
     * @return
     * @author zjh
     * @date 2018年8月27日 19:38:19
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/searchBKTList_table")
    public ModelAndView searchBKTList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                            HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        ModelAndView view = new ModelAndView();
        view.setViewName("apply/bktOrgPrice");
        //获取百课堂配置地址
        Config configURL = configDao.findByKey(Constants.BKT_DATA_URL);

        if (configURL != null && configURL.getValue() != null) {
            //"http://192.168.30.99:8888/"
            String url = configURL.getValue() + Constants.BTK_PXJGPRICE;

            //地址访问
            String btkRtn = HttpClientUtils.getContentFromUrl(url);

            if (btkRtn != null) {
                JSONObject jsonObject = JSONObject.parseObject(btkRtn);
                //获取状态值
                String data = jsonObject.get("data").toString();
                view.addObject("orgListData", jsonObject.get("data"));
                //转成json
                List<OrgPriceDTO> list = JSON.parseArray(data, OrgPriceDTO.class);
                if (list != null && list.size() > 0) {

                    view.addObject("orgList", list);
                }
            }
        }

        view.addObject("id", p.get("id"));
        view.addObject("payId", p.get("payId"));
        return view;

    }

    /**
     * <b>Function </b> 生成缴费订单(百课堂自然人缴费)
     *
     * @param params
     * @return
     * @author zjh
     * @date 2018年8月27日 19:38:19
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/payForPersonCertificate")
    @ResponseBody
    public Object payForPersonCertificate(@RequestParam Map<Object, Object> params, ModelMap model,
                                          HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        JSONObject json = new JSONObject();
        User user = arsUtil.getCurrentUser();

        String orgList = p.get("orgListData").toString();
        List<OrgPriceDTO> list = new ArrayList<>();
        if (p.get("orgListData") != null && StringUtil.isNotEmpty(orgList)) {
            list = JSON.parseArray(orgList, OrgPriceDTO.class);
        }

        List<Personcertificate> personcertificateList = new ArrayList<>();
        Long payId = null;
        if (p.get("payId") != null && p.get("payId").toString() != "") {
            payId = Long.valueOf(p.get("payId").toString());
        }
        String personList = p.get("personList").toString();
        if (p.get("personList") != null && StringUtil.isNotEmpty(personList)) {
            personcertificateList = JSON.parseArray(personList, Personcertificate.class);
        }


        json = personcertificateService.payForPersonCertificate(personcertificateList, list, p.get("organID").toString(), user.getUsername(), payId);
        return json;

    }

    /**
     * <b>Function </b> 跳转银联支付界面(百课堂自然人缴费)
     *
     * @param orderId
     * @return
     * @author zjh
     * @date 2018年8月27日 19:38:19
     * @注意事项 </b> <b>
     */
    @RequestMapping("personCertificateO2OPay/{orderId}")
    public ModelAndView b2bPayByOrderId(@PathVariable Long orderId) {
        ModelAndView view = new ModelAndView("redirect:" + thirdUrl);
        OrderInfo orderInfo = orderInfoService.fingById(orderId);

        String web_host = configService.findByKey("web_host").getValue();
        Config order_pay_test = configService.findByKey("order_pay_test");
        // 本地调试请打开此配置，切勿修改开发数据库中配置的地址，将扰乱其它环境！
//		 web_host= "http://justme070.xicp.net/";

        String transSign = MD5Util.string2MD5(channel + DateUtil.getCurrentDate());
        // 订单号
        view.addObject("orderNo", orderInfo.getId());
        if (order_pay_test != null && order_pay_test.getValue().equals("1")) {
            // 金额
            view.addObject("payAmt", "0.01");
        } else {
            view.addObject("payAmt", orderInfo.getOrderSumMoney());
        }
        // 签名
        view.addObject("transSign", transSign);
        // 渠道
        view.addObject("channel", channel);
        // 回调地址（接口）
        view.addObject("callbackUrl", web_host + "/" + "personcertificate/callBack.do");
        // 回调地址（前台）
        view.addObject("callfrontUrl", web_host + "/" + "personcertificate/callFront.do");
        // 产品
        view.addObject("product", "保安员资格证考试报名缴费");
        return view;
    }

    /**
     * <b>Function </b> 支付完成回调处理(百课堂自然人缴费)
     *
     * @param request
     * @param res
     * @author LinQingLin
     * @date 2017年4月14日 下午6:40:29
     * @注意事项 </b> <b>
     */
    @RequestMapping("callBack")
    public void callBack(HttpServletRequest request, HttpServletResponse res) {
        try {
            Map<String, String> respParam = getAllRequestParam(request);
            // 打印请求报文
            logger.debug(respParam.toString());

            String orderNo = respParam.get("orderNo");
            String payStatus = respParam.get("payStatus");
            String transSign = respParam.get("transSign");
            OrderInfo orderInfo = orderInfoService.fingById(Long.valueOf(orderNo));
            // 联动支付会多次调用返回后台接口所以先判断是否支付成功
            if (!Constants.ORDERSTATUS_PAY.equals(orderInfo.getOrderStatus())) {
                String validateSign = MD5Util.string2MD5(channel + DateUtil.getCurrentDate());
                if (!transSign.equals(validateSign)) {
                    logger.debug("验证签名结果[失败].");
                } else {
                    logger.debug("验证签名结果[成功].");
                    orderInfoService.saveOrder(payStatus, orderInfo, new Date());

                }
            }
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 获取请求参数中所有的信息
     *
     * @param  request
     * @return
     */
    private Map<String, String> getAllRequestParam(HttpServletRequest request) {
        Map<String, String> res = new HashMap<String, String>();
        Enumeration<?> temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String) temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                // 在报文上送时，如果字段的值为空，则不上送<下面的处理为在获取所有参数数据时，判断若值为空，则删除这个字段>
                // System.out.println("ServletUtil类247行 temp数据的键=="+en+"
                // 值==="+value);
                if (null == res.get(en) || "".equals(res.get(en))) {
                    res.remove(en);
                }
            }
        }
        return res;
    }

    /**
     * <b>Function </b> 支付完成返回界面
     *
     * @param request
     * @param res
     * @return
     * @author LinQingLin
     * @date 2017年4月14日 下午6:40:47
     * @注意事项 </b> <b>
     */
    @RequestMapping("callFront")
    public ModelAndView callFront(HttpServletRequest request, HttpServletResponse res) {
        String web_host = configService.findByKey("web_host").getValue();
        // 本地调试请打开此配置，切勿修改开发数据库中配置的地址，将扰乱其它环境！
//		 web_host= "http://justme070.xicp.net/";
        return new ModelAndView("redirect:" + web_host + "/iframe/apply-login.jsp");
    }

    /**
     * 获取考试人员名单分页功能 <b>Function </b>
     *
     * @param searchDto
     * @return
     * @author LinQingLin
     * @date 2017年8月29日 下午2:00:07
     * @注意事项 </b> <b>
     */
    @RequestMapping("findUnScheduledPersonList")
    public @ResponseBody
    AjaxResult findUnScheduledPersonList(ExamSearchDto searchDto) {
        AjaxResult result = new AjaxResult();
        try {
            ExamSearchDto data = personcertificateService.findUnScheduledPersonList(searchDto);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 更新考试安排状态 <b>Function </b>
     *
     * @param examDetail
     * @return
     * @author LinQingLin
     * @date 2017年8月29日 下午4:22:40
     * @注意事项 </b> <b>
     */
    @RequestMapping("updateExamState")
    public @ResponseBody
    AjaxResult updateExamState(ExamDetailDto examDetail) {
        AjaxResult result = new AjaxResult();
        try {
            personcertificateService.updateExamState(examDetail);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 根据身份证返回制证状态
     *
     * @param personcertificate
     * @return
     */
    @RequestMapping("getCardState")
    public @ResponseBody
    AjaxResult getCardState(Personcertificate personcertificate) {
        AjaxResult result = new AjaxResult();
        try {

            Personcertificate dbpersoncertificate = personcertificateService.getCardState(personcertificate);
            if (dbpersoncertificate != null && dbpersoncertificate.getCardState() != null) {
                result.setData(dbpersoncertificate.getCardState());
                result.setSuccessful(true);
                result.setMsg("查询制证状态成功");
            } else {
                result.setMsg("查找不到制证信息");
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            result.setMsg("查询制证状态失败" + e.getMessage());
            result.setSuccessful(false);
            /*
             * logger.error(e.getMessage(), e); throw e;
             */
        }
        return result;
    }

    /**
     * 根据身份证号更新缴费状态
     *
     * @param cardnumber
     * @return
     */
    @RequestMapping("updatefeeState")
    public @ResponseBody
    AjaxResult updatefeeState(String cardnumber, String approvalreason, String ids) {
        AjaxResult result = new AjaxResult();
        try {
            //是否显示指纹录入环节
            Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
            // 旧 根据身份证号获取
            // Personcertificate personcertificate =
            // personcertificateService.getCardStateByCardnumber(cardnumber);

            // 新 根据ID获取 2018年7月31日10:17:01 wjb
            Personcertificate personcertificate = personcertificateService.getCardStateByIds(ids);

            // 缴费确认的前提是该人员一定要有指纹卡号，说明已录入采集过十指的指纹 或没有指纹录入环节。
            if (personcertificate != null && personcertificate.getFingercardState() != null
                    && ((personcertificate.getFingercardState().equals(Constants.FINGERCARD_STATE_JL)
                    || personcertificate.getFingercardState().equals(Constants.FINGERCARD_STATE_YCJ)) || (
                    null != isShowFingerprintConfig && StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_NO.equals(isShowFingerprintConfig.getValue())
            ))) {

                // 更新缴费状态为已缴费
                if (personcertificate.getFeeState() == null
                        || personcertificate.getFeeState().equals(Constants.FEE_STATE_WJF)) {

                    Approval approval = approvalService.findBybusinessidAndType(personcertificate.getId(),
                            BusinessType.BAYZ);

                    Config configVersion = configService.findByKey(Constants.APPROVAL_VERSION_SWITCH);
                    if (approval != null) {
                        if (configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())
                                && (approval.getGroupid() == null
                                || !Constants.APPROVAL_NUM_JF_GROUPID.equals(approval.getGroupid()))) {
                            result.setSuccessful(false);
                            result.setMsg("不在缴费确认环节！");
                            return result;
                        }
                    }

                    personcertificate.setFeeState(Constants.FEE_STATE_YJF);
                    personcertificate.setApprovalreason(approvalreason);
                    // 旧 根据身份证号更新缴费状态
                    // personcertificateService.updatefeeStateByCardnumber(personcertificate);

                    // 新 根据ID更新缴费状态 2018年7月31日10:16:47 wjb
                    personcertificateService.updatefeeStateById(personcertificate);
                    result.setSuccessful(true);
                    result.setMsg("缴费成功！");
                } else if (personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)) {
                    result.setSuccessful(false);
                    result.setMsg("已缴费，无须再次缴费");
                }

            } else {
                result.setMsg("缴费失败：该人员没有指纹卡号");
                result.setSuccessful(false);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据身份证号批量更新缴费状态
     *
     * @param cardnumberArr
     * @return
     */
    @RequestMapping("updatefeeStateByIdnumArr")
    public @ResponseBody
    AjaxResult updatefeeStateByIdnumArr(String[] cardnumberArr, Long[] ids) {
        AjaxResult result = new AjaxResult();
        //是否显示指纹录入环节
        Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
        try {
            PersoncertificateSearchDto dto = new PersoncertificateSearchDto();
            String failMsg = "", sucMsg = "", dupMsg = "";
            // 旧 根据身份证查找
            // dto.setCardnumberArrs(cardnumberArr);
            // List<Personcertificate> personcertificateList =
            // personcertificateService.findByNumberIdArr(dto);

            // 新 根据ID查找 2018年7月31日10:16:19 by wjb
            dto.setIdArrs(ids);
            List<Personcertificate> personcertificateList = personcertificateService.findByDtoIdArr(dto);

            for (Personcertificate personcertificate : personcertificateList) {
                // 缴费确认的前提是该人员一定要有指纹卡号，说明已录入采集过十指的指纹。
                if (personcertificate != null
                        && ((personcertificate.getFingercardState() != null && personcertificate.getFingercardState().equals(Constants.FINGERCARD_STATE_JL)
                        || personcertificate.getFingercardState() != null && personcertificate.getFingercardState().equals(Constants.FINGERCARD_STATE_YCJ)) || (
                        null != isShowFingerprintConfig && StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_NO.equals(isShowFingerprintConfig.getValue())
                ))) {

                    // 旧数据已采集，但未获取指纹
                    // if
                    // (Constants.FINGERCARD_STATE_YCJ.equals(personcertificate.getFingercardState()))
                    // {
                    // if (personcertificate.getUpdateTime().getTime() <
                    // DateUtil
                    // .convertStringToDate("2018-06-20 18:00:00").getTime()) {
                    // ApprovalDTO approvalDTO = new ApprovalDTO();
                    // approvalDTO.setBusinesstype(BusinessType.BAYZ);
                    // approvalDTO.setBusinessid(personcertificate.getId());
                    // List list =
                    // approvalService.getBusinessidAndType(approvalDTO);
                    // approvalDTO.setApprovalstate(ApprovalState.SHTG);
                    // approvalDTO.setApprovalreason(Constants.APPROVAL_CONTEXT_ZW);
                    // if (list != null && list.size() > 0) {
                    // Approval approval = (Approval) list.get(0);
                    // List<ApprovalLog> logList = approvalLogService
                    // .findByProcessInstanceId(approval.getProcessInstanceId());
                    // if (logList != null && list.size() == 2) {
                    // approvalService.saveApprovalForManual(approvalDTO,
                    // Constants.APPROVAL_CONTEXT_ZW);
                    // }
                    // }
                    // // throw new
                    // // ArsException("流程升级中，请于2018年6月21日下午再次操作");
                    // }
                    // }

                    Approval approval = approvalService.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                    //modify by zjh time:2018年9月6日 09:54:09 新旧审批的判断规则不一致：新审批需要走到考试安排才能做缴费确认，新审批不需要
                    // 读取配置文件
                    Config isNew = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
                    boolean oldApprovel;
                    if (isNew != null && !Constants.APPROVAL_VERSION_NEW.equals(isNew.getValue())) {
                        //旧审批
                        oldApprovel = true;
                    } else {
                        //新审批
                        //流程到考试安排后，才能做缴费确认
                        oldApprovel = approval != null && StringUtil.isNotEmpty(approval.getGroupid()) && approval.getGroupid().indexOf("999") >= 0;
                    }
                    //流程到考试安排后，才能做缴费确认
                    if (oldApprovel) {

                        // 更新缴费状态为已缴费
                        if (personcertificate.getFeeState() == null
                                || personcertificate.getFeeState().equals(Constants.FEE_STATE_WJF)) {

                            // Approval approval =
                            // approvalService.findBybusinessidAndType(personcertificate.getId(),
                            // BusinessType.BAYZ);
                            //
                            // Config configVersion =
                            // configService.findByKey(Constants.APPROVAL_VERSION_SWITCH);
                            // if (approval != null) {
                            // if (configVersion != null &&
                            // Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())
                            // && (approval.getGroupid() == null
                            // ||
                            // !approval.getGroupid().equals(Constants.APPROVAL_NUM_JF_GROUPID)))
                            // {
                            // failMsg += personcertificate.getName() + ",";
                            // } else {
                            personcertificate.setFeeState(Constants.FEE_STATE_YJF);
                            // 列表的无需填写理由
                            personcertificate.setApprovalreason("");
                            // 旧 根据身份证更新状态 2018年7月31日14:08:02
                            // personcertificateService.updatefeeStateByCardnumber(personcertificate);
                            // 新 根据id更新状态
                            personcertificateService.updatefeeStateById(personcertificate);
                            sucMsg += personcertificate.getName() + ",";
                            // }
                            // } else {
                            // failMsg += personcertificate.getName() + ",";
                            // }
                        } else if (personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)) {
                            dupMsg += personcertificate.getName() + ",";
                        }
                    } else {
                        failMsg += personcertificate.getName() + ",";
                    }
                } else {
                    failMsg += personcertificate.getName() + ",";
                }
            }

            String msg = "";
            if (!"".equals(sucMsg)) {
                msg += sucMsg + "缴费成功！";
            }
            if (!"".equals(failMsg)) {
                msg += failMsg + "缴费失败，不在缴费确认环节！";
            }
            if (!dupMsg.equals("")) {
                msg += dupMsg + "已缴费，无须再次缴费";
            }
            result.setMsg(msg);

            if ("".equals(sucMsg)) {
                result.setSuccessful(false);
            } else {
                result.setSuccessful(true);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("deleteByIdnumArr")
    public @ResponseBody
    AjaxResult deleteByIdnumArr(String[] cardnumberArr, Long[] ids) {
        AjaxResult result = new AjaxResult();
        try {
            PersoncertificateSearchDto dto = new PersoncertificateSearchDto();
            dto.setIdArrs(ids);
            List<Personcertificate> personcertificateList = personcertificateService.findByDtoIdArr(dto);
            if(null!=personcertificateList && personcertificateList.size()>0){
                for (Personcertificate personcertificate : personcertificateList) {
                    personcertificateService.delete(personcertificate);
                    approvalService.deleteByBusinessId(personcertificate.getId(),BusinessType.BAYZ);
                    result.setSuccessful(true);
                }
            }else{
                result.setSuccessful(false);
                result.setMsg("没有需要删除的数据！");
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据身份证号取消缴费状态
     *
     * @param cardnumber
     * @return
     */
    @RequestMapping("cancelfeeState")
    @Deprecated
    public @ResponseBody
    AjaxResult cancelfeeState(String cardnumber, String ids) {
        AjaxResult result = new AjaxResult();
        try {

            // 旧 根据身份证获取 2018年7月31日14:08:16
            // Personcertificate personcertificate =
            // personcertificateService.getCardStateByCardnumber(cardnumber);

            // 新 根据ID获取
            Personcertificate personcertificate = personcertificateService.getCardStateByIds(ids);
            // 已缴费的更新为未缴费的
            if (personcertificate != null && personcertificate.getFeeState() != null
                    && personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)) {
                // 下一级审批已进行不能取消缴费！
                // if(personcertificate.getPayConfirm()!=null &&
                // personcertificate.getPayConfirm().equals(Constants.FEE_STATE_YJF))
                // {
                // result.setMsg(personcertificate.getName()+"取消缴费失败：下一级审批已进行不能取消缴费！");
                // result.setSuccessful(false);
                // }else {
                // 更新缴费状态为未缴费
                if (personcertificate.getExamState() != null
                        && personcertificate.getExamState().equals(Constants.EXAM_STATE_YAP)) {
                    result.setMsg(personcertificate.getName() + "取消缴费失败：已安排考试的人员不得取消缴费！");
                    result.setSuccessful(false);
                } else if (personcertificate.isExport()) {
                    result.setMsg(personcertificate.getName() + "因为已确认缴费，并有可能已安排考试，不能取消缴费！");
                } else {
                    personcertificate.setFeeState(Constants.FEE_STATE_WJF);

                    // 旧 根据身份证更新状态 2018年7月31日14:08:21
                    // personcertificateService.updatefeeStateByCardnumber(personcertificate);
                    // 新 根据ID更新状态
                    personcertificateService.updatefeeStateById(personcertificate);
                    result.setSuccessful(true);
                    result.setMsg(personcertificate.getName() + "取消缴费成功");
                }
                // }

            } else {
                result.setMsg(personcertificate.getName() + "取消缴费失败：未缴费状态无须取消");
                result.setSuccessful(false);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据身份证号批量取消缴费状态
     *
     * @param cardnumberArr
     * @return
     */
    @RequestMapping("cancelfeeStateByIdnumArr")
    public @ResponseBody
    AjaxResult cancelfeeStateByIdnumArr(String[] cardnumberArr, Long[] ids) {
        AjaxResult result = new AjaxResult();
        try {

            PersoncertificateSearchDto dto = new PersoncertificateSearchDto();

            // 旧 根据身份证查找
            // dto.setCardnumberArrs(cardnumberArr);
            // List<Personcertificate> personcertificateList =
            // personcertificateService.findByNumberIdArr(dto);

            // 新 根据ID查找 2018年7月31日10:16:19 by wjb
            dto.setIdArrs(ids);
            List<Personcertificate> personcertificateList = personcertificateService.findByDtoIdArr(dto);

            String failMsg = "", sucMsg = "", dupMsg = "", nextMsg = "", exportMsg = "";
            for (Personcertificate personcertificate : personcertificateList) {

                // 已缴费的更新为未缴费的
                if (personcertificate != null && personcertificate.getFeeState() != null
                        && personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)) {
                    // 下一级审批已进行不能取消缴费！
                    if (personcertificate.getPayConfirm() != null
                            && personcertificate.getPayConfirm().equals(Constants.FEE_STATE_YJF)) {
                        nextMsg += personcertificate.getName() + ",";
                        // result.setMsg("取消缴费失败：下一级审批已进行不能取消缴费！");
                        // result.setSuccessful(false);
                    } else {
                        // 更新缴费状态为未缴费
                        if (personcertificate.getExamState() != null
                                && personcertificate.getExamState().equals(Constants.EXAM_STATE_YAP)) {
                            dupMsg += personcertificate.getName() + ",";
                            // result.setMsg("取消缴费失败：已安排考试的人员不得取消缴费");
                            // result.setSuccessful(false);
                        } else if (personcertificate.isExport()) {
                            exportMsg += personcertificate.getName() + ",";
                        } else {
                            personcertificate.setFeeState(Constants.FEE_STATE_WJF);
                            // 旧 根据身份证更新状态 2018年7月31日14:08:32
                            // personcertificateService.updatefeeStateByCardnumber(personcertificate);
                            // 新 根据ID更新状态
                            personcertificateService.updatefeeStateById(personcertificate);
                            sucMsg += personcertificate.getName() + ",";
                            // result.setSuccessful(true);
                            // result.setMsg("取消缴费成功");
                        }
                    }

                } else {
                    failMsg += personcertificate.getName() + ",";
                    // result.setMsg("取消缴费失败：未缴费状态无须取消");
                    // result.setSuccessful(false);
                }
            }

            String msg = "";
            if (!sucMsg.equals("")) {
                msg += sucMsg + "取消缴费成功";
            }
            if (!nextMsg.equals("")) {
                msg += nextMsg + "取消缴费失败：下一级审批已进行不能取消缴费！";
            }
            if (!dupMsg.equals("")) {
                msg += dupMsg + "取消缴费失败：已安排考试的人员不得取消缴费！";
            }
            if (!exportMsg.equals("")) {
                msg += exportMsg + "因为已确认缴费，并有可能已安排考试，不能取消缴费!";
            }
            if (!failMsg.equals("")) {
                msg += failMsg + "取消缴费失败：未缴费状态无须取消";
            }

            if (sucMsg.equals("")) {
                result.setSuccessful(false);
            } else {
                result.setSuccessful(true);
            }

            result.setMsg(msg);

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 点击录入指纹，状态变为已采集
     *
     * @param personcertificate
     * @return
     */
    @RequestMapping("updatefingercardStateYCJ")
    public @ResponseBody
    AjaxResult updatefingercardStateYCJ(Personcertificate personcertificate) {
        AjaxResult result = new AjaxResult();
        try {

            Personcertificate dbpersoncertificate = personcertificateService.findById(personcertificate.getId());
            if (dbpersoncertificate != null) {
                dbpersoncertificate.setFingercardState(Constants.FINGERCARD_STATE_YCJ);
                dbpersoncertificate.setUpdateTime(new Date());
                dbpersoncertificate.setFingerprint(personcertificate.getFingerprint());
                dbpersoncertificate.setUpdateflag(true);
                personcertificateService.updatefingercardState(dbpersoncertificate);
                result.setSuccessful(true);
                result.setMsg("采集成功");
            } else {
                result.setMsg("查找不到信息");
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据身份证号更新指纹卡号状态
     *
     * @param id
     * @return
     */
    @RequestMapping("updatefingercardState")
    public @ResponseBody
    AjaxResult updatefingercardState(Long id, String fingerprint, String approvalreason) {
        AjaxResult result = new AjaxResult();
        try {

            Personcertificate personcertificate = personcertificateService.findById(id);

            // 获取指纹卡号的前提条件是该员已经第一次报名审核通过。
            if (personcertificate != null && personcertificate.getApprovalstate() != null
                    && (personcertificate.getApprovalstate().equals(Constants.APPROVALSTATE_TG)
                    || personcertificate.getApprovalstate().equals(Constants.APPROVALSTATE_SHZ))) {
                // 更新指纹记录状态为记录
                if (personcertificate.getFingercardState() == null
                        || personcertificate.getFingercardState().equals(Constants.FINGERCARD_STATE_WJL)) {

                    Approval approval = approvalService.findBybusinessidAndType(personcertificate.getId(),
                            BusinessType.BAYZ);

                    if (approval != null) {
                        //
                        Config configVersion = configService.findByKey(Constants.APPROVAL_VERSION_SWITCH);
                        // 2018年6月5日16:54:24 新旧审批区分 新审批增加环节的判断

                        if (configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())
                                && (approval.getGroupid() == null
                                || !Constants.APPROVAL_NUM_ZW_GROUPID.equals(approval.getGroupid()))) {
                            result.setSuccessful(false);
                            result.setMsg("不在获取指纹环节！");
                            return result;
                        }
                    }

                    personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                    personcertificate.setFingerprint(fingerprint);
                    // 已采集
                    // personcertificate.setFingercardState(Constants.FINGERCARD_STATE_YCJ);
                    personcertificate.setApprovalreason(approvalreason);
                    // 旧 根据身份证更新状态
                    // personcertificateService.updatefingercardStateByCardnumber(personcertificate);
                    // 新 2018年7月31日09:31:48 根据ID更新状态
                    personcertificateService.updatefingercardStateById(personcertificate);
                    result.setSuccessful(true);
                    result.setMsg("成功获取1个指纹卡，0个失败<br>请告知指纹录入成功人员进行考试缴费哦");
                } else if (personcertificate.getFingercardState().equals(Constants.FINGERCARD_STATE_JL)) {
                    result.setSuccessful(false);
                    result.setMsg("指纹已录入，无须重复录入");
                }
            } else {
                result.setMsg("指纹录入失败：该人员未进行第一级审批，第一级审批完再获取指纹！！");
                result.setSuccessful(false);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            result.setMsg("指纹录入失败！");
            result.setSuccessful(false);
        }
        return result;
    }

    @Autowired
    private ConfigUtils configUtils;

    /**
     * 根据身份证号批量更新指纹卡号状态
     *
     * @param ids
     * @return
     */
    @RequestMapping("updatefingercardStateByIdnumArr")
    public @ResponseBody
    AjaxResult updatefingercardStateByIdnumArr( String[] ids) {
        AjaxResult result = new AjaxResult();
        try {
            //是否需要指纹
            Config fingerConfig =  configService.findByKey(Constants.IS_SHOW_FINGERPRINT);
            if (Constants.IDENTITYAUTHSTATE_Y.equals(fingerConfig.getValue())) {

            }else{
                result.setMsg("本环境配置不需要获取指纹");
                result.setSuccessful(false);
                return result;
            }

            // 初始化信息
            String failMsg = "", sucMsg = "", dupMsg = "", noMsg = "";
            // 从循环中取出来，这样减少性能消耗
            Personcertificate personcertificate;

            Approval approval;
            for(String id : ids){
                personcertificate = personcertificateService.getCardStateByIds(id);
                Boolean flag = null;
                flag = personcertificate != null && personcertificate.getApprovalstate() != null &&
                        ( Constants.APPROVALSTATE_DSP.equals(personcertificate.getApprovalstate()) || Constants.APPROVALSTATE_SHZ.equals(personcertificate.getApprovalstate())) ;
                if (flag) {
                    // 更新指纹记录状态为记录
                    // modify zjh time：2018年8月20日 14:17:19
                    // 不等于已录入和已采集
                    if ( !Constants.FINGERCARD_STATE_JL.equals(personcertificate.getFingercardState())
                            && !Constants.FINGERCARD_STATE_YCJ.equals(personcertificate.getFingercardState())) {
                        Pctinfo pctinfo = pctinfoService.findByIdnumber(personcertificate.getCardnumber());
                        if (pctinfo != null) {
                            //获取到指纹 开启 activiti流程
                            personcertificate.setFingerprint(pctinfo.getBarcode());
                            personcertificate.setApprovalreason("");
                            personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                            // 旧 根据身份证更新状态
                            // personcertificateService.updatefingercardStateByCardnumber(personcertificate);
                            // 新 2018年7月31日09:31:48 根据ID更新状态
                            personcertificateService.updatefingercardStateById(personcertificate);
                            sucMsg += personcertificate.getName() + ",";
                        }else{
                            //没有指纹
                            noMsg+= personcertificate.getName() + ",";
                        }
                        // 已录入的
                    } else if (Constants.FINGERCARD_STATE_JL.equals(personcertificate.getFingercardState())) {
                        dupMsg += personcertificate.getName() + ",";
                    }
                } else {
                    failMsg += personcertificate.getName() + ",";
                }
            }


            String msg = "";
            if (!"".equals(sucMsg)) {
                msg += sucMsg + "成功获取指纹卡号，请告知指纹录入成功人员进行考试缴费哦！";
            }
            if (!"".equals(dupMsg)) {
                msg += dupMsg + "指纹已录入，无须重复录入！";
            }
            if (!"".equals(failMsg)) {
                msg += failMsg + "不在获取指纹环节！";
            }
            if (!"".equals(noMsg)) {
                msg += noMsg + "没有指纹！";
            }
            if ("".equals(sucMsg)) {
                result.setSuccessful(false);
                msg += "指纹录入失败";
            } else {
                result.setSuccessful(true);
            }

            result.setMsg(msg);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据身份证号更新提交制证状态
     *
     * @param cardnumber
     * @return
     */
    @RequestMapping("updatecardState")
    public @ResponseBody
    AjaxResult updatecardState(String cardnumber, String ids) {
        AjaxResult result = new AjaxResult();
        //是否显示指纹录入环节
        Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
        try {
            // 旧 根据身份证号查询 2018年7月31日14:08:53
            // Personcertificate personcertificate =
            // personcertificateService.getCardStateByCardnumber(cardnumber);
            // 新 根据Id查询
            Personcertificate personcertificate = personcertificateService.getCardStateByIds(ids);
            // 在制证之前的保安员状态是：报名状态通过、有指纹卡号、已缴费、考试合格人员才可以。
            if (personcertificate != null && personcertificate.getTestState() != null
                    && personcertificate.getTestState().equals(Constants.TEST_STATE_TG) && // 考试状态
                    personcertificate.getFeeState() != null
                    && personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF) && // 缴费状态
                    personcertificate.getFingercardState() != null
                    && (personcertificate.getFingercardState().equals(Constants.FINGERCARD_STATE_JL) || (null != isShowFingerprintConfig && StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_NO.equals(isShowFingerprintConfig.getValue()))) && // 指纹录入状态
                    personcertificate.getApprovalstate() != null
                    && personcertificate.getApprovalstate().equals(Constants.APPROVALSTATE_TG)) {// 审核状态
                // 更新制证状态为已制证
                if (personcertificate.getCardState() == null
                        || personcertificate.getCardState().equals(Constants.CARD_STATE_WZZ)) {
                    personcertificate.setCardState(Constants.CARD_STATE_YZZ);
                    // 旧 根据身份证号更新制证状态 2018年7月31日14:08:58
                    // 新 根据id更新制证状态
                    personcertificateService.updatecardStateByIds(personcertificate);
                    result.setMsg("提交制证成功");
                    result.setSuccessful(true);
                } else if (personcertificate.getCardState().equals(Constants.CARD_STATE_YZZ)) {
                    result.setMsg("已制证，无须重复制证");
                    result.setSuccessful(false);
                }
            } else {
                result.setMsg("提交制证失败：报名状态通过、有指纹卡号、已缴费、考试合格人员才可以");
                result.setSuccessful(false);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**************************************************
     ************* 与培训平台对接接口 结束 *********************
     **************************************************/

    @RequestMapping("dataStatisticsReport")
    public @ResponseBody
    AjaxResult dataStatisticsReport(ReportDataSearchDto searchDto) {
        AjaxResult result = new AjaxResult();
        try {
            PersonCertificateReportData data = personcertificateService.dataStatisticsReport(searchDto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出保安员证报名列表（仅适用与内网数据导入到外网）
     */
    @RequestMapping("exportDataPrint")
    public @ResponseBody
    AjaxResult createCompanysExcel(PersoncertificateSearchDto dto, HttpServletRequest request) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setPaging(false);
                PersoncertificateSearchDto data = personcertificateService.searchExport(dto);
                if (data.getData() != null) {
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(downloadFolder + dirDate);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_保安员列表.xls");
                    File file = new File(templateName);
                    personcertificateService.exportSecurityCertificate(data.getData(), file);
                    result.setData(templateName);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出
     *
     * @param templateName
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportSecurityCertificate")
    public void exportPersons(String templateName, HttpServletResponse response) throws Exception {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            File file = new File(templateName);
            if (file != null) {
                ServletOutputStream out = response.getOutputStream();
                String fileName = new String(
                        file.getName().substring(file.getName().indexOf("_") + 1).getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                InputStream is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
    }

    @RequestMapping("queryTable")
    public @ResponseBody
    PageResult queryTable(PersoncertificateSearchDto searchDto, HttpServletResponse response) {
        try {
            return personcertificateService.queryTable(searchDto);// 进行查询，并转换
        } catch (Exception e) {
            throw e;
        }
    }

    @RequestMapping("getPersonXML")
    public @ResponseBody
    AjaxResult getPersonXML(Long id) {
        AjaxResult result = new AjaxResult();
        try {

            User currentUser = arsUtil.getCurrentUser();
            Personcertificate person = personcertificateService.findById(id);
            if (person != null) {
                FingerPrint fingerPrint = new FingerPrint();
                if (StringUtil.isNotEmpty(person.getBrith())) {
                    fingerPrint.setBirthday(person.getBrith().replaceAll("-", ""));
                }

                fingerPrint.setDwellAddress(person.getNowAddress());// 现住地地址
                fingerPrint.setIdentityCardNum(person.getCardnumber());// 身份证号
                fingerPrint.setDwellAdminDivCode(person.getCardnumber().substring(0, 6));// 现住地行政区划代码（6位）
                fingerPrint.setDwellAdminDivName(
                        sysareaService.findByCodeForFullName(person.getCardnumber().substring(0, 6)));// 现住地行政区划

                if (StringUtil.isNotEmpty(person.getNation())) {
                    if (person.getNation().length() < 2) {
                        fingerPrint.setNationCode("0" + person.getNation());// 民族
                    } else {
                        fingerPrint.setNationCode("01");// 民族代码
                    }
                    Nation nation = nationService.findByCode(fingerPrint.getNationCode());
                    if (nation != null) {
                        fingerPrint.setNationName(nation.getName());// 民族代码
                    } else {
                        fingerPrint.setNationName("汉族");// 民族代码
                    }
                } else {
                    fingerPrint.setNationCode("01");// 民族代码
                    fingerPrint.setNationName("汉族");// 民族代码
                }
                fingerPrint.setPersonAlias(person.getBeforeName());// 别名（曾用名？）
                fingerPrint.setPersonName(person.getName());// 人员姓名（30位）
                fingerPrint.setRegAddress(person.getAddress());// 户籍地详址
                fingerPrint.setScanDate(DateUtil.getCurrentDate(DateUtil.FORMAT11));// 采集日期（yyyyMMdd）
                if (StringUtil.isNotEmpty(person.getSex())) {
                    fingerPrint.setSexCode(person.getSex());// 性别代码
                    if ("1".equals(person.getSex())) {
                        fingerPrint.setSexName("男");// 性别
                    } else if ("2".equals(person.getSex())) {
                        fingerPrint.setSexName("女");// 性别
                    }
                }
                fingerPrint.setScanPersonName(currentUser.getRealname());// 采集民警姓名
                if (currentUser.getPolice() != null) {
                    fingerPrint.setScanUnitCode(currentUser.getPolice().getCode());// 采集单位代码
                    fingerPrint.setScanUnitName(currentUser.getPolice().getOrgname());// 采集单位名称
                }
                // fingerPrint.setCard_N("BA"+DateUtil.getCurrentDate(DateUtil.FORMAT8));//指纹编号（16位）
                // fingerPrint.setPersonID("BA"+person.getCardnumber()+(StringUtil.getFixLenthString(21-person.getCardnumber().length())));//人员编号（23位）

                // 身份证号+所属区域（23位）BA+身份证号+3位
                fingerPrint.setPersonID("BA" + person.getCardnumber() + person.getCardnumber()
                        .substring(person.getCardnumber().length() - 3, person.getCardnumber().length()));// 人员编号

                // 指纹编号（16位）规则：BA +单位代码到区县（6位）+年月（4位：例如1804）+ID 临时方案
                // fingerPrint.setCard_N("BA"+person.getDistrict()+createCard_N(person.getCreateTime())+person.getId().toString());//指纹编号
                // 获取流水号值
                Config config = configDao.findByKey("serialNumber");
                String configDate = "cgnull";
                if (config != null && StringUtil.isNotEmpty(config.getValue())) {
                    configDate = config.getValue();
                    String subDate = configDate.substring(0, 4);
                    String dat = DateUtil.getCurrentDate("yyMM");
                    if (subDate.compareTo(dat) < 0) {
                        configDate = dat + "0001";
                    } else {
                        configDate = String.valueOf(Integer.valueOf(configDate) + 1);
                    }
                    config.setValue(configDate);
                    configDao.update(config);
                }
                // 指纹编号（16位）规则：BA
                // +单位代码到区县（6位）+年月（4位：例如1804）+流水号，流水号规则：根据createTime年月，每个月从0001开始
                // TODO
                fingerPrint.setCard_N("BA" + person.getDistrict() + configDate);// 指纹编号
                // TODO 指纹编号暂时与人员编号一样
                fingerPrint.setRegAdminDivCode(person.getDistrict());// 户籍地行政区划代码
                fingerPrint.setRegAdminDivName(sysareaService.findByCodeForFullName(person.getDistrict()));// 户籍地行政区划

                // TODO 字段缺失写固定值
                fingerPrint.setCertifyNum("");// 其它证件号码
                fingerPrint.setCertifyTypeCode("");// 其它证件类别代码（2位）
                fingerPrint.setCertifyTypeName("");// 其它证件类别
                fingerPrint.setCrimeRecordFlag("");// 前科标识代码0：不属于前科库人员，1：属于前科库人员
                fingerPrint.setCrimeRecordFlagName("");// 前科标识（256位）
                fingerPrint.setRemark("");// 备注
                // TODO 国籍编码缺失
                fingerPrint.setCountryCode("156");
                fingerPrint.setCountryName("中国");// 国籍
                /*
                 * fingerPrint.setCaseType1Code(caseType1Code);//案件类别代码1（6位）
                 * fingerPrint.setCaseType1Name(caseType1Name);//案件类别
                 * fingerPrint.setCaseType2Code(caseType2Code);
                 * fingerPrint.setCaseType2Name(caseType2Name);
                 * fingerPrint.setCaseType3Code(caseType3Code);
                 * fingerPrint.setCaseType3Name(caseType3Name);
                 */

                result.setData(fingerPrint);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("人员信息错误");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 生成指纹编号
     *
     * @param date
     * @return
     */
    public String createCard_N(Date date) {

        //
        Calendar ca = Calendar.getInstance();

        ca.setTime(date);

        String yearmonth = "";
        int month = ca.get(Calendar.MONTH) + 1;// 第几个月

        int year = ca.get(Calendar.YEAR);// 年份数值

        yearmonth = yearmonth + year;

        yearmonth = yearmonth.substring(2);

        if (month < 10) {
            yearmonth += "0" + month;
        } else {
            yearmonth = yearmonth + month;
        }

        return yearmonth;
    }

    /***
     * 部级接口
     *
     * @return
     */
    @RequestMapping("bjRest")
    public @ResponseBody
    AjaxResult bjRest() {
        AjaxResult result = new AjaxResult();
        try {
            syncDepartService.bjRest();
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @Autowired
    private ClientUtil clientUtil;

    /***
     * 人口库指纹
     *
     * @return
     */
    @RequestMapping("rkkzw")
    public @ResponseBody
    AjaxResult rkkzw() {
        AjaxResult result = new AjaxResult();
        try {
            Personcertificate personcertificate = new Personcertificate();
            personcertificate.setCardnumber("450103199106010514");
            personcertificate.setPoliceCode("450000030000");
            personcertificate.setPoliceName("广西公安厅治安警察总队");
            String fingerprint = clientUtil.queryZWForIdNumber(personcertificate);
            result.setData(fingerprint);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage());
            result.setData(e.getMessage());
            throw e;
        }
        return result;
    }
    /***
     * 背景筛查
     *
     * @return
     */
    @RequestMapping("bjsc")
    public @ResponseBody
    AjaxResult bjsc() {
        AjaxResult result = new AjaxResult();
        try {
            syncDepartService.bjsc();
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("tglc")
    public @ResponseBody
    AjaxResult tglc() {
        AjaxResult result = new AjaxResult();
        try {
            Config config = configDao.findByKey("approvalflag");

            if (config != null && config.getValue().equals("0")) {
                config.setValue("1");
                configDao.update(config);

                new Thread(() -> {
                    Long[] ids = {4834L};

                    for (int j = 0; j < ids.length; j++) {
                        Personcertificate personcertificate = personcertificateService.findById(ids[j]);
                        for (int i = 0; i < 1; i++) {
                            ApprovalDTO approvalDTO = new ApprovalDTO();
                            approvalDTO.setBusinesstype(BusinessType.BAYZ);
                            approvalDTO.setBusinessid(personcertificate.getId());
                            approvalDTO.setApprovalstate(ApprovalState.SHTG);
                            approvalDTO.setApprovalreason("系统审批");
                            try {
                                approvalService.saveApprovalForManual(approvalDTO, "系统审批");
                                Thread.sleep(2000);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    // Long[] rws = {3632L};

                    /*
                     * for (int j = 0; j < rws.length; j++) {
                     *
                     * Personcertificate personcertificate =
                     * personcertificateService.findById(rws[j]); for (int i =
                     * 0; i < 4; i++) { ApprovalDTO approvalDTO = new
                     * ApprovalDTO();
                     * approvalDTO.setBusinesstype(BusinessType.BAYZ);
                     * approvalDTO.setBusinessid(personcertificate.getId());
                     * approvalDTO.setApprovalstate(ApprovalState.SHTG);
                     * approvalDTO.setApprovalreason("系统审批"); try {
                     * approvalService.saveApprovalForManual(approvalDTO,
                     * "系统审批"); Thread.sleep(2000); } catch (Exception e) {
                     * e.printStackTrace(); } } }
                     */

                    /*
                     * Long[] dspids = {};
                     *
                     * for (int j = 0; j < dspids.length; j++) {
                     *
                     * Personcertificate personcertificate =
                     * personcertificateService.findById(dspids[j]); for (int i
                     * = 0; i < 3; i++) { ApprovalDTO approvalDTO = new
                     * ApprovalDTO();
                     * approvalDTO.setBusinesstype(BusinessType.BAYZ);
                     * approvalDTO.setBusinessid(personcertificate.getId());
                     * approvalDTO.setApprovalstate(ApprovalState.SHTG);
                     * approvalDTO.setApprovalreason("系统审批"); try {
                     * approvalService.saveApprovalForManual(approvalDTO,
                     * "系统审批"); Thread.sleep(2000); } catch (Exception e) {
                     * e.printStackTrace(); } } }
                     */
                }).start();
            }

            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取缴费人员列表
     *
     * @return
     */
    @RequestMapping("getPersonPayTree")
    public @ResponseBody
    AjaxResult getPersonPayTree() {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(personcertificateService.getPersonPayTree());
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 内网导出 批量导出保安员证报名列表 + 保安员资格证书
     */
    @RequestMapping("/exportDataNew")
    @Deprecated
    public @ResponseBody
    AjaxResult exportDataNew(HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                String personcertificatePath = this.createPersoncertificatePath(request, response);
                String securityCertificatePath = this.createSecurityCertificatePath(request, response);
                // 考试安排相关数据
                String trainExamPath = this.createTrainExamPath(request, response);

                List<String> filePaths = new ArrayList<String>();
                // 添加到zip文件中
                if (StringUtil.isNotEmpty(personcertificatePath)) {
                    filePaths.add(personcertificatePath);
                }
                if (StringUtil.isNotEmpty(securityCertificatePath)) {
                    filePaths.add(securityCertificatePath);
                }
                if (StringUtil.isNotEmpty(trainExamPath)) {
                    filePaths.add(trainExamPath);
                }
                String zipPath = FileUtil.zipFiles(filePaths,
                        tempfolder + FileUtil.generatingFileNameByDate("personCertificate") + ".zip");
                result.setData(zipPath);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 下载证书
     *
     * @param response
     * @throws Exception
     */
    @RequestMapping("download")
    public void exportApprovals(String templateName, HttpServletResponse response) throws Exception {
        File file = new File(templateName);
        if (file != null) {
            ServletOutputStream out = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
            InputStream is = new FileInputStream(file);
            try {
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
                file.delete();
            } catch (Exception e) {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
                file.delete();
            }
        }
    }

    /**
     * 生成保安员证报名列表路径
     *
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @Deprecated
    private String createPersoncertificatePath(HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        try {
            DataSycDto dataSycDto = new DataSycDto();
            dataSycDto.setDataType(Constants.DATASYC_PERSONCERTIFICATE_LIST);
            List<Personcertificate> personlist = personcertificateService.findAll();

            for (Personcertificate personcertificate : personlist) {
                if (personcertificate.getFeeState() != null
                        && personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)) {
                    // 已导出的缴费，不能再更改
                    personcertificate.setExport(true);
                    personcertificateService.updateExport(personcertificate);
                }
            }
            dataSycDto.setData(JSONObject.toJSONString(personlist));
            Date now = new Date();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String listStr = JSONObject.toJSONString(dataSycDto);
            String content = CipherDESUtil
                    .parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));

            String filepath = FileUtil.writeTxtFile(content, "personcertificate", tempfolder);
            return filepath;
        } catch (BadPaddingException badPaddingException) {
            logger.error(badPaddingException.getMessage(), badPaddingException);
            throw new ArsException("导入失败，非该区域数据\n！");
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 生成保安员证证书路径
     *
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @Deprecated
    private String createSecurityCertificatePath(HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        try {
            DataSycDto dataSycDto = new DataSycDto();
            DSSecurityCertificateDto cerDto = new DSSecurityCertificateDto();
            dataSycDto.setDataType(Constants.DATASYC_SECURITY_CERT_LIST);
            List<String> filePaths = new ArrayList<String>();
            List<SecurityCertificate> cerList = securityCertificateService.searchUpdateflagForExport();
            cerDto.setCerList(cerList);

            dataSycDto.setData(JSONObject.toJSONString(cerDto));
            Date now = new Date();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String listStr = JSONObject.toJSONString(dataSycDto);
            String content = CipherDESUtil
                    .parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));

            String filepath = FileUtil.writeTxtFile(content, "securityCer", tempfolder);
            return filepath;
        } catch (BadPaddingException badPaddingException) {
            logger.error(badPaddingException.getMessage(), badPaddingException);
            throw new ArsException("导入失败，非该区域数据\n！");
        } catch (Exception e) {
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader("D:\\securityCer_20180827180000.data"));
        StringBuffer content = new StringBuffer();
        // 获取文件内容
        String lineTxt = null;
        while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
            content.append(lineTxt);
        }
        br.close();
        String jsonStr = new String(
                CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));

        DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);

        if (dataSycDto != null) {
            if (dataSycDto.getDataType().equals(Constants.DATASYC_SECURITY_CERT_LIST)) {
                DSSecurityCertificateDto certDto = JSONObject.parseObject(dataSycDto.getData(),
                        DSSecurityCertificateDto.class);

                List<SecurityCertificate> certList = certDto.getCerList();
                int i = 0;
                for (SecurityCertificate cert : certList) {
                    if (cert.isIsprint() && cert.getFzjgmc().equals("广西贵港市公安局")) {
                        //System.out.println(cert.getId()+",");

                        System.out.println("姓名:" + cert.getXm() + ",身份证号：" + cert.getIdnum() + ",打印打开次数：" + cert.getPrintcount() + ",打印时间：" + DateUtil.convertDateToString(cert.getPrintTime(), DateUtil.FORMAT1));
                        i++;
                    }

                    //securityCertificateService.outerSaveOrUpdateForDS(cert);
                }
                System.out.println(i);
            }
        }
    }

    /**
     * 批量导入历史保安员证 by llc 2018-08-09
     */
    @RequestMapping("importCertificateData")
    @RequiresPermissions("personcertificatePrint:import")
    public @ResponseBody
    AjaxResult importCertificateData(MultipartFile file, HttpServletRequest request)
            throws Exception {
        AjaxResult result = new AjaxResult();
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!fileType.toUpperCase().equalsIgnoreCase("XLS") && !fileType.toUpperCase().equalsIgnoreCase("XLSX")) {
            result.setMsg("导入的模板文件有误");
            result.setSuccessful(false);
            return result;
        }
        long startTime = System.currentTimeMillis();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "." + fileType;
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = tempfolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行人员文件上传..." + targetFile);
            file.transferTo(targetFile);
            Map<String, Object> resultMap = new HashMap<String, Object>();
            User loginUser = arsUtil.getCurrentUser();
            List<Map<String, String>> list = new ArrayList<Map<String, String>>(); // 数据库校验的list
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>(); // 定义失败的list
            //是否显示指纹录入环节
            Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
            if (loginUser != null) {

                FileInputStream inStream = new FileInputStream(targetFile);
                Workbook workBook = WorkbookFactory.create(inStream);
                Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
                boolean flag = true;
                int i = 5; // 设置初始行为第6行
                while (flag) {
                    Row row = sheet.getRow(i);
                    if (row != null) {
                        Map<String, String> data = new HashMap<String, String>();
                        try {

                            /*** 客户的数据格式及其复杂
                             *
                             * 1.英文的空格  2.中文的空格  3.非美式英文的半角空格  4.一个tab键  5 .2个tab键
                             * 不过tab键在java可以按英文空格处理，如果在数据库判断长度就非常长了
                             * 现有校验按 1-2-3
                             */
                            String errorMsg = ""; // 校验错误信息
                            /**** 身份证 ****/
                            String idNum = ExcelUtil.getCellValue(row.getCell(0));
                            idNum = idNum.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("idNum", idNum);

                            /**** 姓名 ****/
                            String xm = ExcelUtil.getCellValue(row.getCell(1));
                            xm = xm.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("xm", xm);

                            /**** 单位名称 ****/
                            String companyName = ExcelUtil.getCellValue(row.getCell(2));
                            companyName = companyName.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("companyName", companyName);

                            /**** 证书编号 ****/
                            String zsbh = ExcelUtil.getCellValue(row.getCell(3));
                            if (StringUtil.isNotEmpty(zsbh)) {
                                zsbh = zsbh.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            } else {
                                zsbh = null;
                            }


                            /**** 发证日期 ****/
                            String fzrq = ExcelUtil.getCellValue(row.getCell(4));
                            if (StringUtil.isNotEmpty(fzrq)) {
                                fzrq = fzrq.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            } else {
                                fzrq = null;
                            }
                            data.put("fzrq", fzrq);


                            /**** 打印状态 ****/
                            String dyzt = ExcelUtil.getCellValue(row.getCell(5));
                            if (StringUtil.isNotEmpty(dyzt)) {
                                dyzt = dyzt.trim();
                            }
                            data.put("dyzt", dyzt);

                            /***** 校验excel字段 ****/

                            /*** 身份证号码 ****/
                            if (StringUtil.isEmpty(idNum)) {
                                errorMsg = errorMsg + "身份证号码不能为空";
                            } else {
                                IdcardValidator idcardValidator = new IdcardValidator();
                                if (!idcardValidator.isValidatedAllIdcard(idNum)) {
                                    errorMsg = errorMsg
                                            + (StringUtil.isEmpty(errorMsg) ? "身份证号码格式错误" : " || " + "身份证号码格式错误");
                                }
                            }
                            /*** 姓名 ****/
                            if (StringUtil.isEmpty(xm)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "姓名不能为空" : " || " + "姓名不能为空");
                            }

                            /*** 打印状态 ****/
                            if (StringUtil.isEmpty(dyzt)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "打印状态不能为空" : " || " + "打印状态不能为空");
                            } else {
                                dyzt = dyzt.substring(0, 1);
                                if (!dyzt.equalsIgnoreCase(Constants.DYZT_WDY)
                                        && !dyzt.equalsIgnoreCase(Constants.DYZT_YDY)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "打印状态无效" : " || " + "打印状态无效");
                                } else { /**** 已打印需要校验证书编号和发证日期 ****/
                                    if (dyzt.equalsIgnoreCase(Constants.DYZT_YDY)) {
                                        if (StringUtil.isEmpty(zsbh)) {
                                            errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "已打印人员证书编号不能为空"
                                                    : " || " + "已打印人员证书编号不能为空");
                                        }
                                        if (StringUtil.isEmpty(fzrq)) {
                                            errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "已打印人员发证日期不能为空"
                                                    : " || " + "已打印人员发证日期不能为空");
                                        }
                                    }
                                }
                            }
                            /*** 校验证书编号 ****/
                            if (StringUtil.isNotEmpty(zsbh)) {
                                if (zsbh.length() > 15) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "证书编号格式错误" : " || " + "证书编号格式错误");
                                } else {
                                    /*** 因为客户之前的excel文件证书编号可能存在科学计数法***/
                                    if (zsbh.contains("E") && zsbh.contains(".")) {
                                        BigDecimal bd = new BigDecimal(zsbh);
                                        zsbh = bd.toPlainString();
                                        data.put("zsbh", zsbh);
                                    }
                                }
                            }
                            data.put("zsbh", zsbh);
                            /*** 校验日期 ****/
                            if (StringUtil.isNotEmpty(fzrq)) {
                                /*** 校验日期合法性 ****/
                                if (!DateUtil.checkDate(fzrq)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "发证日期无效" : " || " + "发证日期无效");
                                } else {
                                    /*** 校验日期不能大于当前日期 ****/
                                    if (!DateUtil.dateCompare(fzrq, DateUtil.getCurrentDate(DateUtil.DATEFORMAT))) {
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "发证日期不能大于当前日期"
                                                : " || " + "发证日期不能大于当前日期");
                                    }

                                }
                            }
                            //TODO
                            /*背景筛查*/
                            //if(StringUtil.isEmpty(errorMsg)){
                            //    errorMsg = clientUtil.queryAndBGInfo(idNum,xm);
                            //}
                            ///*获取指纹*/
                            //if(StringUtil.isEmpty(errorMsg)){
                            //    if (isShowFingerprintConfig == null || (StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_YES.equals(isShowFingerprintConfig.getValue()))) {
                            //        //获取指纹
                            //        Pctinfo pctinfo = pctinfoService.findByIdnumber(idNum);
                            //        if (pctinfo != null) {
                            //            //获取到指纹
                            //            //personcertificate.setFingerprint(pctinfo.getBarcode());
                            //            //personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                            //        }else{
                            //            errorMsg = "没有指纹";
                            //        }
                            //    }
                            //}

                            // 生成错误的list
                            if (StringUtil.isNotEmpty(errorMsg)) {
                                data.put("errorMsg", errorMsg);
                                faildList.add(data);
                            } else {
                                list.add(data);
                            }

                        } catch (Exception e) {
                            if (e instanceof ArsException) {
                                data.put("errorMsg", e.getMessage());
                            } else {
                                data.put("errorMsg", "格式有错");
                            }
                            faildList.add(data);
                        }
                    } else {
                        flag = false;
                    }
                    i++;
                }

                /** 如果客户没上传内容 **/
                if (list.size() == 0 && faildList.size() == 0) {
                    result.setMsg("导入模板没有保安员信息，请录入");
                    result.setSuccessful(false);
                    return result;
                }

                /**** 处理保安员证业务逻辑 ***/
                List<Map<String, String>> checkFaildList = new ArrayList<>();
                if (list != null && list.size() > 0) {
                    checkFaildList = personcertificateService.saveSecurityCertificate(list, loginUser);
                }
                long endTime = System.currentTimeMillis();
                logger.info("耗费时间： " + (endTime - startTime) + " ms");

                /**** 如果校验的保安员信息有误 ****/
                if (checkFaildList != null && checkFaildList.size() > 0) {
                    faildList.addAll(checkFaildList);
                }

                /**** 如果存在校验错误信息，导出excel表格 ****/
                if (faildList.size() > 0) {
                    String excelTmepName = "certificateFailTemp.xls"; // excel模板

                    FileTemp fileTemp = fileTempDao.getFileTempByName(excelTmepName); // 查询文件模板信息

                    // resultMap.put("faildFilePath",
                    // buildFaildList(fileTemp.getPath(), faildList,request));
                    // // 生成导入错误的文件,// 绝对路径文件实现
                    resultMap.put("faildFilePath",
                            buildFaildList(Constants.FILETEMPPATH + fileTemp.getFileTempName(), faildList, request)); // 生成导入错误的文件
                }
            } else {
                throw new RuntimeException("当前登录信息错误, user:" + loginUser);
            }
            result.setData(resultMap);
            if (faildList.size() == 0) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg(faildList.size() + "人导入失败，请下载导入失败的人员信息");
            }
            targetFile.delete(); // 导入成功完删除文件
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 生成导入错误信息文件
     *
     * @param excelTempPath
     * @param data
     * @return downloadFilePath by llc 2018-08-09
     * @throws Exception
     */
    private String buildFaildList(String excelTempPath, List<Map<String, String>> data, HttpServletRequest request)
            throws Exception {

        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(tempfolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_importFailList.xls";
        String filePath = tempfolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        logger.info("路径： " + filePath);
        /**** 生成file ****/
        // FileUtil.reNameFile(excelTempPath,filePath); // 绝对路径文件实现

        reNameFile(excelTempPath, filePath, request);
        File file = new File(filePath);

        if (file != null) {
            HSSFWorkbook workbook = new HSSFWorkbook(new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(0);
            int index = 5;
            for (Map<String, String> map : data) {
                Row row = sheet.createRow(index);
                row.createCell(0).setCellValue(map.get("idNum")); // 身份证
                row.createCell(1).setCellValue(map.get("xm")); // 姓名
                row.createCell(2).setCellValue(map.get("companyName")); // 单位名称
                row.createCell(3).setCellValue(map.get("zsbh")); // 证书编号
                row.createCell(4).setCellValue(map.get("fzrq")); // 发证日期
                row.createCell(5).setCellValue(map.get("dyzt")); // 打印状态
                row.createCell(6).setCellValue(map.get("errorMsg")); // 错误信息
                index++;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write(fileOut);
            fileOut.close();
            workbook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    /**
     * 重命名文件
     *
     * @param oldPath String 原文件路径 如：原文件路径
     *                如：c:/data/ars/temp/securityCertificateTemp.xls
     * @param newPath String 复制后路径 如：复制后路径 如：c:/data/ars/temp/2018-08-09/保安员导入失败.xls
     * @return boolean by llc 2018-08-09
     **/
    private static void reNameFile(String oldPath, String newPath, HttpServletRequest request) {
        InputStream is = null;
        OutputStream out = null;
        try {
            is = request.getServletContext().getResourceAsStream(oldPath);
            int bytesum = 0;
            int byteread = 0;
            if (is != null) { // 文件存在时
                out = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                int length;
                while ((byteread = is.read(buffer)) != -1) {
                    bytesum += byteread; // 字节数 文件大小
                    out.write(buffer, 0, byteread);
                }
                is.close(); // 输入流关闭
                out.flush(); // 刷新输出流
                out.close(); // 输出流关闭
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (is != null || out != null) {
                try {
                    is.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 生成考试安排相关数据路径
     *
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    private String createTrainExamPath(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DataSycDto dataSycDto = new DataSycDto();
            dataSycDto.setDataType(Constants.DATASYC_TRAINEXAM_LIST);
            Map<String, Object> mapData = trainExamInfoService.exportExamData();
            dataSycDto.setData(JSONObject.toJSONString(mapData));
            Date now = new Date();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String listStr = JSONObject.toJSONString(dataSycDto);
            String content = CipherDESUtil
                    .parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));
            String filepath = FileUtil.writeTxtFile(content, "trainExam", tempfolder);
            return filepath;
        } catch (BadPaddingException badPaddingException) {
            logger.error(badPaddingException.getMessage(), badPaddingException);
            throw new ArsException("导入失败，非该区域数据\n！");
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 外网导入 -- 导入考试安排相关数据
     *
     * @param dataFile
     */
    @SuppressWarnings("unchecked")
    private AjaxResult outerImportTraimExam(File dataFile) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            if (dataFile != null) {
                BufferedReader br = new BufferedReader(new FileReader(dataFile));
                StringBuffer content = new StringBuffer();
                // 获取文件内容
                String lineTxt = null;
                while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
                    content.append(lineTxt);
                }
                br.close();

                String jsonStr = new String(
                        CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));

                DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);

                if (dataSycDto != null) {
                    if (dataSycDto.getDataType().equals(Constants.DATASYC_TRAINEXAM_LIST)) {
                        Map<String, Object> examData = JSONObject.parseObject(dataSycDto.getData(), Map.class);
                        trainExamInfoService.importExamData(examData);
                        result.setMsg("导入成功");
                        result.setSuccessful(true);
                    } else {
                        result.setMsg("导入失败，非考试安排相关数据！");
                        result.setSuccessful(false);
                    }
                } else {
                    result.setMsg("导入失败，非考试安排相关数据！");
                    result.setSuccessful(false);
                }
            } else {
                result.setMsg("导入失败，非考试安排相关数据！");
                result.setSuccessful(false);
            }
        } catch (BadPaddingException badPaddingException) {
            logger.error(badPaddingException.getMessage(), badPaddingException);
            throw new ArsException("导入失败，非该区域数据\n！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /***
     * 根据不同的省市进入保安员资格证考试报名页面
     * @return 页面路径
     * @deprecated  add 2019-04-04
     */
    @RequestMapping("/toListPage")
    public ModelAndView toListPage(PersoncertificateSearchDto searchDto) {
        /**
         * 当前省份信息
         */
        Config currentNativeConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
        ModelAndView view = new ModelAndView();
        //默认返回路径地址，如有配置省份，地址加上省份编码，如北京splist11
        StringBuffer path =new StringBuffer( "personcertificate/splist");
        //获取配置省份配置
        if(currentNativeConfig!=null){

            path.append(currentNativeConfig.getValue());
        }
        view.addObject("record",searchDto);
        //返回地址信息
        view.setViewName(path.toString());
        return view;

    }
    /***
     * 根据不同的省市进入保安员资格证考试报名页面
     * @return 页面路径
     * @deprecated  add 2019-04-04
     */
    @RequestMapping("/toQueryPage")
    public ModelAndView toQueryPage( ) {
        /**
         * 当前省份信息
         */
        Config currentNativeConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
        ModelAndView view = new ModelAndView();
        //默认返回路径地址，如有配置省份，地址加上省份编码，如北京splist11
        StringBuffer path =new StringBuffer( "personcertificate/list");
        //获取配置省份配置
        if(currentNativeConfig!=null){
            path.append(currentNativeConfig.getValue());
        }
        //返回地址信息
        view.setViewName(path.toString());
        return view;

    }

    /**
     * 保安员资格 证分页查询（目前仅适用北京）
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(PersoncertificateSearchDto dto, AjaxPageResponse<PersoncertificateDto> page){
        personcertificateService.searchForPage(dto,page);
        return page;
    }
    /**
     * 保安员资格 证分页查询（目前仅适用北京）
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchPage")
    @ResponseBody
    public AjaxPageResponse searchPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page){
        personcertificateService.searchPage(dto,page);
        return page;
    }

    /***
     * 北京补贴人员明细
     * @return 查询
     * @deprecated  add 2019-04-04
     */
    @RequestMapping("searchSubsidyPage")
    @ResponseBody
    public AjaxPageResponse searchSubsidyPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page){
        personcertificateService.searchSubsidyPage(dto,page);
        return page;
    }

    @RequestMapping("inputFingerprint")
    public @ResponseBody
    AjaxResult inputFingerprint(Long id, String fingerprint) {
        AjaxResult result = new AjaxResult();
        try {
            Personcertificate personcertificate = personcertificateService.findById(id);
            personcertificate.setFingerprint(fingerprint);
            personcertificate.setFingercardState(Constants.FINGERCARD_STATE_YCJ);
            personcertificate.setApprovalstate(ApprovalState.SPZ);
            personcertificateService.inputFingerprint(personcertificate);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            result.setMsg("指纹录入失败！");
            result.setSuccessful(false);
        }
        return result;
    }


    /***
     * 北京补贴人员明细
     * @return 页面路径
     * @deprecated  add 2019-04-04
     */
    @RequestMapping("/toListPageBySubsidy")
    public ModelAndView toListPageBySubsidy(PersoncertificateSearchDto searchDto) {

        ModelAndView view = new ModelAndView();
        view.addObject("record",searchDto);
        //返回地址信息
        view.setViewName("personcertificate/splistSubsidy11");
        return view;

    }

}
