package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.ManagementInfoPageSearchDto;
import com.bcxin.ars.dto.sb.ManagementInfoSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.ManagementInfo;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.ManagementInfoService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("managementInfo")
public class ManagementInfoController {

	Logger logger = LoggerFactory.getLogger(ManagementInfoController.class);
	
	@Autowired
	private ManagementInfoService managementInfoService;

	@Autowired
	private SecurityPersonService personService;

	@Autowired
	private SecurityCompanyService companyService;

	@Autowired
	private ArsUtil arsUtil;


	/**
	 * 管理列表页面
	 * @return
	 */
	@RequestMapping("list/index")
	@RequiresPermissions("managementInfo:view")
	public ModelAndView listIndex(ManagementInfoPageSearchDto searchDto){
		ModelAndView view = new ModelAndView("managementInfo/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	@RequiresPermissions("managementInfo:view")
	public AjaxPageResponse searchForPage(ManagementInfoPageSearchDto dto, AjaxPageResponse<ManagementInfo> page){
		managementInfoService.searchForPage(dto,page);
		return page;
	}


	@RequestMapping("search")
	public @ResponseBody AjaxResult search(ManagementInfoSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(dto.getUserid() == null){
					dto.setUserid(user.getId());
				}
				ManagementInfoSearchDto list = managementInfoService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	@RequestMapping("index")
	public ModelAndView managerInfo(@RequestParam(required = false) Long companyId,@RequestParam(required = false) Long comId){
		ModelAndView view = new ModelAndView("sys/company/manager");
		if(companyId != null) {
			SecurityCompany company = companyService.findById(companyId);
			view.addObject("managerUserId", company.getUser().getId());
		}else if(comId != null){
			SecurityCompany company = companyService.findByComId(comId);
			view.addObject("managerUserId", company.getUser().getId());
		}
		return view;
	}

	@RequestMapping("searchForCompany")
	@ResponseBody
	public AjaxPageResponse searchForCompany(ManagementInfoSearchDto dto) throws Exception{
		AjaxPageResponse result = new AjaxPageResponse();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(dto.getUserid() == null){
					dto.setUserid(user.getId());
				}
				ManagementInfoSearchDto list = managementInfoService.search(dto);
				result.setData(list.getData());
				result.setTotal(list.getData().size());
			} else {
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("update")
	public @ResponseBody AjaxResult update(ManagementInfo managementInfo) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				managementInfoService.saveOrUpdate(managementInfo);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			ManagementInfo managementInfo = managementInfoService.findById(id);
			result.setSuccessful(true);
			result.setData(managementInfo);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(ManagementInfo managementInfo) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				managementInfoService.delete(managementInfo);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
