package com.bcxin.ars.rest.sb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.LegalchangeSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.json.JSONUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */

@Controller
@RequestMapping("legalchange")
public class LegalchangeController {
    Logger logger = LoggerFactory.getLogger(LegalchangeController.class);
	
	@Autowired
	private LegalchangeService legalchangeService;

	@Autowired
	private SecurityCompanyService securityCompanyService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private SecurityCompanyService companyService;
	
	@Autowired
	private UserService userService;
	
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private GXSSOUtil gxssoUtil;
	
	@RequestMapping("search")
	public @ResponseBody
    AjaxResult search(LegalchangeSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(user.getPlatform()==2){
					dto.setUserid(user.getId());
				}

				LegalchangeSearchDto list = legalchangeService.search(dto);
				if(list.getData() != null && list.getData().size() >=0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/***
	 * 项目变更证书打印页面
	 * @return
	 */
	@RequestMapping("certificateListPage")
	public ModelAndView certificateListPage(LegalchangeSearchDto dto){
		ModelAndView view = new ModelAndView();
		view.setViewName("legalchange/list");
		view.addObject("record",dto);
		return view;
	}


	/***
	 * 项目变更证书打印页面
	 * @return
	 */
	@RequestMapping("searchCompanyCertificate")
    @RequiresPermissions("legalchangePrint:query")
    public @ResponseBody
	AjaxResult searchCompanyCertificate(LegalchangeSearchDto dto) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
//				User currentUser = arsUtil.getCurrentUser();
//				//机构信息
//				Police police = currentUser.getPolice();
//				if(police != null) {
//					String areacode = police.getAreacode();
//					if (areacode.endsWith("0000")) {//省
//						dto.setDistrict(areacode.substring(0, 2) + "____");
//					} else if (areacode.endsWith("00")) {//市
//						dto.setDistrict(areacode.substring(0, 4) + "__");
//					} else {//区
//						dto.setDistrict(areacode);
//					}
//				}
				LegalchangeSearchDto data = legalchangeService.searchCompanyCertificate(dto);
				result.setSuccessful(true);
				result.setData(data);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}



	/***
	 * 项目变更证书打印页面
	 * @return
	 */
	@RequestMapping("addCertificatePage")
	public ModelAndView addCertificatePage(Long legalchangeId ){
		ModelAndView view = new ModelAndView();

		//项目变更信息
		Legalchange  legalchange = legalchangeService.findById(legalchangeId);

		//公司信息
		SecurityCompany securityCompany = securityCompanyService.findById(legalchange.getCompanyid());

		//保安服务公司
		if(Constants.BKT_ORGTYPE_GS.equals(securityCompany.getInstitutionType())){
			view.setViewName("legalchange/legalchangeapprovalComany");
		}else{//培训单位
			view.setViewName("legalchange/legalchangeapprovalTrain");
		}
		//设置公司信息 add 2019-01-31 subh
		if(securityCompany!=null) {
			legalchange.setSecurityCompany(securityCompany);
		}
		String json = JSON.toJSONString(legalchange, SerializerFeature.WriteNonStringValueAsString);
		System.out.println("==========> 制证信息json输出："+json);
		logger.error("==========> 制证信息json输出："+json);
		view.addObject("legalchange", json);

		return view;
	}



	@RequestMapping("/searchLegalchangeList_table")
    @RequiresPermissions("legalchange:query")
	@ResponseBody
	public PageResult searchLegalchangeList_table(@RequestParam Map<Object, Object> params, ModelMap model,
												  HttpServletRequest req, HttpServletResponse resp) {
		Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
		if (params.get("checkType")!=null) {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				if (user.getPlatform() == 2) {
					p.put("userid",user.getId());
				} else{
					//角色列表
					List<PoliceRole> roles = user.getRoles();
					if(roles!=null&&roles.size()>0) {
						p.put("roles",roles);
					}
				}
			}
		}


		return legalchangeService.searchLegalchangeList_table(p);
	}



	@RequestMapping("list/index")
	public ModelAndView listIndex(LegalchangeSearchDto searchDto){
		ModelAndView view = new ModelAndView("legalchange/list2");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@RequiresPermissions("legalchange:query")
	@ResponseBody
	public AjaxPageResponse searchForPage(LegalchangeSearchDto dto, AjaxPageResponse<Legalchange> page){
		if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				dto.setUserid(user.getId());
			}
		}
		legalchangeService.searchForPage(dto,page);
		return page;
	}















	@RequestMapping("update")
	public @ResponseBody
    AjaxResult update(Legalchange legalchange, HttpSession httpSession) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				legalchangeService.saveOrUpdate(legalchange);
				String projectNo= (String) httpSession.getAttribute("projectNo");
				if (StringUtil.isNotEmpty(projectNo)){
					String token= (String) httpSession.getAttribute("gxssotoken");
					gxssoUtil.reportData(token,projectNo);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("updateAndSaveWorkExperience")
	public @ResponseBody
    AjaxResult updateAndSaveWorkExperience(Legalchange legalchange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				legalchangeService.updateAndSaveWorkExperience(legalchange,startdate,enddate,workCompanyname,post);
				result.setData(legalchange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody
    AjaxResult delete(Legalchange legalchange) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				legalchangeService.delete(legalchange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody
    AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Legalchange legalchange = legalchangeService.findById(id);
			
			if(legalchange != null){
				SecurityCompany company = companyService.findByUserid(legalchange.getUserid());
				legalchange.setSecurityCompany(company);
				result.setSuccessful(true);
				result.setData(legalchange);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody
    AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	Legalchange legalchange = legalchangeService.findByUser(user.getId());
				//获取单位信息
				SecurityCompany company = companyService.findByUserid(user.getId());

                if(legalchange != null){
					legalchange.setSecurityCompany(company);
					result.setSuccessful(true);
                    result.setData(legalchange);
                }else if(legalchange == null && company!=null){
					legalchange = new Legalchange();
					result.setSuccessful(true);
					legalchange.setSecurityCompany(company);
					result.setData(legalchange);
				}
				else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

	@RequestMapping("updateApprovalResult")
	public @ResponseBody
	AjaxResult updateApprovalResult(Long businessid, String approvalstate) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				Legalchange legalchange = legalchangeService.findById(businessid);
				if (legalchange != null) {
					legalchange.setLegalcensorstatus(approvalstate);
					legalchangeService.updateCensorStatus(legalchange);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("plan/updateApprovalResult")
	public @ResponseBody
	AjaxResult updatePlanApprovalResult(Long businessid, String approvalstate) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				Legalchange legalchange = legalchangeService.findById(businessid);
				if (legalchange != null) {
					legalchange.setNdlegalcensorstatus(approvalstate);
					legalchangeService.updateCensorStatus(legalchange);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 指派民警
	 * @param legalchange
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("updatePoliceId")
	public @ResponseBody AjaxResult updatePoliceId(Legalchange legalchange) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				legalchangeService.updatePoliceId(legalchange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据公司ID获取明细
	 * @return
	 */
	@RequestMapping("findApprovePassByCompanyId")
	public @ResponseBody
	AjaxResult findApprovePassByCompanyId(Long companyId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<Legalchange> legalchanges = legalchangeService.findApprovePassByCompanyId(companyId);
			result.setSuccessful(true);
			result.setData(legalchanges);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
