package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.InvestorPageSearchDto;
import com.bcxin.ars.dto.sb.InvestorSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Investor;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.InvestorService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

@Controller
@RequestMapping("investor")
public class InvestorController {

	Logger logger = LoggerFactory.getLogger(InvestorController.class);
	
	@Autowired
	private InvestorService investorService;

	@Autowired
	private SecurityPersonService personService;
	
	@Autowired
	private ArsUtil arsUtil;



	/**
	 * 管理列表页面
	 * @return
	 */
	@RequestMapping("list/index")
	@RequiresPermissions("investor:view")
	public ModelAndView listIndex(InvestorPageSearchDto searchDto){
		ModelAndView view = new ModelAndView("investor/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	@RequiresPermissions("investor:view")
	public AjaxPageResponse searchForPage(InvestorPageSearchDto dto, AjaxPageResponse<Investor> page){
		investorService.searchForPage(dto,page);
		return page;
	}

	@RequestMapping("search")
	public @ResponseBody AjaxResult search(InvestorSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(dto.getUserid() == null){
					dto.setUserid(user.getId());
				}
				InvestorSearchDto list = investorService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("searchForCompany")
	@ResponseBody
	public AjaxPageResponse searchForCompany(InvestorSearchDto dto) throws Exception{
		AjaxPageResponse result = new AjaxPageResponse();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if(dto.getUserid() == null){
					dto.setUserid(user.getId());
				}
				InvestorSearchDto list = investorService.search(dto);
				result.setData(list.getData());
			} else {
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Investor investor) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				investorService.saveOrUpdate(investor);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Investor investor) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				investorService.delete(investor);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Investor investor = investorService.findById(id);
			result.setSuccessful(true);
			result.setData(investor);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据USERID获取明细
	 * @return
	 */
	@RequestMapping("findByUserId/{userId}")
	public @ResponseBody AjaxResult findByUserId(@PathVariable("userId")Long userId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<Investor> investors = investorService.findByUserId(userId);
			result.setSuccessful(true);
			result.setData(investors);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据USERID获取明细
	 * @return
	 */
	@RequestMapping("findByCurrentUser")
	public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsUtil.getCurrentUser();
			Long userId = currentUser.getId();

			List<Investor> investors = investorService.findByUserId(userId);
			result.setSuccessful(true);
			result.setData(investors);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
