package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.sb.HistoryApplicationRecord;
import com.bcxin.ars.service.sb.BusinessService;
import com.bcxin.ars.service.sb.HistoryApplicationRecordService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.webservice.ClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("historyApplicationRecord")
public class HistoryApplicationRecordController {


    /***
     * 日志
     */
    public static  final Logger logger = LoggerFactory.getLogger(ChargeworkController.class);

    @Autowired
    private HistoryApplicationRecordService historyApplicationRecordService;
    @Autowired
    private ClientUtil clientUtil;

    @RequestMapping("findHistoryApplicationRecord")
    public @ResponseBody
    AjaxResult search(String businesstype,Long businessid) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            String idNum = clientUtil.getIdNum(businessid,businesstype);
            result.setSuccessful(true);
            result.setData(historyApplicationRecordService.findHistoryApplicationRecord(idNum));
        } catch(Exception e) {
            result.setSuccessful(false);
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
