package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.sb.GradePracticeSearchDto;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.service.sb.GradePracticeService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/****
 * 等级证实习记录
 * @author  subh
 */
@Controller
@RequestMapping("gradePractice")
public class GradePracticeController extends BaseController {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(GradePracticeController.class);


    @Autowired
    private GradePracticeService gradePracticeService;
    /***
     * 进入等级证实习记录查询页面
     * @desc add subh 2019-03-22 14:39
     */
    @RequestMapping("toQueryPage")
    @RequiresPermissions("gradePracticeManager:toQueryPage")
    public ModelAndView toQueryForTrainOrg(GradePracticeSearchDto searchDto){
        ModelAndView view = new ModelAndView("gradepractice/query");
        view.addObject("record",searchDto);
        return view;
    }
    /***
     * 等级证实习记录查询
     * @param dto 等级证实习记录查询参数
     * @return 等级证列表
     * @throws Exception
     */
    @RequestMapping("query")
    @RequiresPermissions("gradePracticeManager:query")
    public @ResponseBody
    AjaxPageResponse searchForTrain(GradePracticeSearchDto dto, AjaxPageResponse page){
        try {
            //等级证实习记录查询
            gradePracticeService.query(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
}
