package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dao.sys.FileTempDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.GradePersonSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.model.sys.FileTemp;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.sb.GradePersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.IdcardValidator;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.*;

/****
 * 等级证控制层
 * @author subh
 */
@Controller
@RequestMapping("gradePerson")
public class GradePersonController extends BaseController {
    /***
     * 日志
     */
    private static final Logger logger =  LoggerFactory.getLogger(FirearmsController.class);
    @Autowired
    private GradePersonService gradePersonService;
    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private PoliceService policeService;

    @Value("${temp-folder}")
    private String tempfolder;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private FileTempDao fileTempDao;
    /***
     * 进入 等级证查询页面
     * @desc add subh 2019-03-22 14:39
     */
    @RequestMapping("toQueryPage")
    @RequiresPermissions("gradePersonManager:query")
    public ModelAndView toQueryForTrainOrg(){
        ModelAndView view = new ModelAndView();
        view.setViewName("grade/query"+configUtils.getCurrentNative());
        view.addObject("policeList",policeService.findByType("3"));
        //获取问题人员类型
        view.addObject("importBatchIdList", gradePersonService.queryImportBatchIdList());
        return view;
    }
    /***
     * 进入 等级证查询页面
     * @desc add subh 2019-03-22 14:39
     */
    @RequestMapping("toQueryApprovalPage")
    @RequiresPermissions("gradePersonManager:query")
    public ModelAndView toQueryApprovalPage(GradePersonSearchDto searchDto){
        ModelAndView view = new ModelAndView();
        view.setViewName("grade/queryApproval");
        view.addObject("policeList",policeService.findByType("3"));
        view.addObject("record",searchDto);
        //获取问题人员类型
        view.addObject("importBatchIdList", gradePersonService.queryImportBatchIdList());
        return view;
    }
    /***
     * 进入 等级证修改页面
     * @param  id  主键
     */
    @RequestMapping("toEditPage/{id}")
    @RequiresPermissions("gradePersonManager:edit")
    public ModelAndView toEditPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        view.addObject("record",gradePersonService.findById(id));
        view.setViewName("grade/edit");
        return view;
    }
    /**
     * 获取批次号列表
     */
    @RequestMapping("queryImportBatchIdList")
    @ResponseBody
    public AjaxResult queryImportBatchIdList(){
        AjaxResult result = new AjaxResult();
        try {
            result.setData( gradePersonService.queryImportBatchIdList());
            result.setSuccessful(true);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 修改
     * @param gradePerson 比对人员信息
     */
    @RequestMapping("edit")
    @RequiresPermissions("gradePersonManager:edit")
    @ResponseBody
    public AjaxResult edit(GradePerson gradePerson){
        AjaxResult result = new AjaxResult();
        try {
            gradePersonService.update(gradePerson);
            result.setSuccessful(true);
            result.setMsg("修改成功！");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 保存申诉
     * @param gradePerson 比对人员信息
     */
    @RequestMapping("saveAppeal")
    @RequiresPermissions("gradePersonManager:edit")
    @ResponseBody
    public AjaxResult saveAppeal(GradePerson gradePerson){
        AjaxResult result = new AjaxResult();
        try {
            gradePersonService.saveAppeal(gradePerson);
            result.setSuccessful(true);
            result.setMsg("修改成功！");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 进入申诉页面
     * @param  id  主键
     */
    @RequestMapping("toAppealPage/{id}")
    @RequiresPermissions("gradePersonManager:edit")
    public ModelAndView toAppealPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        GradePerson record  =  gradePersonService.findById(id);
        //设置为提交申诉
        record.setAppealState(Constants.APPEAL_APPLY);
        view.addObject("policeList",policeService.findByType("3"));
        view.addObject("record",record);
        view.setViewName("grade/appeal");
        return view;
    }

    /***
     * 进入申诉审核页面
     * @param  id  主键
     */
    @RequestMapping("toAppealApprovalPage/{id}")
    @RequiresPermissions("gradePersonManager:edit")
    public ModelAndView toAppealApprovalPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        GradePerson record  =  gradePersonService.findById(id);
        //设置为提交申诉
        record.setAppealState(Constants.APPEAL_APPLY);
        view.addObject("record",record);
        view.setViewName("grade/appealApproval");
        return view;
    }


    /**
     * 保存申诉
     * @param gradePerson 比对人员信息
     */
    @RequestMapping("saveAppealApproval")
    @RequiresPermissions("gradePersonManager:edit")
    @ResponseBody
    public AjaxResult saveAppealApproval(GradePerson gradePerson){
        AjaxResult result = new AjaxResult();
        try {
            gradePersonService.saveAppealApproval(gradePerson);
            result.setSuccessful(true);
            result.setMsg("修改成功！");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 修改
     * @param id 主键
     */
    @RequestMapping("refreshComparison/{id}")
    @RequiresPermissions("gradePersonManager:refreshComparison")
    @ResponseBody
    public AjaxResult refreshComparison(@PathVariable Long id){
        AjaxResult result = new AjaxResult();
        try {
            GradePerson gradePerson =  gradePersonService.findById( id );
            gradePersonService.update(gradePerson);
            result.setSuccessful(true);
            result.setMsg("提交重新比对成功！");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 等级证查询
     * @param dto 等级证查询参数
     * @return 等级证列表
     * @throws Exception
     */
    @RequestMapping("query")
    @RequiresPermissions("gradePersonManager:query")
    public @ResponseBody
    AjaxPageResponse searchForTrain(GradePersonSearchDto dto, AjaxPageResponse page){
        try {
            //获取当前用户
            User user = arsUtil.getCurrentUser();
            if(user!=null){
                if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                    //公安设置为空
                    if (user.getPlatform() == Constants.PLATFORM_POLICE) {
                        //公安设置为空
                        dto.setUserId(null);
                    }
                }
            }
            //查询等级证信息
            gradePersonService.query(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }


    /**
     * 批量导入比对人员 by jc 2019-03-26
     */
    @RequestMapping("importGradePersonData")
    @RequiresPermissions("gradePersonManager:import")
    public @ResponseBody
    AjaxResult importSecurityGuardData(MultipartFile file, HttpServletRequest request)
            throws Exception {
        AjaxResult result = new AjaxResult();
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!fileType.toUpperCase().equalsIgnoreCase("XLS") && !fileType.toUpperCase().equalsIgnoreCase("XLSX")) {
            result.setMsg("导入的模板文件有误");
            result.setSuccessful(false);
            return result;
        }
        long startTime = System.currentTimeMillis();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "." + fileType;
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = tempfolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            file.transferTo(targetFile);
            Map<String, Object> resultMap = new HashMap<String, Object>();
            User loginUser = arsUtil.getCurrentUser();
            List<Map<String, String>> list = new ArrayList<Map<String, String>>(); // 数据库校验的list
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>(); // 定义失败的list
            if (loginUser != null) {

                FileInputStream inStream = new FileInputStream(targetFile);
                Workbook workBook = WorkbookFactory.create(inStream);
                Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
                boolean flag = true;
                int i = 5; // 设置初始行为第6行
                while (flag) {
                    Row row = sheet.getRow(i);
                    if (row != null) {
                        Map<String, String> data = new HashMap<String, String>();
                        try {
                            /*** 客户的数据格式及其复杂
                             *
                             * 1.英文的空格  2.中文的空格  3.非美式英文的半角空格  4.一个tab键  5 .2个tab键
                             * 不过tab键在java可以按英文空格处理，如果在数据库判断长度就非常长了
                             * 现有校验按 1-2-3
                             */
                            String errorMsg = ""; // 校验错误信息
                            /**** 身份证 ****/
                            String idnum = ExcelUtil.getCellValue(row.getCell(0));
                            idnum = idnum.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("idnum", idnum);

                            /**** 姓名 ****/
                            String name = ExcelUtil.getCellValue(row.getCell(1));
                            name = name.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("name", name);

                            /**** 公司名称 ****/
                            String companyName = ExcelUtil.getCellValue(row.getCell(2));
                            companyName = companyName.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("companyName", companyName);

                            data.put("userId", loginUser.getId().toString());
                            data.put("trainOrgName", loginUser.getRealname());
                            data.put("updateBy", loginUser.getUsername());
                            /***** 校验excel字段 ****/

                            /*** 身份证号码 ****/
                            if (StringUtil.isEmpty(idnum)) {
                                errorMsg = errorMsg + "身份证号码不能为空";
                            } else {
                                IdcardValidator idcardValidator = new IdcardValidator();
                                if (!idcardValidator.isValidatedAllIdcard(idnum)) {
                                    errorMsg = errorMsg
                                            + (StringUtil.isEmpty(errorMsg) ? "身份证号码格式错误" : " || " + "身份证号码格式错误");
                                }else{
                                    //判断年龄是否在19岁-59岁
                                    int age = IdcardValidator.getAgeByIDNumber(idnum);
                                    if(age< 19 || age>60){
                                        errorMsg = errorMsg
                                                + (StringUtil.isEmpty(errorMsg) ? "年龄必须是19岁-59岁" : " || " + "年龄必须是19岁-59岁");
                                    }
                                }
                            }
                            /*** 姓名 ****/
                            if (StringUtil.isEmpty(name)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "姓名不能为空" : " || " + "姓名不能为空");
                            }
                            /*** 公司名称 ****/
                            if (StringUtil.isEmpty(companyName)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "公司名称不能为空" : " || " + "公司名称不能为空");
                            }
                            // 生成错误的list
                            if (StringUtil.isNotEmpty(errorMsg)) {
                                data.put("errorMsg", errorMsg);
                                faildList.add(data);
                            } else {
                                list.add(data);
                            }

                        } catch (Exception e) {
                            if (e instanceof ArsException) {
                                data.put("errorMsg", e.getMessage());
                            } else {
                                data.put("errorMsg", "格式有错");
                            }
                            faildList.add(data);
                        }
                    } else {
                        flag = false;
                    }
                    i++;
                }

                /** 如果客户没上传内容 **/
                if (list.size() == 0 && faildList.size() == 0) {
                    result.setMsg("导入模板没有等级证信息，请录入");
                    result.setSuccessful(false);
                    return result;
                }

                /**** 处理保安师业务逻辑 ***/
                List<Map<String, String>> checkFaildList = new ArrayList<>();
                if (list != null && list.size() > 0) {
                    //处理业务逻辑
                    checkFaildList = gradePersonService.insertBatchForImport(list);
                }
                long endTime = System.currentTimeMillis();
                logger.info("耗费时间： " + (endTime - startTime) + " ms");
                /**** 如果校验的比对人员信息有误 ****/
                if (checkFaildList != null && checkFaildList.size() > 0) {
                    faildList.addAll(checkFaildList);
                }
                /**** 如果存在校验错误信息，导出excel表格 ****/
                if (faildList.size() > 0) {
                    String excelTmepName = "gradePersonFailTemp.xls"; // excel模板
                    FileTemp fileTemp = fileTempDao.getFileTempByName(excelTmepName); // 查询文件模板信息
                    resultMap.put("faildFilePath",
                            buildFaildList(Constants.FILETEMPPATH + fileTemp.getFileTempName(), faildList, request)); // 生成导入错误的文件
                }
            } else {
                throw new RuntimeException("当前登录信息错误, user:" + loginUser);
            }
            result.setData(resultMap);
            if (faildList.size() == 0) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg(faildList.size() + "人导入失败，请下载导入失败的比对人员信息");
            }
            targetFile.delete(); // 导入成功完删除文件
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 生成导入错误信息文件
     * @param excelTempPath
     * @param data
     * @return downloadFilePath by llc 2018-08-09
     * @throws Exception
     */
    private String buildFaildList(String excelTempPath, List<Map<String, String>> data, HttpServletRequest request)
            throws Exception {

        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(tempfolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_importFailList.xls";
        String filePath = tempfolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        logger.info("路径： " + filePath);
        /**** 生成file ****/
        // FileUtil.reNameFile(excelTempPath,filePath); // 绝对路径文件实现

        reNameFile(excelTempPath, filePath, request);
        File file = new File(filePath);

        if (file != null) {
            HSSFWorkbook workbook = new HSSFWorkbook(new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(0);
            int index = 5;
            for (Map<String, String> map : data) {
                Row row = sheet.createRow(index);
                row.createCell(0).setCellValue(map.get("idnum")); // 身份证
                row.createCell(1).setCellValue(map.get("name")); // 姓名
                row.createCell(2).setCellValue(map.get("companyName")); // 公司名称
                row.createCell(3).setCellValue(map.get("errorMsg")); // 错误信息
                index++;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write(fileOut);
            fileOut.close();
            workbook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    /**
     * 重命名文件
     *
     * @param oldPath String 原文件路径 如：原文件路径
     *                如：c:/data/ars/temp/securityCertificateTemp.xls
     * @param newPath String 复制后路径 如：复制后路径 如：c:/data/ars/temp/2018-08-09/保安员导入失败.xls
     * @return boolean by llc 2018-08-09
     **/
    private static void reNameFile(String oldPath, String newPath, HttpServletRequest request) throws IOException {
        InputStream is = null;
        OutputStream out = null;
        try {
            is = request.getServletContext().getResourceAsStream(oldPath);
            int bytesum = 0;
            int byteread = 0;
            if (is != null) { // 文件存在时
                out = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                int length;
                while ((byteread = is.read(buffer)) != -1) {
                    bytesum += byteread; // 字节数 文件大小
                    out.write(buffer, 0, byteread);
                }
                is.close(); // 输入流关闭
                out.flush(); // 刷新输出流
                out.close(); // 输出流关闭
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (is != null || out != null) {
                try {
                    is.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
