package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.GradeClassPageSearchDto;
import com.bcxin.ars.model.sb.GradeClass;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.service.sb.GradeClassService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/****
 * 等级证班级信息
 * @author  subh
 */
@Controller
@RequestMapping("gradeClass")
public class GradeClassController extends BaseController {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(GradeClassController.class);

    @Autowired
    private GradeClassService gradeClassService;
    /***
     * 进入等级证班级信息查询页面
     */
    @RequestMapping("toQueryPage")
    @RequiresPermissions("gradeClassManager:toQueryPage")
    public ModelAndView toQueryForTrainOrg(GradeClassPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("gradeclass/query");
        view.addObject("record",searchDto);
        return view;
    }
    /***
     * 等级证班级信息查询
     * @param searchDto 等级证班级信息查询参数
     * @return 等级证列表
     * @throws Exception
     */
    @RequestMapping("query")
    @RequiresPermissions("gradeClassManager:query")
    public @ResponseBody
    AjaxPageResponse searchForTrain(GradeClassPageSearchDto searchDto, AjaxPageResponse page){
        try {
            //等级证实习记录查询
            gradeClassService.query(searchDto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }


    /***
     * 进入等级证班级信息查询页面
     */
    @RequestMapping("toAppealApprovalPage/{id}")
    @RequiresPermissions("gradeClassManager:saveAppealApproval")
    public ModelAndView toAppealApprovalPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        GradeClass record  =  gradeClassService.findById(id);
        view.addObject("record",record);
        view.setViewName("gradeclass/appealApproval");
        return view;
    }
    /***
     * 进入查看班级信息详细页面
     */
    @RequestMapping("toViewPage/{id}")
    @RequiresPermissions("gradeClassManager:view")
    public ModelAndView toViewPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        GradeClass record  =  gradeClassService.findById(id);
        view.addObject("record",record);
        view.setViewName("gradeclass/view");
        return view;
    }


    /***
     * 进入等级证班级信息查询页面
     */
    @RequestMapping("saveAppealApproval")
    @RequiresPermissions("gradeClassManager:saveAppealApproval")
    public @ResponseBody AjaxResult saveAppealApproval(GradeClass gradeClass){
        AjaxResult result = new AjaxResult();
        try {
            gradeClassService.saveAppealApproval(gradeClass);
            result.setSuccessful(true);
            result.setMsg("审批成功！");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
