package com.bcxin.ars.rest.sb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ModelNameDTO;
import com.bcxin.ars.dto.PropertiesDTO;
import com.bcxin.ars.dto.sys.ExportRosterDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.sb.ExportService;
import com.bcxin.ars.service.sys.SyncDataService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;

@Controller
@RequestMapping("export")
public class ExportController {
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private RedisUtil redisUtil;
    //指定的cache缓存名称 2018年8月16日18:00:27 wjb
    public final static String CACHE_PREFIX_KEY = "shiro-activeSessionCache";
    @Autowired
    private ExportService exportService;
    @Autowired
    private SyncDataService syncDataService;
    Logger logger = LoggerFactory.getLogger(ExportController.class);


    @Autowired
    private SecurityCompanyService securityCompanyService;
    @RequestMapping("exportByMessage")
    public @ResponseBody
    AjaxResult exportByMessage(String tableId, String josnStr, String map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            Map map1 = new HashMap();
            //if(user != null) {
            //表
            if ((map != null && StringUtil.isNotEmpty(map))) {
                JSONObject jasonObject = JSONObject.fromObject(map);
                map1 = jasonObject;
            }
            PropertiesDTO propertiesDTO = this.changeTableIdToTableMessage(tableId);
           /**
            *  //获取浏览器
            *  不同的浏览器的编码不一样
            *  */
            String userAgent = request.getHeader("user-agent");
            String tableExcelName;
            if (userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0
                    || userAgent.indexOf("Safari") >= 0) {
                tableExcelName= new String((propertiesDTO.getExcelName()).getBytes(), "ISO8859-1");
            } else {
                tableExcelName=URLEncoder.encode(propertiesDTO.getExcelName(),"UTF8"); //其他浏览器
            }
            String excelPath = exportService.exportForExcel(propertiesDTO, josnStr, map1, user,tableExcelName);

            //获取cookie中的数据
            String phone = arsUtil.getCurrentUser().getPhone();
            String cookieName = phone  + tableId;
            /**
             * 将用户的选择记录
            * */
            redisUtil.set(cookieName,josnStr);
            if (excelPath != null) {
                result.setData(excelPath);
                result.setMsg("导出成功");
                result.setSuccessful(true);
            } else {
                result.setMsg("数据为空");
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }





    @RequestMapping("export")
    public @ResponseBody
    AjaxResult export(String tableId, String josnStr, String map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            Map map1 = new HashMap();
            //if(user != null) {
            //表
            if ((map != null && StringUtil.isNotEmpty(map))) {
                JSONObject jasonObject = JSONObject.fromObject(map);
                map1 = jasonObject;
            }
            PropertiesDTO propertiesDTO = this.changeTableIdToTableMessage(tableId);
            /**
             *  //获取浏览器
             *  不同的浏览器的编码不一样
             *  */
            String userAgent = request.getHeader("user-agent");
            String tableExcelName;
            if (userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0
                    || userAgent.indexOf("Safari") >= 0) {
                tableExcelName= new String((propertiesDTO.getExcelName()).getBytes(), "ISO8859-1");
            } else {
                tableExcelName=URLEncoder.encode(propertiesDTO.getExcelName(),"UTF8"); //其他浏览器
            }
            String excelPath = exportService.commonExportExcel(propertiesDTO, josnStr, map1, user,tableExcelName);

            //获取cookie中的数据
            String phone = arsUtil.getCurrentUser().getPhone();
            String cookieName = phone  + tableId;
            /**
             * 将用户的选择记录
             * */
            redisUtil.set(cookieName,josnStr);
            if (excelPath != null) {
                result.setData(excelPath);
                result.setMsg("导出成功");
                result.setSuccessful(true);
            } else {
                result.setMsg("数据为空");
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("exportExcel")
    public @ResponseBody
    AjaxResult exportExcel(String tableId, String josnStr, String map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            Map map1 = new HashMap();
            //if(user != null) {
            //表
            if ((map != null && StringUtil.isNotEmpty(map))) {
                JSONObject jasonObject = JSONObject.fromObject(map);
                map1 = jasonObject;
            }
            PropertiesDTO propertiesDTO = this.changeTableIdToTableMessage(tableId);
            /**
             *  //获取浏览器
             *  不同的浏览器的编码不一样
             *  */
            String userAgent = request.getHeader("user-agent");
            String tableExcelName;
            if (userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0
                    || userAgent.indexOf("Safari") >= 0) {
                tableExcelName= new String((propertiesDTO.getExcelName()).getBytes(), "ISO8859-1");
            } else {
                tableExcelName=URLEncoder.encode(propertiesDTO.getExcelName(),"UTF8"); //其他浏览器
            }
            String excelPath = exportService.commonExport(propertiesDTO, josnStr, map1, user,tableExcelName);

            //获取cookie中的数据
            String phone = arsUtil.getCurrentUser().getPhone();
            String cookieName = phone  + tableId;
            /**
             * 将用户的选择记录
             * */
            redisUtil.set(cookieName,josnStr);
            if (excelPath != null) {
                result.setData(excelPath);
                result.setMsg("导出成功");
                result.setSuccessful(true);
            } else {
                result.setMsg("数据为空");
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    @RequestMapping("exportRoster")
    public @ResponseBody AjaxResult exportRoster(ExportRosterDto exportRosterDto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            String excelPath = "";
            if (user !=  null) {
                excelPath = exportService.exportRoster(exportRosterDto);
            }else {
                throw new RuntimeException("当前登录信息错误, user:" + user);
            }
            if (StringUtil.isNotEmpty(excelPath)) {
                result.setData(excelPath);
                result.setMsg("导出成功");
                result.setSuccessful(true);
            } else {
                result.setMsg("数据为空");
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 通过读取配置文件来获取table信息
     * (导出组件)
     *
     * @return com.bcxin.ars.dto.PropertiesDTO
     * @Decription:
     * @author：zhongjianhui
     * @method changeTableIdToTableMessage
     * @date：2018/9/14 14:56
     * @params： * @param tableId
     */
    private PropertiesDTO changeTableIdToTableMessage(String tableId) throws UnsupportedEncodingException {
        //读取配置文件
        ResourceBundle configRb = ResourceBundle.getBundle("config/export/exportMessage");
        //解决中文乱码问题
        String propertiesStr = new String(configRb.getString(tableId).getBytes("ISO-8859-1"), "UTF8");
        PropertiesDTO propertiesDTO = JSON.parseObject(propertiesStr, PropertiesDTO.class);
        return propertiesDTO;
    }

    /**
     * 导出信息
     * (导出组件)
     *
     * @return com.bcxin.ars.dto.PropertiesDTO
     * @Decription:
     * @author：zhongjianhui
     * @method changeTableIdToTableMessage
     * @date：2018/9/14 14:56
     * @params： * @param tableId
     */
    @RequestMapping("getExportColumn")
    public @ResponseBody
    ModelAndView getExportColumn(String tableId, String searchParam, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView view = new ModelAndView();
       //导出页面的前端显示
        view.setViewName("export/output");
        try {
            PropertiesDTO propertiesDTO = this.changeTableIdToTableMessage(tableId);
            //获取cookie中的数据
            String phone = arsUtil.getCurrentUser().getPhone();
            //根据用户手机号跟表格id获取缓存中的数据
            String cookieName = phone  + tableId;
            String cookieValue =redisUtil.get(cookieName);

            List<ModelNameDTO> modelNameDTOList = new ArrayList<>();
            List<ModelNameDTO> modelNameDTO= new ArrayList<>();
            if (cookieValue != null) {
                modelNameDTO=JSONArray.parseArray(cookieValue, ModelNameDTO.class);
            }
            modelNameDTOList = exportService.chooseExportColumn(propertiesDTO, modelNameDTO);

            view.addObject("modelNameDTOList", modelNameDTOList);
            view.addObject("searchParam", searchParam);
            view.addObject("tableId", tableId);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }



    /**
     * 导出信息
     * (导出组件)
     */
    @RequestMapping("toExportColumnPage")
    public @ResponseBody
    ModelAndView toExportColumnPage(String tableId, String searchParam, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView view = new ModelAndView();
        //导出页面的前端显示
        view.setViewName("export/commonExport");
        try {
            PropertiesDTO propertiesDTO = this.changeTableIdToTableMessage(tableId);
            //获取cookie中的数据
            String phone = arsUtil.getCurrentUser().getPhone();
            //根据用户手机号跟表格id获取缓存中的数据
            String cookieName = phone  + tableId;
            String cookieValue =redisUtil.get(cookieName);

            List<ModelNameDTO> modelNameDTOList = new ArrayList<>();
            List<ModelNameDTO> modelNameDTO= new ArrayList<>();
            if (cookieValue != null) {
                modelNameDTO=JSONArray.parseArray(cookieValue, ModelNameDTO.class);
            }
            modelNameDTOList = exportService.chooseExportColumn(propertiesDTO, modelNameDTO);

            view.addObject("modelNameDTOList", modelNameDTOList);
            view.addObject("searchParam", searchParam);
            view.addObject("tableId", tableId);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }
    /**
     * 导出信息
     * (导出组件)
     */
    @RequestMapping("toExportColumnPageV2")
    public @ResponseBody
    ModelAndView toExportColumnPageV2(String tableId, String searchParam, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView view = new ModelAndView();
        //导出页面的前端显示
        view.setViewName("export/commonExportV2");
        try {
            PropertiesDTO propertiesDTO = this.changeTableIdToTableMessage(tableId);
            //获取cookie中的数据
            String phone = arsUtil.getCurrentUser().getPhone();
            //根据用户手机号跟表格id获取缓存中的数据
            String cookieName = phone  + tableId;
            String cookieValue =redisUtil.get(cookieName);

            List<ModelNameDTO> modelNameDTOList = new ArrayList<>();
            List<ModelNameDTO> modelNameDTO= new ArrayList<>();
            if (cookieValue != null) {
                modelNameDTO=JSONArray.parseArray(cookieValue, ModelNameDTO.class);
            }
            modelNameDTOList = exportService.chooseExportColumn(propertiesDTO, modelNameDTO);


            view.addObject("modelNameDTOList", modelNameDTOList);
            view.addObject("searchParam", searchParam);
            view.addObject("tableId", tableId);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return view;
    }


    @RequestMapping("createDataSyncFile")
    public @ResponseBody
    void createDataSyncFile() {
        syncDataService.createDataSyncFile("", "");
    }
    @RequestMapping("syncData")
    public @ResponseBody
    void syncData() {


    }


    /**
     * 下载证书
     *
     * @param response
     * @throws Exception
     */
    @RequestMapping("download")
    public void exportApprovals(String templateName, HttpServletResponse response) throws Exception {
        File file = new File(templateName);
        if (file != null) {
            ServletOutputStream out = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
            InputStream is = new FileInputStream(file);
            try {
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
                file.delete();
            } catch (Exception e) {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
                file.delete();
            }
        }
    }
}
