package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.CrosscompanySearchDto;
import com.bcxin.ars.dto.sb.SponsorlicenseSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SbBusinessManagement;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Crosscompany;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.service.SbBusinessManagementService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.CrosscompanyService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Map;

/**
 * 跨区域经营保安服务备案
 */
@Controller
@RequestMapping("crosscompany")
public class CrosscompanyController {

    private Logger logger = LoggerFactory.getLogger(CrosscompanyController.class);
    
    @Autowired
    private CrosscompanyService crosscompanyService;

    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private SbBusinessManagementService sbBusinessManagementService;

    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private GXSSOUtil gxssoUtil;
    /**
     * 查询培训单位信息
     * @param dto
     * @return
     */
    

    @Autowired
    private ArsUtil arsUtil;


    @RequestMapping("/searchCrosscompanyList_table")
    @RequiresPermissions("crosscompany:query")
    @ResponseBody
    public PageResult searchCrosscompanyList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                   HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化

        return crosscompanyService.searchCrosscompanyList_table(p);//进行查询，并转换
    }

    @RequestMapping("list/index")
    public ModelAndView listIndex(SponsorlicenseSearchDto searchDto){
        ModelAndView view = new ModelAndView("crosscompany/list2");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @RequiresPermissions("crosscompany:query")
    @ResponseBody
    public AjaxPageResponse searchForPage(CrosscompanySearchDto dto, AjaxPageResponse<Crosscompany> page){
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
            }
        }
        crosscompanyService.searchForPage(dto,page);
        return page;
    }



    @RequestMapping("search")
    public @ResponseBody AjaxResult search(CrosscompanySearchDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
            	if(user.getPlatform()==2){
					dto.setUserid(user.getId());
				}
                result.setSuccessful(true);
                result.setData(crosscompanyService.search(dto));
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("update")
    public @ResponseBody AjaxResult update(Crosscompany crosscompany, HttpSession httpSession) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                crosscompanyService.saveOrUpdate(crosscompany);
                String projectNo= (String) httpSession.getAttribute("projectNo");
                if (StringUtil.isNotEmpty(projectNo)){
                    String token= (String) httpSession.getAttribute("gxssotoken");
                    gxssoUtil.reportData(token,projectNo);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    
    /**
     * 暂存
     * <b>Function </b> 
     * 
     * @param crosscompany
     * @return
     * @throws Exception
     * @author LinQingLin 
     * @date 2017年9月15日 下午2:21:53
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("temporarySave")
    public @ResponseBody AjaxResult temporarySave(Crosscompany crosscompany) throws Exception{
    	AjaxResult result = new AjaxResult();
    	try {
    		User user = arsUtil.getCurrentUser();
    		if(user != null) {
    			result.setSuccessful(true);
    			crosscompanyService.temporarySave(crosscompany);
    		} else {
    			result.setSuccessful(false);
    		}
    	} catch(Exception e) {
    		logger.error(e.getMessage(), e);
    		throw e;
    	}
    	return result;
    }

    /**
     * 根据ID获取明细
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Crosscompany crosscompany = crosscompanyService.findById(id);
            result.setSuccessful(true);
            result.setData(crosscompany);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 根据当前登录用户获取明细
     * @return
     */
    @RequestMapping("findByCurrentUser")
    public @ResponseBody AjaxResult findByCurrentUser() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Crosscompany crosscompany = crosscompanyService.findByUser(user.getId());
                if(crosscompany != null){
                    result.setSuccessful(true);
                    result.setData(crosscompany);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("updateApprovalResult")
    public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Crosscompany crosscompany = crosscompanyService.findById(businessid);
                if(crosscompany != null){
                    crosscompany.setLegalcensorstatus(approvalstate);
                    crosscompanyService.updateCensorStatus(crosscompany);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("plan/updateApprovalResult")
    public @ResponseBody AjaxResult updatePlanApprovalResult(Long businessid,String approvalstate){
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                Crosscompany  crosscompany = crosscompanyService.findById(businessid);
                if(crosscompany != null){
                    crosscompany.setChargecensorstatus(approvalstate);
                    crosscompanyService.updateCensorStatus(crosscompany);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 账号生成
     * @return
     */
    @RequestMapping("buildAccount/{id}")
    public @ResponseBody AjaxResult buildAccount(@PathVariable("id")Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Crosscompany crosscompany = crosscompanyService.findById(id);

            Sysarea sysarea = sysareaService.findByCode(crosscompany.getProvince());
            Sysarea sysarea1 = sysareaService.findByCode(crosscompany.getCity());
            Sysarea sysarea2 = sysareaService.findByCode(crosscompany.getDistrict());

            crosscompany.setProvince(sysarea.getName());
            crosscompany.setCity(sysarea1.getName());
            crosscompany.setDistrict(sysarea2.getName());

            //源实体类的列，目标实体类的列
            String[] srccol = {"province","city","district","szss","chargename","chargephone","chargecardnumber","chargepost"};
            String[] desccol = {"crossCityBusinessProvince","crossCityBusinessCity","crossCityBusinessCounty","crossCityAddress","principal","principalPhone","principalId","jobName"};//
            //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
            String[] key = {};
            String[] value = {};
            //生成实体
            Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,crosscompany,new SbBusinessManagement(),key,value);
            SbBusinessManagement sbBusinessManagement =(SbBusinessManagement)desc;
            sbBusinessManagement.setUserid(crosscompany.getUserid());
            sbBusinessManagementService.saveOrUpdate(sbBusinessManagement);

            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
