package com.bcxin.ars.rest.sb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ConfesscompanypersonSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompanyperson;
import com.bcxin.ars.service.sb.ConfesscompanypersonService;
import com.bcxin.ars.service.util.ArsUtil;

@Controller
@RequestMapping("confesscompanyperson")
public class ConfesscompanypersonController {

	Logger logger = LoggerFactory.getLogger(ConfesscompanypersonController.class);
	
	@Autowired
	private ConfesscompanypersonService confesscompanypersonService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(ConfesscompanypersonSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				ConfesscompanypersonSearchDto list = confesscompanypersonService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Confesscompanyperson confesscompanyperson) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				confesscompanypersonService.saveOrUpdate(confesscompanyperson);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Confesscompanyperson confesscompanyperson = confesscompanypersonService.findById(id);
			result.setSuccessful(true);
			result.setData(confesscompanyperson);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
