package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.page.CerLearnRecordPageSearchDto;
import com.bcxin.ars.model.sb.CerLearnRecord;
import com.bcxin.ars.service.sb.CerLearnRecordService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 资格证/等级证学习记录Controller
 * 
 * @author lin
 * @date 2020-09-08
 */
@Controller
@RequestMapping("/cerLearnRecord")
public class CerLearnRecordController{
    Logger logger = LoggerFactory.getLogger(CerLearnRecordController.class);

    @Autowired
    private CerLearnRecordService cerLearnRecordService;


    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    public ModelAndView listIndex(CerLearnRecordPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("cerLearnRecord/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(CerLearnRecordPageSearchDto dto, AjaxPageResponse<CerLearnRecord> page){
        cerLearnRecordService.searchForPage(dto,page);
        return page;
    }

}
