package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
@RequestMapping("backgroupapproval")
public class BackgroupApprovalController {

    /***
     * 日志
     */
    public static  final  Logger logger = LoggerFactory.getLogger(ChargeworkController.class);

    @Autowired
    private BackgroundApprovalService backgroundApprovalService;

    /***
     * 查询背景信息
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping("search")
    public @ResponseBody  AjaxResult search(BackgroundApprovalDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(backgroundApprovalService.query(dto));
        } catch(Exception e) {
            result.setSuccessful(false);
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 查询背景信息
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping("approval")
    public @ResponseBody  AjaxResult approval(BackgroundApprovalDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            backgroundApprovalService.approval(dto);
            result.setSuccessful(true);
        } catch(Exception e) {
            result.setSuccessful(false);
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     *
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping("update")
    public @ResponseBody  AjaxResult update(BackgroundApprovalDto dto) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            backgroundApprovalService.update(dto);
            result.setSuccessful(true);
        } catch(Exception e) {
            result.setSuccessful(false);
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


}
