package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ArmorgchargeSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Armorgcharge;
import com.bcxin.ars.model.sb.Armtrainorg;
import com.bcxin.ars.service.sb.ArmorgchargeService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("armorgcharge")
public class ArmorgchargeController {

	Logger logger = LoggerFactory.getLogger(ArmorgchargeController.class);
	
	@Autowired
	private ArmorgchargeService armorgchargeService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(ArmorgchargeSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				ArmorgchargeSearchDto list = armorgchargeService.search(dto);
				if(list.getData() != null && list.getData().size() >0){
					result.setSuccessful(true);
					result.setData(list);
				}else {
					result.setSuccessful(false);
				}
				
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(Armorgcharge armorgcharge) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				armorgchargeService.saveOrUpdate(armorgcharge);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Armorgcharge armorgcharge = armorgchargeService.findById(id);
			result.setSuccessful(true);
			result.setData(armorgcharge);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("updateApprovalResult")
	public @ResponseBody AjaxResult updateApprovalResult(Long businessid,String approvalstate){
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				Armorgcharge armorgcharge = armorgchargeService.findById(businessid);
				if(armorgcharge != null){
					armorgcharge.setCensorstatus(approvalstate);
					armorgchargeService.updateCensorStatus(armorgcharge);
					result.setSuccessful(true);
				}else{
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
