package com.bcxin.ars.rest.msg;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DSNewnoticePoliceDto;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.msg.NewsnoticePoliceSearchDto;
import com.bcxin.ars.dto.page.NewsnoticePolicePageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.*;
import com.bcxin.ars.service.msg.*;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.crypto.BadPaddingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;


@Controller
@RequestMapping("newsnoticePolice")
public class NewsnoticePoliceController {

    /***
     * 日志
     */
	private static  final  Logger logger = LoggerFactory.getLogger(NewsnoticePoliceController.class);


	@Autowired
	private NewsnoticeCompanyService newsnoticeCompanyService;

	@Autowired
	private NewsnoticeRecipientService newsnoticeRecipientService;

	@Autowired
	private NewsCompanyRelationshipService newsCompanyRelationshipService;

	@Autowired
	private SysAttachmentService sysAttachmentService;

	@Autowired
	private NewsnoticePoliceService newsnoticePoliceService;

	@Autowired
	private ArsUtil arsUtil;

	@Value("${ftp-temp-folder}")
	private String tempftpFolder;

	@Value("${temp-folder}")
	private String tempfolder;

	@Value("${base-folder}")
	private String baseFolder;

	@Value("${sysAttachmentFolder}")
	private String sysAttachmentFolder;

    /***
     * 进入公安内部消息发布通知
     */
    @RequestMapping("toQueryPage")
    public ModelAndView toQueryPage(NewsnoticePolicePageSearchDto searchDto){
        ModelAndView view = new ModelAndView();
		view.addObject("record", searchDto);
        view.setViewName("policeNotice/list");
        return view;
    }
    /***
     * 进入公安内部消新增页面
     */
    @RequestMapping("toAddPage")
    public ModelAndView toAddPage(){
        ModelAndView view = new ModelAndView();
        view.setViewName("policeNotice/edit");
        return view;
    }

    /***
     * 进入公安内部消息修改页面
     */
    @RequestMapping("toEditPage")
    public ModelAndView toEditPage(){
        ModelAndView view = new ModelAndView();
        view.setViewName("policeNotice/edit");
        return view;
    }


    /***
     * 进入公安内部消息详细页面
     */
    @RequestMapping("toDetailPage")
    public ModelAndView toDetailPage(){
        ModelAndView view = new ModelAndView();
        view.setViewName("policeNotice/detail");
        return view;
    }


    /***
     * 进入选择用户页面
     */
    @RequestMapping("toChoicePoliceUserPage")
    public ModelAndView toChoiceUserPage(){
        ModelAndView view = new ModelAndView();
        view.setViewName("policeNotice/choicePoliceUser");
        return view;
    }


    /****
     * 获取公安用户列表
     * @return
     * @throws Exception
     */
    @RequestMapping("getPoliceUserTree")
    public @ResponseBody
    AjaxResult getPoliceUserTree() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(newsnoticePoliceService.getPoliceUserTree());
        } catch (Exception e) {
            throw e;
        }
        return result;
    }



	@RequestMapping("queryTable")
    @RequiresPermissions("newNotify:query")
	public @ResponseBody
	Object queryTable(NewsnoticePoliceSearchDto searchDto, HttpServletResponse response) throws Exception {
		try {
			CTLUtil.out(newsnoticePoliceService.queryTable(searchDto), response);//进行查询，并转换
		} catch (Exception e) {
			throw e;
		}
		return null;
	}

	@RequestMapping("findById")
	public @ResponseBody
	AjaxResult findById(Long noticeId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			NewsnoticePolice data = newsnoticePoliceService.findById(noticeId);
			result.setSuccessful(true);
			result.setData(data);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	@RequestMapping("findAllById")
	public @ResponseBody
	AjaxResult findAllById(Long noticeId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			NewsnoticePolice data = newsnoticePoliceService.findAllById(noticeId);
			result.setSuccessful(true);
			result.setData(data);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("save")
	public @ResponseBody
	AjaxResult save(NewsnoticePolice notice) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			notice.setReadnum(0);
			if(notice.getCompanyIds() != null) {
				notice.setUnreadnum(notice.getCompanyIds().length);
			}
			newsnoticePoliceService.saveOrUpdate(notice);
			result.setSuccessful(true);
			result.setData(notice);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("delete")
	public @ResponseBody
	AjaxResult delete(Long noticeId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			newsnoticePoliceService.delete(noticeId);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("batchDelete")
	public @ResponseBody
	AjaxResult batchDelete(Long[] noticeIds) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			newsnoticePoliceService.batchDelete(noticeIds);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("recall")
	public @ResponseBody
	AjaxResult recall(Long noticeId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			newsnoticePoliceService.recall(noticeId);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 批量导出消息通知信息
	 *
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping("exportNotices")
	public void exportNotices(String templateName, HttpServletResponse response) throws Exception {
		User user = arsUtil.getCurrentUser();
		if (user != null) {
			File file = new File(templateName);
			if (file != null) {
				ServletOutputStream out = response.getOutputStream();
//				String fileName = new String(file.getName().substring(file.getName().indexOf("_")+1).getBytes("UTF-8"),"iso-8859-1");
				response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
				InputStream is = new FileInputStream(file);
				int read = 0;
				byte[] buffer = new byte[8192];
				while ((read = is.read(buffer)) != -1) {
					out.write(buffer, 0, read);
				}
				is.close();
				out.flush();
				out.close();
				file.delete();
			}
		}
	}

	/**
	 * 批量导出消息通知（仅适用与内网数据导入到外网）
	 */
	@RequestMapping("exportData")
	public @ResponseBody
	AjaxResult exportData(String startDate) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				List<String> filePaths = new ArrayList<String>();
				//消息通知
				List<NewsnoticePolice> newsnoticePoliceList = newsnoticePoliceService.findDSOutList(startDate);
				List<NewsCompanyRelationship> newsCompanyRelationshipList = newsCompanyRelationshipService.findDSOutList(startDate);
				List<NewsnoticeCompany> newsnoticeCompanyList = newsnoticeCompanyService.findDSOutList(startDate);
				List<NewsnoticeRecipient> newsnoticeRecipientList = newsnoticeRecipientService.findDSOutList(startDate);
				List<SysAttachment> sysAttachmentList = sysAttachmentService.findDSOutList(filePaths,startDate);

				if (newsnoticePoliceList != null && newsnoticePoliceList.size() > 0) {
					try {

						DataSycDto dataSycDto = new DataSycDto();
						DSNewnoticePoliceDto dto = new DSNewnoticePoliceDto();
						dto.setNewsnoticeList(newsnoticePoliceList);
						dto.setNewsCompanyRelationshipList(newsCompanyRelationshipList);
						dto.setNewsnoticeCompanyList(newsnoticeCompanyList);
						dto.setNewsnoticeRecipientList(newsnoticeRecipientList);
						dto.setSysAttachmentList(sysAttachmentList);

						for (SysAttachment sysAttachment : sysAttachmentList) {
							if (StringUtil.isNotEmpty(sysAttachment.getPath())) {
								filePaths.add(sysAttachmentFolder + sysAttachment.getPath().replace("getResource.do?path=sysAttachment/", ""));
							}
						}

						dataSycDto.setDataType(Constants.DATASYC_NOTICE_LIST);
						dataSycDto.setData(JSONObject.toJSONString(dto));

						Date now = new Date();
						String dirDate = DateUtil.systemDate.format(now);
						File dir = new File(tempfolder + dirDate);
						if (!dir.exists()) {
							dir.mkdirs();
						}
						String listStr = JSONObject.toJSONString(dataSycDto);

						String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));
						String filepath = FileUtil.writeTxtFile(content, "newsnoticePolice", tempfolder);

						if (StringUtil.isNotEmpty(filepath)) {
							filePaths.add(filepath);
							result.setData(FileUtil.zipFiles(filePaths, tempfolder + FileUtil.generatingFileNameByDate("newsnoticePolice") + ".zip"));
							result.setSuccessful(true);
						} else {
							result.setSuccessful(false);
							result.setMsg("导出失败，请联系系统管理员确认！");
						}

					}  catch (BadPaddingException badPaddingException){
						logger.error(badPaddingException.getMessage(), badPaddingException);
						throw new ArsException("导入失败，非该区域数据\n！");
					}  catch (Exception e) {
						logger.error(e.getMessage(),e);
					}
				}
			} else {
				result.setSuccessful(false);
			}
		}   catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/**
	 * 批量导入消息通知
	 */
	@RequestMapping("importData")
	public @ResponseBody
	AjaxResult importData(MultipartFile file, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			if (!file.getOriginalFilename().startsWith("newsnoticePolice")) {
				throw new ArsException("导入失败，非消息通知的数据！");
			}

			Map<String, String> pathMap = new HashMap<>();
			List<String> filePaths = new ArrayList<String>();
			Date now = new Date();
			String fileName = now.getTime() + "_" + file.getOriginalFilename();
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(tempfolder + dirDate);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			String targetPath = tempfolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行文件上传..." + targetFile);
			file.transferTo(targetFile);
			File dataFile = null;
			long startTime = System.currentTimeMillis();
			try {
				ZipInputStream Zin = new ZipInputStream(new FileInputStream(targetFile));//输入源zip路径
				BufferedInputStream Bin = new BufferedInputStream(Zin);
				String Parent = tempfolder; //输出路径（文件夹目录）
				File Fout = null;
				ZipEntry entry;
				try {
					while ((entry = Zin.getNextEntry()) != null && !entry.isDirectory()) {
						Fout = new File(Parent, entry.getName());
						if (!Fout.exists()) {
							(new File(Fout.getParent())).mkdirs();
						}
						FileOutputStream out = new FileOutputStream(Fout);
						BufferedOutputStream Bout = new BufferedOutputStream(out);
						int b;
						while ((b = Bin.read()) != -1) {
							Bout.write(b);
						}
						Bout.close();
						out.close();
						if (Fout.getName().endsWith(".data")) {
							dataFile = Fout;
						} else {
							pathMap.put(Fout.getName(), Fout.getPath());
						}
						filePaths.add(Fout.getPath());
						logger.info(Fout + "解压成功");
					}
					Bin.close();
					Zin.close();
				} catch (IOException e) {
					logger.info(e.getMessage());
				}
			} catch (FileNotFoundException e) {
				logger.info(e.getMessage());
			}
			long endTime = System.currentTimeMillis();
			targetFile.delete();
			logger.info("耗费时间： " + (endTime - startTime) + " ms");
			if (dataFile != null) {
				BufferedReader br = new BufferedReader(new FileReader(dataFile));
				StringBuffer content = new StringBuffer();
				// 获取文件内容
				String lineTxt = null;
				while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
					content.append(lineTxt);
				}
				br.close();

				String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));

				DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);

				if (dataSycDto != null) {
					if (dataSycDto.getDataType().equals(Constants.DATASYC_NOTICE_LIST)) {

							try {
								DSNewnoticePoliceDto dto = JSONObject.parseObject(dataSycDto.getData(), DSNewnoticePoliceDto.class);

								if (dto != null) {
									List<NewsnoticePolice> newsnoticePoliceList = dto.getNewsnoticeList();

									List<NewsCompanyRelationship> newsCompanyRelationshipList = dto.getNewsCompanyRelationshipList();
									List<NewsnoticeCompany> newsnoticeCompanyList = dto.getNewsnoticeCompanyList();
									List<NewsnoticeRecipient> newsnoticeRecipientList = dto.getNewsnoticeRecipientList();
									List<SysAttachment> sysAttachmentList = dto.getSysAttachmentList();

									if (newsCompanyRelationshipList != null && newsCompanyRelationshipList.size() > 0) {
											newsCompanyRelationshipService.importBatch(newsCompanyRelationshipList);
									}
									/*if (newsnoticeCompanyList != null && newsnoticeCompanyList.size() > 0) {
										for (NewsnoticeCompany newsnoticeCompany : newsnoticeCompanyList) {
											newsnoticeCompanyService.saveOrUpdateForImport(newsnoticeCompany);
										}
									}*/
									if (newsnoticeRecipientList != null && newsnoticeRecipientList.size() > 0) {
											newsnoticeRecipientService.importBatch(newsnoticeRecipientList);
									}
									if (sysAttachmentList != null && sysAttachmentList.size() > 0) {
											sysAttachmentService.importBatch(sysAttachmentList, pathMap);
									}

									//if (newsnoticePoliceList != null && newsnoticePoliceList.size() > 0) {
									//	for (NewsnoticePolice police : newsnoticePoliceList) {
									//		newsnoticePoliceService.saveOrUpdateForImport(police);
									//	}
									//}
								}

							} catch (Exception e) {
								logger.error(e.getMessage(), e);
							}
						result.setMsg("导入成功！");
						result.setSuccessful(true);
					} else {
						result.setMsg("导入失败，非消息通知的数据！");
						result.setSuccessful(false);
					}
				} else {
					result.setMsg("导入失败，非消息通知的数据！");
					result.setSuccessful(false);
				}
			}
			for (String filePath : filePaths) {
				FileUtil.deleteFolder(filePath);
			}

			Map<String, Object> resultMap = new HashMap<String, Object>();
			resultMap.put("faildFilePath", "");
			result.setData(resultMap);
		} catch (BadPaddingException badPaddingException){
			logger.error(badPaddingException.getMessage(), badPaddingException);
			throw new ArsException("导入失败，非该区域数据\n！");
		}  catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 管理列表页面
	 * @return
	 */
	@RequestMapping("comList/index")
	public ModelAndView listIndex(NewsnoticePolicePageSearchDto searchDto){
		ModelAndView view = new ModelAndView("comNotice/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(NewsnoticePolicePageSearchDto dto, AjaxPageResponse<NewsnoticePolice> page){
		newsnoticePoliceService.searchForPage(dto,page);
		return page;
	}
}