package com.bcxin.ars.rest.msg;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.msg.NewsnoticeCompanySearchDto;
import com.bcxin.ars.dto.page.ApprovalPageSearchDto;
import com.bcxin.ars.dto.page.NewsnoticePolicePageSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.NewsnoticeCompany;
import com.bcxin.ars.model.msg.NewsnoticePolice;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.msg.NewsnoticeCompanyService;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/***
 * 公司消息通知信息控制层
 * @author subh
 */
@Controller
@RequestMapping("newsnoticecompany")
public class NewsnoticeCompanyController {
    /***
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(NewsnoticeCompanyController.class);

    @Autowired
    private NewsnoticeCompanyService newsnoticeCompanyService;

    @Autowired
    private ArsRestUtil arsUtil;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    /****
     * 消息保存回复功能
     * @param newsnoticeCompany
     * @return
     */
    @RequestMapping("save")
    public @ResponseBody
    AjaxResult save(NewsnoticeCompany newsnoticeCompany){
        AjaxResult result = new AjaxResult();
        try {
            newsnoticeCompanyService.saveOrUpdate(newsnoticeCompany);
            result.setSuccessful(true);
            result.setData(newsnoticeCompany);
            result.setMsg("操作完成！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }



    @RequestMapping("search")
    public @ResponseBody
    AjaxResult search(NewsnoticeCompanySearchDto dto) throws Exception {
        //查询公司
        User user = arsUtil.getCurrentUser();
        SecurityCompany securityCompany = securityCompanyService.findByUserid(user.getId());
        AjaxResult result = new AjaxResult();
        try {
            if (securityCompany != null) {
                dto.setCompanyId(securityCompany.getId());
                NewsnoticeCompanySearchDto list = newsnoticeCompanyService.search(dto);
                result.setSuccessful(true);
                result.setData(list);
            } else {
                result.setSuccessful(false);
                result.setMsg("该公司不存在");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /****
     * 查询消息列表
     * @param params
     * @param model
     * @param req
     * @param resp
     * @return
     */
    @RequestMapping("/searchNewsnoticeCompanyList_table")
    @ResponseBody
    public Object searchNewsnoticeCompanyList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                    HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        User user = arsUtil.getCurrentUser();
        //接收人Id为必要条件
        if(Constants.PLATFORM_POLICE == user.getPlatform()) {
            p.put("companyId", user.getId());
        }else{
            //获取公司信息
            SecurityCompany company =  securityCompanyService.findByUserid(user.getId());
            p.put("companyId", company.getId());
        }
        CTLUtil.out(newsnoticeCompanyService.searchNewsnoticeCompanyList_table(p), resp);//进行查询，并转换
        return null;
    }


    @RequestMapping("index/list")
    public ModelAndView listIndex(NewsnoticeCompanySearchDto  searchDto ){
        ModelAndView view = new ModelAndView("newsnotice/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(NewsnoticeCompanySearchDto dto, AjaxPageResponse<NewsnoticeCompany> page){

        User user = arsUtil.getCurrentUser();
//        接收人Id为必要条件
        if(Constants.PLATFORM_POLICE == user.getPlatform()) {
            dto.setCompanyId(user.getId());

        }else{
            //获取公司信息
            SecurityCompany company =  securityCompanyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        }
        newsnoticeCompanyService.searchForPage(dto,page);
        return page;
    }







    /****
     * 查询消息列表
     * @param params
     * @param req
     * @param resp
     * @return
     */
    @RequestMapping("/searchNewsnoticeCompanyReplyListForPolice")
    @ResponseBody
    public Object searchNewsnoticeCompanyReplyListForPolice(@RequestParam Map<Object, Object> params,
                                                    HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        if(params.get("newsnoticeId")!=null) {
            CTLUtil.out(newsnoticeCompanyService.searchNewsnoticeCompanyReplyListForPolice(p), resp);//进行查询，并转换
        }
        return null;
    }

    /****
     * 查询消息列表
     * @param params
     * @param req
     * @param resp
     * @return
     */
    @RequestMapping("/searchNewsnoticeCompanyReplyListForCompany")
    @ResponseBody
    public Object searchNewsnoticeCompanyReplyListForCompany(@RequestParam Map<Object, Object> params,
                                                            HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        if(params.get("newsnoticeId")!=null) {
            CTLUtil.out(newsnoticeCompanyService.searchNewsnoticeCompanyReplyListForCompany(p), resp);//进行查询，并转换
        }
        return null;
    }







    /**
     * 根据申请ID更新已读未读状态
     *
     * @return
     */
    @RequestMapping("updateReadstateByidArr")
    public @ResponseBody
    AjaxResult updateReadstateByidArr(Long[] idArray) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                newsnoticeCompanyService.updateReadstateByIdForPolice(idArray);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 全部标识已读
     *
     * @return
     */
    @RequestMapping("updateReaded")
    public @ResponseBody
    AjaxResult updateReaded(NewsnoticeCompanySearchDto newsnoticeCompany) throws Exception {
        User user = arsUtil.getCurrentUser();
        SecurityCompany securityCompany = securityCompanyService.findByUserid(user.getId());
        AjaxResult result = new AjaxResult();
        try {
            if (securityCompany != null) {
                newsnoticeCompany.setCompanyId(securityCompany.getId());
                newsnoticeCompanyService.updateReaded(newsnoticeCompany);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("该公司不存在");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;

    }

    /**
     * 根据ID获取明细
     *
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody
    AjaxResult findById(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            NewsnoticeCompany newsnoticeCompany = newsnoticeCompanyService.findById(id);
            result.setSuccessful(true);
            result.setData(newsnoticeCompany);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
