package com.bcxin.ars.rest.mobile.certificate.train;

import com.bcxin.ars.model.certificate.TrainCertificate;
import com.bcxin.ars.service.certificate.TrainCertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.CerUtil;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

/**
 * 培训学校电子证书
 */
@Controller
@RequestMapping("mobile/trainCertificate")
public class TrainCertificateMobileController {

	/**
	 * 日志
	 */
	private static  final   Logger logger = LoggerFactory.getLogger(TrainCertificateMobileController.class);
	@Autowired
	private TrainCertificateService trainCertificateService;
	@Autowired
	private ConfigUtils configUtils;

	@RequestMapping("find/{id}")
	public ModelAndView find(@PathVariable Long id,String type) {
		/**
         * 证书信息
		 */
		TrainCertificate trainCertificate=trainCertificateService.findById(id);

		try {
			//判断注册资金是否为空
			if(trainCertificate.getZczb()!=null) {
				trainCertificate.setZczb(CerUtil.digitUppercase(Double.parseDouble(trainCertificate.getZczb())));
			}
			String zkzh = configUtils.getValueByKey(Constants.CURRENT_NATIVE_SHORT);
			zkzh = zkzh + "公保培";
			trainCertificate.setXkzh(trainCertificate.getXkzh().replace(zkzh,""));
		}catch (Exception e){
			logger.error("培训单位许可证注册奖金转换失败");
		}
		ModelAndView view = new ModelAndView();
		//正本页面
		if(Constants.CERPRINTTYPE_Z.equals(type)) {
			view.setViewName("mobile/certificate/train");
		}else{
			//副本页面
			view.setViewName("mobile/certificate/trainCopy");
		}
		view.addObject("record",trainCertificate);
		return view;
	}

}
