package com.bcxin.ars.rest.mobile.certificate.company;

import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.bcxin.ars.service.certificate.CompanyCertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.CerUtil;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

/**
 * 保安服务公司电子证书
 */
@Controller
@RequestMapping("mobile/companyCertificate")
public class CompanyCertificateMobileController {

	/**
	 * 日志
	 */
	private static  final   Logger logger = LoggerFactory.getLogger(CompanyCertificateMobileController.class);
	@Autowired
	private CompanyCertificateService companyCertificateService;

	@Autowired
	private ConfigUtils configUtils;

	@RequestMapping("find/{id}")
	public ModelAndView find(@PathVariable Long id,String type) {
		/**
		 * 证书信息
		 */
		CompanyCertificate companyCertificate=companyCertificateService.findById(id);
		try {
			//判断注册资本是否为空
			if(companyCertificate.getZczb()!=null) {
				companyCertificate.setZczb(CerUtil.digitUppercase(Double.parseDouble(companyCertificate.getZczb())));
			}
			companyCertificate.setFwfw(CerUtil.formatManagement(companyCertificate.getFwfw(),null));

			String zkzh = configUtils.getValueByKey(Constants.CURRENT_NATIVE_SHORT);
			zkzh = zkzh + "公保服";
			companyCertificate.setXkzh(companyCertificate.getXkzh().replace(zkzh,""));

		}catch (Exception e){
			logger.error("保安服务公司许可证注册奖金或者服务范围转换失败");
		}
		ModelAndView view = null;
		//正本页面
		if(Constants.CERPRINTTYPE_Z.equals(type)) {
			view = new ModelAndView("mobile/certificate/company");
		}else{
			//副本页面
			view = new ModelAndView("mobile/certificate/companyCopy");
		}
		view.addObject("record",companyCertificate);
		return view;

	}

}
