package com.bcxin.ars.rest.mobile;

import com.bcxin.ars.dto.task.ComTaskDto;
import com.bcxin.ars.service.supervision.CompanyInspectionService;
import com.bcxin.ars.service.task.ComTaskService;
import com.bcxin.ars.service.util.ConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

/**
 * @author linqinglin
 * @date 2020/02/18 0018 13:07
 */
@RequestMapping("mobile/task")
@Controller
public class MobileTaskController {


    @Autowired
    private ComTaskService comTaskService;

    @Autowired
    private CompanyInspectionService companyInspectionService;

    @Autowired
    private ConfigUtils configUtils;

    /**
     * 驻勤点列表
     * @param name
     * @return
     */
    @RequestMapping("/list")
    public ModelAndView detail(String name) {
        ModelAndView view = new ModelAndView("mobile/task/list");
        view.addObject("name",name);
        return view;
    }

    /**
     * 驻勤点详情列表
     * @param comId
     * @return
     */
    @RequestMapping("/detailList")
    public ModelAndView detailList(Long comId) {
        ModelAndView view = new ModelAndView("mobile/task/detailList");
        view.addObject("comId",comId);
        return view;
    }

    /**
     * 驻勤点详情
     * @param id
     * @return
     */
    @RequestMapping("/detail")
    public ModelAndView detail(Long id) {
        ModelAndView view = new ModelAndView("mobile/task/detail");
        view.addObject("record",comTaskService.findDetailById(id));
        return view;
    }


    /**
     * 新增监督检查
     * @param comTaskDto
     * @return
     */
    @RequestMapping("/inspection")
    public ModelAndView inspection(ComTaskDto comTaskDto) {
        ModelAndView view = new ModelAndView("mobile/task/inspection");
        view.addObject("record",comTaskDto);
        view.addObject("token", configUtils.getToken());
        return view;
    }
    /**
     * 监督检查详情
     * @param id
     * @return
     */
    @RequestMapping("/inspection/detail")
    public ModelAndView inspectionDetail(Long id,String routeType) {
        ModelAndView view = new ModelAndView("mobile/task/inspectionDetail");
        view.addObject("record",companyInspectionService.findById(id));
        view.addObject("routeType",routeType);
        return view;
    }

}
